/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.WebAndEjbToJaasBridge;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.web.integration.WebProgrammaticLogin;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.jvnet.hk2.annotations.Service;

@Service
public class WebProgrammaticLoginImpl
implements WebProgrammaticLogin {
    public static final String WEBAUTH_PROGRAMMATIC = "PROGRAMMATIC";
    private static Logger logger = LogDomains.getLogger(WebProgrammaticLoginImpl.class, (String)"javax.enterprise.system.core.security");

    public Boolean login(String user, char[] password, String realm, HttpServletRequest request, HttpServletResponse response) {
        Session realSession;
        Request unwrappedCoyoteRequest = WebProgrammaticLoginImpl.getUnwrappedCoyoteRequest(request);
        if (unwrappedCoyoteRequest == null) {
            return false;
        }
        WebAndEjbToJaasBridge.login((String)user, (char[])password, (String)realm);
        SecurityContext securityContext = SecurityContext.getCurrent();
        WebPrincipal principal = new WebPrincipal(user, password, securityContext);
        unwrappedCoyoteRequest.setUserPrincipal((Principal)principal);
        unwrappedCoyoteRequest.setAuthType(WEBAUTH_PROGRAMMATIC);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Programmatic login set principal in http request to: " + user);
        }
        if ((realSession = WebProgrammaticLoginImpl.getSession(unwrappedCoyoteRequest)) != null) {
            realSession.setPrincipal((Principal)principal);
            realSession.setAuthType(WEBAUTH_PROGRAMMATIC);
            logger.fine("Programmatic login set principal in session.");
        } else {
            logger.fine("Programmatic login: No session available.");
        }
        return true;
    }

    public Boolean logout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Request unwrappedCoyoteRequest = WebProgrammaticLoginImpl.getUnwrappedCoyoteRequest(request);
        if (unwrappedCoyoteRequest == null) {
            return false;
        }
        WebAndEjbToJaasBridge.logout();
        unwrappedCoyoteRequest.setUserPrincipal(null);
        unwrappedCoyoteRequest.setAuthType(null);
        logger.fine("Programmatic logout removed principal from request.");
        Session realSession = WebProgrammaticLoginImpl.getSession(unwrappedCoyoteRequest);
        if (realSession != null) {
            realSession.setPrincipal(null);
            realSession.setAuthType(null);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Programmatic logout removed principal from session.");
            }
        }
        return true;
    }

    private static Request getUnwrappedCoyoteRequest(HttpServletRequest request) {
        Request unwrappedCoyoteRequest = null;
        ServletRequest servletRequest = request;
        try {
            HttpServletRequest prevServletRequest = null;
            while (servletRequest != prevServletRequest && servletRequest instanceof ServletRequestWrapper) {
                prevServletRequest = servletRequest;
                servletRequest = ((ServletRequestWrapper)servletRequest).getRequest();
            }
            if (servletRequest instanceof RequestFacade) {
                unwrappedCoyoteRequest = ((RequestFacade)servletRequest).getUnwrappedCoyoteRequest();
            }
        }
        catch (AccessControlException ex) {
            logger.fine("Programmatic login faiied to get request");
        }
        return unwrappedCoyoteRequest;
    }

    private static Session getSession(Request request) {
        Manager manager;
        Context context;
        HttpSession session = request.getSession(false);
        if (session != null && (context = request.getContext()) != null && (manager = context.getManager()) != null) {
            String sessionId = session.getId();
            try {
                return manager.findSession(sessionId);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

