/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms;

import java.lang.annotation.Annotation;
import java.security.Principal;
import javax.enterprise.inject.spi.CDI;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.Password;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;
import org.glassfish.soteria.Utils;

public class BasicAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private final BasicAuthenticationMechanismDefinition basicAuthenticationMechanismDefinition;

    public BasicAuthenticationMechanism(BasicAuthenticationMechanismDefinition basicAuthenticationMechanismDefinition) {
        this.basicAuthenticationMechanismDefinition = basicAuthenticationMechanismDefinition;
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMsgContext) throws AuthenticationException {
        IdentityStoreHandler identityStoreHandler;
        CredentialValidationResult result;
        Object[] credentials = this.getCredentials(request);
        if (!Utils.isEmpty(credentials) && credentials.length > 1 && (result = (identityStoreHandler = (IdentityStoreHandler)CDI.current().select(IdentityStoreHandler.class, new Annotation[0]).get()).validate((Credential)new UsernamePasswordCredential((String)credentials[0], new Password((String)credentials[1])))).getStatus() == CredentialValidationResult.Status.VALID) {
            return httpMsgContext.notifyContainerAboutLogin((Principal)result.getCallerPrincipal(), result.getCallerGroups());
        }
        if (httpMsgContext.isProtected()) {
            response.setHeader("WWW-Authenticate", String.format("Basic realm=\"%s\"", this.basicAuthenticationMechanismDefinition.realmName()));
            return httpMsgContext.responseUnauthorized();
        }
        return httpMsgContext.doNothing();
    }

    private String[] getCredentials(HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        if (!Utils.isEmpty(authorizationHeader) && authorizationHeader.startsWith("Basic ")) {
            return new String(DatatypeConverter.parseBase64Binary((String)authorizationHeader.substring(6))).split(":");
        }
        return null;
    }
}

