/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.node;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.AbstractBundleNode;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.webservices.connector.LogUtils;
import org.glassfish.webservices.node.WebServiceNode;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Service
public class WebServicesDescriptorNode
extends AbstractBundleNode<BundleDescriptor> {
    public static final XMLElement ROOT_ELEMENT = new XMLElement("webservices");
    public static final String SCHEMA_ID = "javaee_web_services_1_4.xsd";
    public static final String SCHEMA_ID_12 = "javaee_web_services_1_2.xsd";
    public static final String SCHEMA_ID_13 = "javaee_web_services_1_3.xsd";
    public static final String SPEC_VERSION = "1.3";
    private static final List<String> systemIDs = WebServicesDescriptorNode.initSystemIDs();
    private static final Logger logger = LogUtils.getLogger();
    private BundleDescriptor bundleDescriptor;

    private static List<String> initSystemIDs() {
        ArrayList<String> sysIDs = new ArrayList<String>();
        sysIDs.add(SCHEMA_ID);
        sysIDs.add(SCHEMA_ID_12);
        sysIDs.add(SCHEMA_ID_13);
        return Collections.unmodifiableList(sysIDs);
    }

    public WebServicesDescriptorNode() {
        this(null);
    }

    public WebServicesDescriptorNode(BundleDescriptor descriptor) {
        this.bundleDescriptor = descriptor;
        this.registerElementHandler(new XMLElement("webservice-description"), WebServiceNode.class);
        SaxParserHandler.registerBundleNode(this, "webservices");
    }

    @Override
    public String registerBundle(Map<String, String> publicIDToSystemIDMapping) {
        return ROOT_ELEMENT.getQName();
    }

    @Override
    public Map<String, Class<?>> registerRuntimeBundle(Map<String, String> publicIDToSystemIDMapping, Map<String, List<Class<?>>> versionUpgrades) {
        return Collections.emptyMap();
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return ROOT_ELEMENT;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("version".equals(element.getQName())) {
            this.bundleDescriptor.getWebServices().setSpecVersion(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public void addDescriptor(Object descriptor) {
        WebServicesDescriptor webServicesDesc = this.bundleDescriptor.getWebServices();
        WebService webService = (WebService)((Object)descriptor);
        webServicesDesc.addWebService(webService);
        for (WebServiceEndpoint next : webService.getEndpoints()) {
            if (next.resolveComponentLink()) continue;
            logger.log(Level.INFO, "AS-WSCONNECTOR-00204", new Object[]{next.getEndpointName(), next.getLinkName()});
        }
    }

    @Override
    public BundleDescriptor getDescriptor() {
        return this.bundleDescriptor;
    }

    @Override
    public Node writeDescriptor(Node parent, BundleDescriptor descriptor) {
        if (parent instanceof Document) {
            Node topNode = super.writeDescriptor(parent, descriptor);
            WebServicesDescriptor webServicesDesc = descriptor.getWebServices();
            WebServiceNode wsNode = new WebServiceNode();
            for (WebService next : webServicesDesc.getWebServices()) {
                wsNode.writeDescriptor(topNode, "webservice-description", next);
            }
        }
        return parent;
    }

    @Override
    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

