/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.Parameter;
import org.glassfish.hk2.classmodel.reflect.ParameterizedType;
import org.glassfish.hk2.classmodel.reflect.impl.ParameterImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ParameterizedTypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeBuilder;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;

public class MethodSignatureVisitorImpl
extends SignatureVisitor {
    private final TypeBuilder typeBuilder;
    private final MethodModel methodModel;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final List<ParameterizedType> exceptionTypes = new ArrayList<ParameterizedType>();
    private final ParameterizedType returnType = new ParameterizedTypeImpl();
    private final ArrayDeque<ParameterizedType> parentType = new ArrayDeque();

    public MethodSignatureVisitorImpl(TypeBuilder typeBuilder, MethodModel methodModel) {
        super(458752);
        this.typeBuilder = typeBuilder;
        this.methodModel = methodModel;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<ParameterizedType> getExceptionTypes() {
        return this.exceptionTypes;
    }

    public ParameterizedType getReturnType() {
        return this.returnType;
    }

    public SignatureVisitor visitParameterType() {
        ParameterImpl parameter = new ParameterImpl(this.parameters.size(), null, this.methodModel);
        this.parameters.add(parameter);
        this.parentType.add(parameter);
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.parentType.add(this.returnType);
        return this;
    }

    public void visitTypeVariable(String typeVariable) {
        if (!this.parentType.isEmpty()) {
            ParameterizedType current = this.parentType.peekLast();
            if (current instanceof ParameterImpl && ((ParameterImpl)current).getTypeProxy() == null && ((ParameterImpl)current).getFormalType() == null) {
                ((ParameterImpl)current).setFormalType(typeVariable);
            } else if (current instanceof ParameterizedTypeImpl && ((ParameterizedTypeImpl)current).getTypeProxy() == null && ((ParameterizedTypeImpl)current).getFormalType() == null) {
                ((ParameterizedTypeImpl)current).setFormalType(typeVariable);
            } else {
                ParameterizedTypeImpl parameterizedType = new ParameterizedTypeImpl(typeVariable);
                current.getParameterizedTypes().add(parameterizedType);
            }
        }
    }

    public void visitClassType(String name) {
        String className = Type.getObjectType((String)name).getClassName();
        TypeProxy typeProxy = this.typeBuilder.getHolder(className);
        if (typeProxy != null && !this.parentType.isEmpty()) {
            ParameterizedType current = this.parentType.peekLast();
            if (current instanceof ParameterImpl && ((ParameterImpl)current).getTypeProxy() == null) {
                ((ParameterImpl)current).setTypeProxy(typeProxy);
            } else if (current instanceof ParameterizedTypeImpl && ((ParameterizedTypeImpl)current).getTypeProxy() == null) {
                ((ParameterizedTypeImpl)current).setTypeProxy(typeProxy);
            } else {
                ParameterizedTypeImpl parameterizedType = new ParameterizedTypeImpl(typeProxy);
                current.getParameterizedTypes().add(parameterizedType);
                this.parentType.add(parameterizedType);
            }
        }
    }

    public SignatureVisitor visitTypeArgument(char c) {
        return this;
    }

    public void visitEnd() {
        this.parentType.pollLast();
    }
}

