/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerSchedule;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.ejb.containers.TimerWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public class EJBTimerServiceWrapper
implements TimerService {
    private EJBTimerService persistentTimerService_;
    private EJBTimerService nonPersistentTimerService_;
    private EJBContextImpl ejbContext_;
    private EjbDescriptor ejbDescriptor_;
    private boolean entity_;
    private Object timedObjectPrimaryKey_;

    public EJBTimerServiceWrapper(EJBTimerService persistentTimerService, EJBTimerService nonPersistentTimerService, EJBContextImpl ejbContext) {
        this.persistentTimerService_ = persistentTimerService;
        this.nonPersistentTimerService_ = nonPersistentTimerService;
        this.ejbContext_ = ejbContext;
        BaseContainer container = (BaseContainer)ejbContext.getContainer();
        this.ejbDescriptor_ = container.getEjbDescriptor();
        this.entity_ = ejbContext instanceof EntityContext;
        this.timedObjectPrimaryKey_ = null;
    }

    @Override
    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkDuration(duration);
        return this.createTimerInternal(duration, 0L, info);
    }

    @Override
    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkInitialDuration(initialDuration);
        return this.createTimerInternal(initialDuration, intervalDuration, info);
    }

    @Override
    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkExpiration(expiration);
        return this.createTimerInternal(expiration, 0L, info);
    }

    @Override
    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkExpiration(initialExpiration);
        return this.createTimerInternal(initialExpiration, intervalDuration, info);
    }

    @Override
    public Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkDuration(duration);
        return this.createTimerInternal(duration, 0L, timerConfig);
    }

    @Override
    public Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkInitialDuration(initialDuration);
        return this.createTimerInternal(initialDuration, intervalDuration, timerConfig);
    }

    @Override
    public Timer createSingleActionTimer(Date initialExpiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkExpiration(initialExpiration);
        return this.createTimerInternal(initialExpiration, 0L, timerConfig);
    }

    @Override
    public Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkExpiration(initialExpiration);
        return this.createTimerInternal(initialExpiration, intervalDuration, timerConfig);
    }

    @Override
    public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkScheduleExpression(schedule);
        return this.createTimerInternal(schedule, timerConfig);
    }

    @Override
    public Timer createCalendarTimer(ScheduleExpression schedule) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkScheduleExpression(schedule);
        TimerConfig tc = new TimerConfig();
        tc.setInfo(null);
        return this.createTimerInternal(schedule, tc);
    }

    @Override
    public Collection<Timer> getTimers() throws IllegalStateException, EJBException {
        this.checkCallPermission();
        HashSet<Timer> timerWrappers = new HashSet<Timer>();
        timerWrappers.addAll(this.getTimers(this.persistentTimerService_));
        timerWrappers.addAll(this.getTimers(this.nonPersistentTimerService_));
        return timerWrappers;
    }

    private Collection<Timer> getTimers(EJBTimerService timerService_) throws IllegalStateException, EJBException {
        HashSet<Timer> timerWrappers = new HashSet<Timer>();
        Collection<Object> timerIds = new HashSet();
        if (timerService_ != null && this.ejbContext_.isTimedObject()) {
            try {
                timerIds = timerService_.getTimerIds(this.ejbDescriptor_.getUniqueId(), this.getTimedObjectPrimaryKey());
            }
            catch (Exception fe) {
                EJBException ejbEx = new EJBException();
                ejbEx.initCause(fe);
                throw ejbEx;
            }
        }
        for (TimerPrimaryKey next : timerIds) {
            timerWrappers.add(new TimerWrapper(next, timerService_));
        }
        return timerWrappers;
    }

    @Override
    public Collection<Timer> getAllTimers() throws IllegalStateException, EJBException {
        this.checkCallPermission();
        HashSet<Timer> timerWrappers = new HashSet<Timer>();
        Collection<Long> containerIds = this.ejbDescriptor_.getEjbBundleDescriptor().getDescriptorIds();
        timerWrappers.addAll(this.getAllTimers(this.persistentTimerService_, containerIds));
        timerWrappers.addAll(this.getAllTimers(this.nonPersistentTimerService_, containerIds));
        return timerWrappers;
    }

    public Collection<Timer> getAllTimers(EJBTimerService timerService_, Collection<Long> containerIds) throws IllegalStateException, EJBException {
        HashSet<Timer> timerWrappers = new HashSet<Timer>();
        if (timerService_ != null) {
            Collection<TimerPrimaryKey> timerIds = timerService_.getTimerIds(containerIds);
            for (TimerPrimaryKey timerId : timerIds) {
                timerWrappers.add(new TimerWrapper(timerId, timerService_));
            }
        }
        return timerWrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTimedObjectPrimaryKey() {
        if (!this.entity_) {
            return null;
        }
        EJBTimerServiceWrapper eJBTimerServiceWrapper = this;
        synchronized (eJBTimerServiceWrapper) {
            if (this.timedObjectPrimaryKey_ == null) {
                this.timedObjectPrimaryKey_ = ((EntityContext)((Object)this.ejbContext_)).getPrimaryKey();
            }
        }
        return this.timedObjectPrimaryKey_;
    }

    private void checkCreateTimerCallPermission() throws IllegalStateException {
        if (!this.ejbContext_.isTimedObject()) {
            throw new IllegalStateException("EJBTimerService.createTimer can only be called from a timed object.  This EJB does not implement javax.ejb.TimedObject");
        }
        this.checkCallPermission();
    }

    private void checkCallPermission() throws IllegalStateException {
        this.ejbContext_.checkTimerServiceMethodAccess();
    }

    private Timer createTimerInternal(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo(info);
        return this.createTimerInternal(initialDuration, intervalDuration, timerConfig);
    }

    private Timer createTimerInternal(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkIntervalDuration(intervalDuration);
        EJBTimerService timerService_ = timerConfig == null || timerConfig.isPersistent() ? this.persistentTimerService_ : this.nonPersistentTimerService_;
        TimerPrimaryKey timerId = null;
        try {
            timerId = timerService_.createTimer(this.ejbDescriptor_.getUniqueId(), this.ejbDescriptor_.getApplication().getUniqueId(), this.getTimedObjectPrimaryKey(), initialDuration, intervalDuration, timerConfig);
        }
        catch (CreateException ce) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(ce);
            throw ejbEx;
        }
        return new TimerWrapper(timerId, timerService_);
    }

    private Timer createTimerInternal(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        TimerConfig tc = new TimerConfig();
        tc.setInfo(info);
        return this.createTimerInternal(initialExpiration, intervalDuration, tc);
    }

    private Timer createTimerInternal(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkIntervalDuration(intervalDuration);
        EJBTimerService timerService_ = timerConfig == null || timerConfig.isPersistent() ? this.persistentTimerService_ : this.nonPersistentTimerService_;
        TimerPrimaryKey timerId = null;
        try {
            timerId = timerService_.createTimer(this.ejbDescriptor_.getUniqueId(), this.ejbDescriptor_.getApplication().getUniqueId(), this.getTimedObjectPrimaryKey(), initialExpiration, intervalDuration, timerConfig);
        }
        catch (CreateException ce) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(ce);
            throw ejbEx;
        }
        return new TimerWrapper(timerId, timerService_);
    }

    private Timer createTimerInternal(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        EJBTimerService timerService_ = timerConfig == null || timerConfig.isPersistent() ? this.persistentTimerService_ : this.nonPersistentTimerService_;
        TimerPrimaryKey timerId = null;
        try {
            timerId = timerService_.createTimer(this.ejbDescriptor_.getUniqueId(), this.ejbDescriptor_.getApplication().getUniqueId(), this.getTimedObjectPrimaryKey(), new EJBTimerSchedule(schedule), timerConfig);
        }
        catch (CreateException ce) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(ce);
            throw ejbEx;
        }
        return new TimerWrapper(timerId, timerService_);
    }

    private void checkDuration(long duration) throws IllegalArgumentException {
        if (duration < 0L) {
            throw new IllegalArgumentException("invalid duration=" + duration);
        }
    }

    private void checkInitialDuration(long initialDuration) throws IllegalArgumentException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("invalid initial duration = " + initialDuration);
        }
    }

    private void checkIntervalDuration(long intervalDuration) throws IllegalArgumentException {
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("invalid interval duration = " + intervalDuration);
        }
    }

    private void checkScheduleExpression(ScheduleExpression expression) throws IllegalArgumentException {
        if (expression == null) {
            throw new IllegalArgumentException("null ScheduleExpression");
        }
    }

    private void checkExpiration(Date expiration) throws IllegalArgumentException {
        if (expiration == null) {
            throw new IllegalArgumentException("null expiration");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("Negative expiration");
        }
    }
}

