/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.sun.ejb.containers.util.pool.NonBlockingPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.PoolException;
import java.util.ArrayList;
import java.util.logging.Level;

public class BlockingPool
extends NonBlockingPool {
    public BlockingPool(long containerId, String name, ObjectFactory sessionCtxFactory, int steadyPoolSize, int poolResizeQuantity, int maxPoolSize, int poolIdleTimeoutInSeconds, ClassLoader loader, boolean singletonBeanPool, int maxWaitTimeInMillis) {
        super(containerId, name, sessionCtxFactory, steadyPoolSize, poolResizeQuantity, maxPoolSize, poolIdleTimeoutInSeconds, loader, singletonBeanPool);
        this.maxWaitTimeInMillis = maxWaitTimeInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(Object param) throws PoolException {
        long totalWaitTime = 0L;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            while (!this.singletonBeanPool) {
                if (this.list.size() > 0) {
                    return super.getObject(param);
                }
                if (this.createdCount - this.destroyedCount < this.maxPoolSize) {
                    return super.getObject(param);
                }
                if (this.maxWaitTimeInMillis >= 0L) {
                    ++this.waitCount;
                    long t1 = System.currentTimeMillis();
                    try {
                        _logger.log(Level.FINE, "[AbstractPool]: Waiting on the pool to get a bean instance...");
                        this.list.wait(this.maxWaitTimeInMillis);
                    }
                    catch (InterruptedException inEx) {
                        throw new PoolException("Thread interrupted.", inEx);
                    }
                    --this.waitCount;
                    totalWaitTime += System.currentTimeMillis() - t1;
                    if (this.list.size() > 0) {
                        return super.getObject(param);
                    }
                    if (this.maxWaitTimeInMillis <= 0L || totalWaitTime < this.maxWaitTimeInMillis) continue;
                    throw new PoolException("Pool Instance not obtained within given time interval.");
                }
                throw new IllegalStateException("maxWaitTimeInMillis is negative with BlockingPool");
            }
        }
        throw new IllegalStateException("Should never go here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(Object object) {
        super.returnObject(object);
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ++this.poolReturned;
            if (this.waitCount > 0) {
                this.list.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyObject(Object object) {
        super.destroyObject(object);
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.waitCount > 0) {
                this.list.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void remove(int count) {
        super.remove(count);
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.notifyAll();
        }
    }
}

