/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainConfigValidator;
import com.sun.enterprise.admin.servermgmt.FileValidator;
import com.sun.enterprise.admin.servermgmt.InvalidConfigException;
import com.sun.enterprise.admin.servermgmt.PortValidator;
import com.sun.enterprise.admin.servermgmt.StringValidator;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class PEDomainConfigValidator
extends DomainConfigValidator {
    private static final StringManager STRING_MANAGER = StringManager.getManager(PEDomainConfigValidator.class);
    private static final String INSTALL_ROOT = STRING_MANAGER.getString("installRoot");
    private static final String DOMAINS_ROOT = STRING_MANAGER.getString("domainsRoot");
    private static final String JAVA_HOME = STRING_MANAGER.getString("javaHome");
    private static final String ADMIN_PORT = STRING_MANAGER.getString("adminPort");
    private static final String INSTANCE_PORT = STRING_MANAGER.getString("instancePort");
    private static final String HOST_NAME = STRING_MANAGER.getString("hostName");
    private static final String JMS_PORT = STRING_MANAGER.getString("jmsPort");
    private static final String ORB_PORT = STRING_MANAGER.getString("orbPort");
    private static final String STRING_TYPE = String.class.getCanonicalName();
    private static final String INTEGER_TYPE = Integer.class.getCanonicalName();
    static DomainConfigValidator.DomainConfigEntryInfo[] entries = new DomainConfigValidator.DomainConfigEntryInfo[]{new DomainConfigValidator.DomainConfigEntryInfo("install.root", STRING_TYPE, new FileValidator(INSTALL_ROOT, "dr")), new DomainConfigValidator.DomainConfigEntryInfo("domains.root", STRING_TYPE, new FileValidator(DOMAINS_ROOT, "drw")), new DomainConfigValidator.DomainConfigEntryInfo("domain.adminPort", INTEGER_TYPE, new PortValidator(ADMIN_PORT)), new DomainConfigValidator.DomainConfigEntryInfo("domain.instancePort", INTEGER_TYPE, new PortValidator(INSTANCE_PORT)), new DomainConfigValidator.DomainConfigEntryInfo("domain.hostName", STRING_TYPE, new StringValidator(HOST_NAME)), new DomainConfigValidator.DomainConfigEntryInfo("orb.listener.port", INTEGER_TYPE, new PortValidator(ORB_PORT)), new DomainConfigValidator.DomainConfigEntryInfo("jms.port", INTEGER_TYPE, new PortValidator(JMS_PORT))};

    public PEDomainConfigValidator() {
        super(entries);
    }

    @Override
    public void validate(Object domainConfig) throws InvalidConfigException {
        super.validate(domainConfig);
        this.uniquePorts((DomainConfig)domainConfig);
    }

    @Override
    protected boolean isValidate(String name, Object domainConfig) {
        boolean isPortEntry = "domain.adminPort".equals(name) || "domain.instancePort".equals(name) || "orb.listener.port".equals(name) || "jms.port".equals(name);
        return isPortEntry ? this.isValidatePorts((Map)domainConfig) : true;
    }

    private boolean isValidatePorts(Map domainConfig) {
        Boolean isValidatePorts = (Boolean)domainConfig.get("domain.validatePorts");
        return null != isValidatePorts ? isValidatePorts : true;
    }

    final void uniquePorts(DomainConfig dc) throws InvalidConfigException {
        Map ports = dc.getPorts();
        HashSet portValues = new HashSet(ports.values());
        if (ports.keySet().size() != portValues.size()) {
            throw new InvalidConfigException(this.getMessage(ports));
        }
    }

    private String getMessage(Map ports) {
        return this.getLocalizedString("duplicatePorts", this.getDuplicatePorts(ports));
    }

    private String getLocalizedString(String key, Object o) {
        return STRING_MANAGER.getString(key, o);
    }

    final String getDuplicatePorts(Map ports) {
        return this.printDuplicatesFromMap(this.reverseMap(ports));
    }

    private Map reverseMap(Map inputMap) {
        TreeMap outputMap = new TreeMap();
        for (Map.Entry entry : inputMap.entrySet()) {
            this.addEntryToMap(entry.getKey(), entry.getValue(), outputMap);
        }
        return outputMap;
    }

    private void addEntryToMap(Object key, Object value, Map map) {
        if (!map.containsKey(value)) {
            map.put(value, new TreeSet());
        }
        ((Set)map.get(value)).add(key);
    }

    private String printDuplicatesFromMap(Map map) {
        StringBuilder sb = new StringBuilder();
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = this.getNextDuplicate(it);
        if (entry != null) {
            this.printEntry(sb, entry);
            while ((entry = this.getNextDuplicate(it)) != null) {
                sb.append(", ");
                this.printEntry(sb, entry);
            }
        }
        return sb.toString();
    }

    private Map.Entry getNextDuplicate(Iterator it) {
        while (it.hasNext()) {
            Map.Entry result = (Map.Entry)it.next();
            if (((Set)result.getValue()).size() <= 1) continue;
            return result;
        }
        return null;
    }

    private void printEntry(StringBuilder sb, Map.Entry entry) {
        this.printEntry(sb, entry.getKey(), (Set)entry.getValue());
    }

    private void printEntry(StringBuilder sb, Object key, Set dups) {
        sb.append(key).append(" -> ");
        this.printSet(sb, dups);
    }

    private void printSet(StringBuilder sb, Set set) {
        sb.append("{");
        String separator = "";
        Iterator it = set.iterator();
        while (it.hasNext()) {
            sb.append(separator).append(it.next());
            separator = ", ";
        }
        sb.append("}");
    }
}

