/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.stringsubs.AttributePreprocessor;
import java.util.Map;

public class AttributePreprocessorImpl
implements AttributePreprocessor {
    private Map<String, String> lookUpMap = null;
    private static final String DELIMITER = "$";

    AttributePreprocessorImpl() {
    }

    public AttributePreprocessorImpl(Map<String, String> lookUpMap) {
        this.lookUpMap = lookUpMap;
    }

    @Override
    public String substituteBefore(String beforeValue) {
        return beforeValue;
    }

    @Override
    public String substituteAfter(String afterValue) {
        return this.substitute(afterValue, DELIMITER, DELIMITER);
    }

    @Override
    public String substitutePath(String path) {
        return this.substitute(path, DELIMITER, DELIMITER);
    }

    private String substitute(String var, String startDelim, String endDelim) {
        if (var == null || startDelim == null || endDelim == null) {
            return var;
        }
        int firstIndex = var.indexOf(startDelim);
        int secondIndex = var.indexOf(endDelim, firstIndex + startDelim.length());
        if (firstIndex == -1 || secondIndex == -1) {
            return var;
        }
        StringBuilder stringStart = new StringBuilder(var.substring(0, firstIndex));
        String sub = this.lookUpMap.get(var.substring(firstIndex + startDelim.length(), secondIndex));
        String stringEnd = var.substring(secondIndex + endDelim.length(), var.length());
        if (sub != null) {
            stringStart.append(sub);
        }
        stringStart.append(!stringEnd.contains(startDelim) ? stringEnd : this.substitute(stringEnd, startDelim, endDelim));
        return stringStart.toString();
    }
}

