/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.http;

import fish.payara.security.openid.http.HttpStorageController;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionController
implements HttpStorageController {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public SessionController(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public void store(String name, String value, Integer maxAge) {
        HttpSession session = this.request.getSession();
        session.setAttribute(name, (Object)value);
    }

    public Optional<Object> get(String name) {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return Optional.ofNullable(session.getAttribute(name));
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getAsString(String name) {
        return this.get(name).map(Object::toString);
    }

    @Override
    public void remove(String name) {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
    }
}

