/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hotdeploy;

import fish.payara.nucleus.hotdeploy.ApplicationState;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import javax.inject.Singleton;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.jvnet.hk2.annotations.Service;

@Singleton
@Service(name="hotdeploy-service")
public class HotDeployService {
    private final Map<File, ApplicationState> applicationStates = new WeakHashMap<File, ApplicationState>();

    public boolean isApplicationStateExist(File path) {
        return this.applicationStates.containsKey(path);
    }

    public Optional<ApplicationState> getApplicationState(File path) {
        return Optional.ofNullable(this.applicationStates.get(path));
    }

    public Optional<ApplicationState> getApplicationState(boolean hotdeploy, File path) {
        if (hotdeploy) {
            return this.getApplicationState(path);
        }
        return Optional.empty();
    }

    public Optional<ApplicationState> getApplicationState(ApplicationContext context) {
        if (context instanceof DeploymentContext) {
            return this.getApplicationState((DeploymentContext)context);
        }
        return Optional.empty();
    }

    public Optional<ApplicationState> getApplicationState(DeploymentContext context) {
        DeployCommandParameters commandParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        boolean hotDeploy = commandParams != null ? commandParams.hotDeploy : false;
        return this.getApplicationState(hotDeploy, context.getSourceDir());
    }

    public synchronized ApplicationState removeApplicationState(File path) {
        ApplicationState applicationState = this.applicationStates.remove(path);
        if (applicationState != null) {
            applicationState.preDestroy();
        }
        return applicationState;
    }

    public synchronized void addApplicationState(ApplicationState applicationState) {
        if (this.applicationStates.containsKey(applicationState.getPath())) {
            throw new IllegalStateException("Application state already exist for " + applicationState.getName());
        }
        this.applicationStates.put(applicationState.getPath(), applicationState);
    }
}

