/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.lib.io.ByteBufferInputStream;
import aQute.lib.io.ByteBufferOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.InputBufferImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.util.ByteData;

public class JavaActionImpl
extends ActionImpl {
    public JavaActionImpl(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule) {
        super(logger, isTerse, isVerbose, buffer, selectionRule, signatureRule);
    }

    @Override
    public String getName() {
        return "Java Action";
    }

    @Override
    public ActionType getActionType() {
        return ActionType.JAVA;
    }

    @Override
    public String getAcceptExtension() {
        return ".java";
    }

    protected String replacePackages(String text) {
        String initialText = text;
        for (Map.Entry<String, String> renameEntry : this.getPackageRenames().entrySet()) {
            int matchStart;
            String key = renameEntry.getKey();
            int keyLen = key.length();
            boolean matchSubpackages = SignatureRuleImpl.containsWildcard(key);
            if (matchSubpackages) {
                key = SignatureRuleImpl.stripWildcard(key);
            }
            int textLimit = text.length() - keyLen;
            int lastMatchEnd = 0;
            while (lastMatchEnd <= textLimit && (matchStart = text.indexOf(key, lastMatchEnd)) != -1) {
                if (!SignatureRuleImpl.isTruePackageMatch(text, matchStart, keyLen, matchSubpackages)) {
                    lastMatchEnd = matchStart + keyLen;
                    continue;
                }
                String value = renameEntry.getValue();
                int valueLen = value.length();
                String head = text.substring(0, matchStart);
                String tail = text.substring(matchStart + keyLen);
                text = head + value + tail;
                lastMatchEnd = matchStart + valueLen;
                textLimit += valueLen - keyLen;
            }
        }
        if (initialText == text) {
            return null;
        }
        return text;
    }

    @Override
    public ByteData apply(String inputName, byte[] inputBytes, int inputLength) throws TransformException {
        String outputName = null;
        outputName = inputName;
        this.setResourceNames(inputName, outputName);
        ByteBufferInputStream inputStream = new ByteBufferInputStream(inputBytes, 0, inputLength);
        InputStreamReader inputReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(inputReader);
        ByteBufferOutputStream outputStream = new ByteBufferOutputStream(inputBytes.length);
        OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
        BufferedWriter writer = new BufferedWriter(outputWriter);
        try {
            this.transform(reader, writer);
        }
        catch (IOException e) {
            this.error("Failed to transform [ {} ]", e, inputName);
            return null;
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            this.error("Failed to flush [ {} ]", e, inputName);
            return null;
        }
        if (!this.hasNonResourceNameChanges()) {
            return null;
        }
        byte[] outputBytes = outputStream.toByteArray();
        return new ByteData(inputName, outputBytes, 0, outputBytes.length);
    }

    protected void transform(BufferedReader reader, BufferedWriter writer) throws IOException {
        String inputLine;
        while ((inputLine = reader.readLine()) != null) {
            String outputLine = this.replacePackages(inputLine);
            if (outputLine == null) {
                outputLine = inputLine;
            } else {
                this.addReplacement();
            }
            writer.write(outputLine);
            writer.write(10);
        }
    }

    protected String renameInput(String inputName) {
        String classQualifiedName;
        String inputPrefix;
        int lastSlash = inputName.lastIndexOf(47);
        if (lastSlash == -1) {
            inputPrefix = null;
            classQualifiedName = inputName;
        } else {
            inputPrefix = inputName.substring(0, lastSlash + 1);
            classQualifiedName = inputName.substring(lastSlash + 1);
        }
        int classStart = classQualifiedName.lastIndexOf(46);
        if (classStart == -1) {
            return null;
        }
        String packageName = classQualifiedName.substring(0, classStart);
        if (packageName.isEmpty()) {
            return null;
        }
        String className = classQualifiedName.substring(classStart);
        String outputName = this.replacePackage(packageName);
        if (outputName == null) {
            return null;
        }
        if (inputPrefix == null) {
            return outputName + className;
        }
        return inputPrefix + outputName + className;
    }
}

