/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.MetricUnitsUtils;
import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.microprofile.metrics.admin.MetricsServiceConfiguration;
import fish.payara.microprofile.metrics.exception.NoSuchRegistryException;
import fish.payara.microprofile.metrics.impl.MetricRegistrationListener;
import fish.payara.microprofile.metrics.impl.MetricRegistryImpl;
import fish.payara.microprofile.metrics.jmx.MBeanMetadata;
import fish.payara.microprofile.metrics.jmx.MBeanMetadataConfig;
import fish.payara.microprofile.metrics.jmx.MBeanMetadataHelper;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.bind.JAXB;
import org.eclipse.microprofile.metrics.Counting;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Timer;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="microprofile-metrics-service")
@RunLevel(value=10)
public class MetricsServiceImpl
implements MetricsService,
ConfigListener,
MonitoringDataSource {
    private static final Logger LOGGER = Logger.getLogger(MetricsService.class.getName());
    @Inject
    MetricsServiceConfiguration configuration;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    private MBeanMetadataHelper helper;
    private MetricsServiceConfiguration metricsServiceConfiguration;
    private Boolean metricsEnabled;
    private Boolean metricsSecure;
    private List<MBeanMetadata> unresolvedBaseMetadataList;
    private List<MBeanMetadata> unresolvedVendorMetadataList;
    private final Map<String, MetricsContextImpl> contextByName = new ConcurrentHashMap<String, MetricsContextImpl>();

    @PostConstruct
    public void init() {
        this.metricsServiceConfiguration = (MetricsServiceConfiguration)this.serviceLocator.getService(MetricsServiceConfiguration.class, new Annotation[0]);
        if (this.isEnabled()) {
            PayaraExecutorService payaraExecutor = (PayaraExecutorService)this.serviceLocator.getService(PayaraExecutorService.class, new Annotation[0]);
            payaraExecutor.submit(this::bootstrap);
        }
    }

    @Override
    public Set<String> getContextNames() {
        return Collections.unmodifiableSet(this.contextByName.keySet());
    }

    @Override
    public MetricsService.MetricsContext getContext(boolean createIfNotExists) {
        if (!this.isEnabled()) {
            return null;
        }
        String name = MetricsServiceImpl.appKeyOf(this.getApplicationName());
        if (!createIfNotExists) {
            return this.contextByName.get(name);
        }
        return this.contextByName.computeIfAbsent(name, key -> new MetricsContextImpl((String)key));
    }

    @Override
    public MetricsService.MetricsContext getContext(String name) {
        if (!this.isEnabled()) {
            return null;
        }
        if ("".equals(name = MetricsServiceImpl.appKeyOf(name))) {
            return this.contextByName.computeIfAbsent(name, key -> new MetricsContextImpl((String)key));
        }
        return this.contextByName.get(name);
    }

    public void collect(MonitoringDataCollector rootCollector) {
        if (!this.isEnabled()) {
            return;
        }
        MonitoringDataCollector metricsCollector = rootCollector.in((CharSequence)"metric");
        for (MetricsContextImpl context : this.contextByName.values()) {
            MetricsServiceImpl.processMetadataToAnnotations(context, metricsCollector);
            String contextName = context.getName();
            MetricsServiceImpl.collectRegistry(contextName, context.getBaseRegistry(), metricsCollector);
            MetricsServiceImpl.collectRegistry(contextName, context.getVendorRegistry(), metricsCollector);
            if (context.isServerContext()) continue;
            MetricsServiceImpl.collectRegistry(contextName, context.getApplicationRegistry(), metricsCollector);
        }
    }

    private static void collectRegistry(String contextName, MetricRegistry registry, MonitoringDataCollector collector) {
        for (String name : registry.getNames()) {
            for (Map.Entry<MetricID, Metric> entry : ((MetricRegistryImpl)registry).getMetrics(name).entrySet()) {
                MetricID metricID = entry.getKey();
                Metric metric = entry.getValue();
                try {
                    Object value;
                    MonitoringDataCollector metricCollector = MetricsServiceImpl.tagCollector(contextName, metricID, collector);
                    if (metric instanceof Counting) {
                        metricCollector.collect((CharSequence)MetricsServiceImpl.toName(metricID, "Count"), ((Counting)((Object)metric)).getCount());
                    }
                    if (metric instanceof SimpleTimer) {
                        metricCollector.collect((CharSequence)MetricsServiceImpl.toName(metricID, "Duration"), ((SimpleTimer)metric).getElapsedTime().toMillis());
                    }
                    if (metric instanceof Timer) {
                        metricCollector.collect((CharSequence)MetricsServiceImpl.toName(metricID, "MaxDuration"), ((Timer)metric).getSnapshot().getMax());
                    }
                    if (!(metric instanceof Gauge) || !((value = ((Gauge)metric).getValue()) instanceof Number)) continue;
                    metricCollector.collect((CharSequence)MetricsServiceImpl.toName(metricID, MetricsServiceImpl.getMetricUnitSuffix(registry.getMetadata(name).unit())), (Number)value);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Failed to retrieve metric: " + metricID);
                }
            }
        }
    }

    private static void processMetadataToAnnotations(MetricsContextImpl context, MonitoringDataCollector collector) {
        RegisteredMetric metric = context.pollNewlyRegistered();
        while (metric != null) {
            boolean isGauge;
            MetricID metricID = metric.id;
            MetricRegistry.Type scope = metric.scope;
            MetricRegistryImpl registry = context.getRegistry(scope);
            MonitoringDataCollector metricCollector = MetricsServiceImpl.tagCollector(context.getName(), metricID, collector);
            Metadata metadata = registry.getMetadata(metricID.getName());
            String suffix = "Count";
            String property = "Count";
            boolean bl = isGauge = metadata.getTypeRaw() == MetricType.GAUGE;
            if (isGauge) {
                suffix = MetricsServiceImpl.getMetricUnitSuffix(metadata.unit());
                property = "Value";
            }
            metricCollector.annotate((CharSequence)MetricsServiceImpl.toName(metricID, suffix), 0L, false, MetricsServiceImpl.metadataToAnnotations(context.getName(), scope, metadata, property));
            metric = context.pollNewlyRegistered();
        }
    }

    private static String getMetricUnitSuffix(Optional<String> unit) {
        if (!unit.isPresent()) {
            return "";
        }
        String value = unit.get();
        if ("none".equalsIgnoreCase(value) || value.isEmpty()) {
            return "";
        }
        return MetricsServiceImpl.toFirstLetterUpperCase(value);
    }

    private static String toFirstLetterUpperCase(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    private static String[] metadataToAnnotations(String contextName, MetricRegistry.Type scope, Metadata metadata, String property) {
        String unit = metadata.unit().orElse("none");
        return new String[]{"App", contextName, "Scope", scope.getName(), "Name", metadata.getName(), "Type", metadata.getType(), "Unit", unit, "DisplayName", metadata.getDisplayName(), "Description", metadata.getDescription(), "Property", property, "BaseUnit", MetricUnitsUtils.baseUnit(unit), "ScaleToBaseUnit", MetricUnitsUtils.scaleToBaseUnit((Number)1L, unit).toString()};
    }

    private static String toName(MetricID metric, String suffix) {
        String name = metric.getName();
        if (name.indexOf(32) >= 0) {
            name = name.replace(' ', '_');
        } else {
            int dotIndex = name.indexOf(46);
            if (dotIndex > 0) {
                name = name.substring(dotIndex + 1);
            }
            if (name.indexOf(46) > 0) {
                String[] words = name.split("\\.");
                name = "";
                for (String word : words) {
                    name = name + MetricsServiceImpl.toFirstLetterUpperCase(word);
                }
            }
        }
        name = MetricsServiceImpl.toFirstLetterUpperCase(name);
        return name.endsWith(suffix) || suffix.isEmpty() ? name : name + suffix;
    }

    private static MonitoringDataCollector tagCollector(String contextName, MetricID metric, MonitoringDataCollector collector) {
        Map<String, String> tags = metric.getTags();
        if (tags.isEmpty()) {
            String name = metric.getName();
            int dotIndex = name.indexOf(46);
            if (dotIndex > 0) {
                String firstWord = name.substring(0, dotIndex);
                return collector.group((CharSequence)firstWord);
            }
            return contextName.isEmpty() ? collector : collector.group((CharSequence)contextName);
        }
        StringBuilder tag = new StringBuilder();
        if (!contextName.isEmpty()) {
            tag.append(contextName).append('_');
        }
        for (Map.Entry<String, String> e : metric.getTags().entrySet()) {
            if (tag.length() > 0) {
                tag.append('_');
            }
            if (!"name".equals(e.getKey())) {
                tag.append(e.getKey().replace(' ', '_'));
            }
            tag.append(e.getValue().replace(' ', '_'));
        }
        return collector.group((CharSequence)tag);
    }

    private static void checkSystemCpuLoadIssue(MBeanMetadataConfig metadataConfig) {
        String mbeanSystemCPULoad = "java.lang:type=OperatingSystem/SystemCpuLoad";
        long count = metadataConfig.getBaseMetadata().stream().map(MBeanMetadata::getMBean).filter(mbeanSystemCPULoad::equalsIgnoreCase).count();
        if ((count += metadataConfig.getVendorMetadata().stream().map(MBeanMetadata::getMBean).filter(mbeanSystemCPULoad::equalsIgnoreCase).count()) > 1L) {
            LOGGER.warning(String.format("Referencing the MBean value %s multiple times possibly leads to inconsistent values for the MBean value.", mbeanSystemCPULoad));
        }
    }

    private void initMetadataConfig(List<MBeanMetadata> baseMetadataList, List<MBeanMetadata> vendorMetadataList, boolean isRetry) {
        if (!baseMetadataList.isEmpty()) {
            this.unresolvedBaseMetadataList = this.helper.registerMetadata(this.getContext("").getBaseRegistry(), baseMetadataList, isRetry);
        }
        if (!vendorMetadataList.isEmpty()) {
            this.unresolvedVendorMetadataList = this.helper.registerMetadata(this.getContext("").getVendorRegistry(), vendorMetadataList, isRetry);
        }
    }

    @Override
    public void refresh() {
        if (this.unresolvedBaseMetadataList == null || this.unresolvedVendorMetadataList == null) {
            this.bootstrap();
        } else {
            this.initMetadataConfig(this.unresolvedBaseMetadataList, this.unresolvedVendorMetadataList, true);
        }
    }

    private MBeanMetadataConfig getConfig() {
        InputStream defaultConfig = MetricsService.class.getResourceAsStream("/metrics.xml");
        MBeanMetadataConfig config = (MBeanMetadataConfig)JAXB.unmarshal((InputStream)defaultConfig, MBeanMetadataConfig.class);
        File metricsResource = new File(this.serverEnv.getConfigDirPath(), "metrics.xml");
        if (metricsResource.exists()) {
            try {
                FileInputStream userMetrics = new FileInputStream(metricsResource);
                MBeanMetadataConfig extraConfig = (MBeanMetadataConfig)JAXB.unmarshal((InputStream)userMetrics, MBeanMetadataConfig.class);
                config.addBaseMetadata(extraConfig.getBaseMetadata());
                config.addVendorMetadata(extraConfig.getVendorMetadata());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return config;
    }

    @Override
    public boolean isEnabled() {
        if (this.metricsEnabled == null) {
            this.metricsEnabled = Boolean.valueOf(this.metricsServiceConfiguration.getEnabled());
        }
        return this.metricsEnabled;
    }

    public void resetMetricsEnabledProperty() {
        this.metricsEnabled = null;
    }

    public Boolean isMetricsSecure() {
        if (this.metricsSecure == null) {
            this.metricsSecure = Boolean.valueOf(this.metricsServiceConfiguration.getSecureMetrics());
        }
        return this.metricsSecure;
    }

    public void resetMetricsSecureProperty() {
        this.metricsSecure = null;
    }

    public boolean isSecurityEnabled() {
        return Boolean.parseBoolean(this.metricsServiceConfiguration.getSecurityEnabled());
    }

    public void registerApplication(String applicationName) {
    }

    public void deregisterApplication(String applicationName) {
        this.contextByName.remove(MetricsServiceImpl.appKeyOf(applicationName));
    }

    private static String appKeyOf(String name) {
        return name == null ? null : name.toLowerCase();
    }

    public String getApplicationName() {
        InvocationManager invocationManager = (InvocationManager)Globals.getDefaultBaseServiceLocator().getService(InvocationManager.class, new Annotation[0]);
        ComponentInvocation current = invocationManager.getCurrentInvocation();
        if (current == null) {
            return invocationManager.peekAppEnvironment().getName();
        }
        return current.getAppName();
    }

    private void bootstrap() {
        MBeanMetadataConfig metadataConfig = this.getConfig();
        MetricsServiceImpl.checkSystemCpuLoadIssue(metadataConfig);
        this.initMetadataConfig(metadataConfig.getBaseMetadata(), metadataConfig.getVendorMetadata(), false);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList<UnprocessedChangeEvent> unchangedList = new ArrayList<UnprocessedChangeEvent>();
        for (PropertyChangeEvent event : events) {
            unchangedList.add(new UnprocessedChangeEvent(event, "Microprofile Metrics configuration changed:" + event.getPropertyName() + " was changed from " + event.getOldValue().toString() + " to " + event.getNewValue().toString()));
        }
        return new UnprocessedChangeEvents(unchangedList);
    }

    private static final class MetricsContextImpl
    implements MetricsService.MetricsContext,
    MetricRegistrationListener {
        private final String name;
        private final MetricRegistryImpl base;
        private final MetricRegistryImpl vendor;
        private final MetricRegistryImpl application;
        private final Queue<RegisteredMetric> newlyRegistered = new ConcurrentLinkedQueue<RegisteredMetric>();

        public MetricsContextImpl(String name) {
            this.name = name;
            this.base = new MetricRegistryImpl(MetricRegistry.Type.BASE);
            this.vendor = new MetricRegistryImpl(MetricRegistry.Type.VENDOR);
            this.application = this.isServerContext() ? null : new MetricRegistryImpl(MetricRegistry.Type.APPLICATION);
            this.base.addListener(this);
            this.vendor.addListener(this);
            if (this.application != null) {
                this.application.addListener(this);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public MetricRegistryImpl getRegistry(MetricRegistry.Type type) throws NoSuchRegistryException {
            switch (type) {
                case BASE: {
                    return this.base;
                }
                case VENDOR: {
                    return this.vendor;
                }
            }
            if (this.isServerContext()) {
                throw new NoSuchRegistryException("Server context does not have an application registry");
            }
            return this.application;
        }

        @Override
        public void onRegistration(MetricID registered, MetricRegistry registry) {
            this.newlyRegistered.add(new RegisteredMetric(registry.getType(), registered));
        }

        RegisteredMetric pollNewlyRegistered() {
            return this.newlyRegistered.poll();
        }
    }

    private static final class RegisteredMetric {
        final MetricRegistry.Type scope;
        final MetricID id;

        RegisteredMetric(MetricRegistry.Type scope, MetricID metric) {
            this.scope = scope;
            this.id = metric;
        }
    }
}

