/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.api;

import com.sun.messaging.bridge.api.Bridge;
import com.sun.messaging.bridge.api.BridgeBaseContext;
import java.util.Locale;
import java.util.Properties;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Contract;

@Contract
@Singleton
public abstract class BridgeServiceManager {
    public abstract void init(BridgeBaseContext var1) throws Exception;

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract BridgeBaseContext getBridgeBaseContext();

    public abstract boolean isRunning();

    public abstract String getAdminDestinationName() throws Exception;

    public abstract String getAdminDestinationClassName() throws Exception;

    public static Object getExportedService(Class c, String bridgeType, Properties props) throws Exception {
        if (c == null) {
            throw new IllegalArgumentException("null class");
        }
        if (bridgeType == null) {
            throw new IllegalArgumentException("null bridge type");
        }
        Bridge b = null;
        Locale loc = Locale.getDefault();
        if (bridgeType.equalsIgnoreCase("JMS")) {
            b = (Bridge)Class.forName("com.sun.messaging.bridge.service.jms.BridgeImpl").newInstance();
        } else if (bridgeType.toUpperCase(loc).equals("STOMP")) {
            b = (Bridge)Class.forName("com.sun.messaging.bridge.service.stomp.StompBridge").newInstance();
        } else {
            throw new IllegalArgumentException("Invalid bridge type: " + bridgeType);
        }
        return b.getExportedService(c, props);
    }
}

