/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.sharecc.ShareConfigChangeStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.DBConnectionPool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordDAOFactory;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;

public final class ShareConfigChangeDBManager
extends CommDBManager {
    static final String JDBC_PROP_PREFIX = "imq.cluster.sharecc.persist.jdbc";
    static final int LONGEST_TABLENAME_LEN = 15;
    private BrokerResources br = Globals.getBrokerResources();
    private String clusterID = null;
    private ShareConfigRecordDAOFactory daoFactory = null;
    private DBConnectionPool dbpool = null;
    private boolean storeInited = false;
    private static final Object classLock = ShareConfigChangeDBManager.class;
    private static ShareConfigChangeDBManager dbMgr = null;

    @Override
    protected boolean getDEBUG() {
        return ShareConfigChangeStore.getDEBUG();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShareConfigChangeDBManager getDBManager() throws BrokerException {
        Object object = classLock;
        synchronized (object) {
            if (dbMgr == null) {
                dbMgr = new ShareConfigChangeDBManager();
                dbMgr.loadTableSchema();
                ShareConfigChangeDBManager.dbMgr.dbpool = new DBConnectionPool(dbMgr, "ccshare", true);
                dbMgr.initDBMetaData();
            }
        }
        return dbMgr;
    }

    @Override
    protected String getJDBCPropPrefix() {
        return JDBC_PROP_PREFIX;
    }

    @Override
    protected String getStoreTypeProp() {
        return "imq.cluster.sharecc.persist";
    }

    @Override
    protected String getCreateStoreProp() {
        return "imq.cluster.sharecc.persistCreate";
    }

    @Override
    protected boolean getCreateStorePropDefault() {
        return false;
    }

    @Override
    protected String getLogStringTag() {
        return "[imq.cluster.sharecc.persist.jdbc]";
    }

    @Override
    public String toString() {
        return "CCShareDBManger";
    }

    @Override
    protected Connection getConnection() throws BrokerException {
        return this.dbpool.getConnection();
    }

    @Override
    public void freeConnection(Connection c, Throwable thr) throws BrokerException {
        this.dbpool.freeConnection(c, thr);
    }

    @Override
    protected void checkMaxTableNameLength(int maxTableNameLength) throws BrokerException {
        if (maxTableNameLength > 0) {
            int baselen = 16;
            if (this.clusterID.length() + baselen > maxTableNameLength) {
                Object[] args = new Object[]{this.clusterID, maxTableNameLength, baselen};
                throw new BrokerException(this.br.getKString("B3179", args));
            }
        }
    }

    @Override
    protected boolean isStoreInited() {
        return this.storeInited;
    }

    protected void setStoreInited(boolean b) {
        this.storeInited = b;
    }

    private ShareConfigChangeDBManager() throws BrokerException {
        this.initDBManagerProps();
        this.initDBDriver();
    }

    @Override
    protected void initTableSuffix() throws BrokerException {
        this.clusterID = Globals.getClusterID();
        if (this.clusterID == null || this.clusterID.length() == 0 || !Util.isAlphanumericString(this.clusterID)) {
            throw new BrokerException(this.br.getKString("B3178", this.clusterID));
        }
        this.tableSuffix = "C" + this.clusterID;
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        ht.put("clusterID", "" + this.clusterID);
        ht.put(this.dbpool.toString(), this.dbpool.getDebugState());
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareConfigRecordDAOFactory getDAOFactory() {
        Object object = classLock;
        synchronized (object) {
            if (this.daoFactory == null) {
                this.daoFactory = new ShareConfigRecordDAOFactory();
            }
        }
        return this.daoFactory;
    }

    @Override
    protected BaseDAO getFirstDAO() throws BrokerException {
        return (BaseDAO)this.getDAOFactory().getAllDAOs().get(0);
    }

    @Override
    public Iterator allDAOIterator() throws BrokerException {
        return this.getDAOFactory().getAllDAOs().iterator();
    }

    @Override
    public String getClusterID() {
        return this.clusterID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() {
        Object object = classLock;
        synchronized (object) {
            this.dbpool.close();
            super.close();
            dbMgr = null;
        }
    }

    @Override
    public String[] getAllOldTableNames() {
        String[] olds = new String[]{this.getTableName("MQSHARECC45")};
        return olds;
    }

    @Override
    public String[] getTableNames(int version) {
        if (version == 500) {
            return this.tableSchemas.keySet().toArray(new String[this.tableSchemas.size()]);
        }
        if (version == 450) {
            String[] olds = new String[]{this.getTableName("MQSHARECC45")};
            return olds;
        }
        return new String[0];
    }

    @Override
    public int checkStoreExists(Connection conn) throws BrokerException {
        return super.checkStoreExists(conn, "50");
    }

    @Override
    public boolean hasSupplementForCreateDrop(String tableName) {
        return true;
    }

    @Override
    public void dropOldTableSupplement(Statement stmt, String oldTableName, boolean throwException) throws BrokerException {
        block7: {
            String sql = null;
            if (oldTableName.endsWith("45") && this.isOracle()) {
                sql = "DROP SEQUENE " + oldTableName + "_seq";
            }
            if (sql == null) {
                return;
            }
            this.logger.logToAll(8, this.br.getKString("B1366", sql, oldTableName));
            try {
                int cnt = ShareConfigChangeDBManager.executeUpdateStatement(stmt, sql);
                if (cnt != 0 || stmt.getWarnings() != null) {
                    String emsg = "[" + sql + "]: " + stmt.getWarnings() + "(return=" + cnt + ")";
                    throw new BrokerException(emsg);
                }
            }
            catch (Throwable t) {
                BrokerException ex = null;
                if (t instanceof BrokerException) {
                    ex = (BrokerException)t;
                } else {
                    String emsg = "[" + sql + "]: " + t.getMessage();
                    ex = new BrokerException(emsg, t);
                }
                this.logger.logStack(16, ex.getMessage(), t);
                if (!throwException) break block7;
                throw ex;
            }
        }
    }

    @Override
    protected String getTableLockTableName() throws BrokerException {
        ShareConfigRecordDAO dao = this.getDAOFactory().getShareConfigRecordDAO();
        return dao.getTableName();
    }

    @Override
    protected String getCurrentTableLock(Connection conn, boolean doLock) throws BrokerException {
        ShareConfigRecordDAO dao = this.getDAOFactory().getShareConfigRecordDAO();
        String currLock = dao.getLockID(conn);
        if (currLock == null) {
            String emsg = this.br.getKString("B3266", this.getClusterID());
            throw new BrokerException(emsg, "B3266", null, 301);
        }
        return currLock;
    }

    @Override
    protected void updateTableLock(Connection conn, String newLockID, String oldLockID, Object extra) throws BrokerException {
        ShareConfigRecordDAO dao = this.getDAOFactory().getShareConfigRecordDAO();
        if (oldLockID != null) {
            dao.updateLockID(conn, newLockID, oldLockID);
            return;
        }
        if (newLockID == null) {
            throw new BrokerException("Both old and new lock id parameters are passed null");
        }
        ChangeRecordInfo cri = (ChangeRecordInfo)extra;
        dao.insertResetRecord(null, cri, newLockID);
    }

    @Override
    public void throwTableLockedException(String lockID) throws BrokerException {
        this.throwTableLockedException(new CommDBManager.TableLock(lockID, this.getTableLockTableName()));
    }

    @Override
    protected void throwTableLockedException(CommDBManager.TableLock lock) throws BrokerException {
        BrokerResources br = Globals.getBrokerResources();
        String emsg = null;
        if (lock.port != 0) {
            emsg = br.getKString("B3303", lock.host, String.valueOf(lock.port));
            throw new BrokerException(emsg, "B3303", null, 409);
        }
        emsg = br.getKString("B3306", "imqdbmgr");
        throw new BrokerException(emsg, "B3306", null, 409);
    }

    @Override
    public void closeSQLObjects(ResultSet rset, Statement stmt, Connection conn, Throwable ex) throws BrokerException {
        try {
            if (rset != null) {
                rset.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BrokerException(this.br.getKString("B3250", e.toString()), e);
        }
        finally {
            if (conn != null) {
                this.freeConnection(conn, ex);
            }
        }
    }
}

