/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.Acceptor;
import com.sun.corba.ee.spi.transport.ORBSocketFactory;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.security.integration.AppClientSSL;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.IIOPSSLUtil;
import org.glassfish.enterprise.iiop.util.IIOPUtils;
import org.glassfish.enterprise.iiop.util.NotServerException;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.internal.api.Globals;
import org.glassfish.orb.admin.config.IiopListener;
import org.glassfish.orb.admin.config.IiopService;
import org.glassfish.security.common.CipherInfo;

public class IIOPSSLSocketFactory
implements ORBSocketFactory {
    private static final Logger _logger = LogDomains.getLogger(IIOPSSLSocketFactory.class, (String)"javax.enterprise.resource.corba");
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String PERSISTENT_SSL = "PERSISTENT_SSL";
    private static final int BACKLOG = 50;
    private static final String SO_KEEPALIVE = "fish.payara.SO_KEEPALIVE";
    private static final String SO_KEEPALIVE_DEPRECATED = "fish.payara.SOKeepAlive";
    private Map<Integer, SSLInfo> portToSSLInfo = new ConcurrentHashMap<Integer, SSLInfo>();
    private SSLInfo clientSslInfo = null;
    private ORB orb;

    public IIOPSSLSocketFactory() {
        try {
            boolean notServerOrACC;
            ProcessEnvironment penv = null;
            ProcessEnvironment.ProcessType processType = null;
            boolean bl = notServerOrACC = Globals.getDefaultHabitat() == null;
            if (!notServerOrACC) {
                penv = (ProcessEnvironment)Globals.get(ProcessEnvironment.class);
                processType = penv.getProcessType();
            }
            if (processType != null && processType.isServer()) {
                Ssl outboundSsl;
                Config conf = (Config)Globals.getDefaultHabitat().getService(Config.class, "default-instance-name", new Annotation[0]);
                IiopService iiopBean = (IiopService)conf.getExtensionByType(IiopService.class);
                List iiopListeners = iiopBean.getIiopListener();
                for (IiopListener listener : iiopListeners) {
                    SSLInfo sslInfo;
                    Ssl ssl = listener.getSsl();
                    boolean securityEnabled = Boolean.valueOf(listener.getSecurityEnabled());
                    if (!securityEnabled) continue;
                    if (ssl != null) {
                        boolean ssl2Enabled = Boolean.valueOf(ssl.getSsl2Enabled());
                        boolean ssl3Enabled = Boolean.valueOf(ssl.getSsl3Enabled());
                        boolean tlsEnabled = Boolean.valueOf(ssl.getTlsEnabled());
                        boolean tlsEnabled11 = Boolean.valueOf(ssl.getTls11Enabled());
                        boolean tlsEnabled12 = Boolean.valueOf(ssl.getTls12Enabled());
                        boolean tlsEnabled13 = Boolean.valueOf(ssl.getTls13Enabled());
                        sslInfo = this.init(ssl.getCertNickname(), ssl2Enabled, ssl.getSsl2Ciphers(), ssl3Enabled, ssl.getSsl3TlsCiphers(), tlsEnabled, tlsEnabled11, tlsEnabled12, tlsEnabled13);
                    } else {
                        sslInfo = this.getDefaultSslInfo();
                    }
                    this.portToSSLInfo.put(new Integer(listener.getPort()), sslInfo);
                }
                if (iiopBean.getSslClientConfig() != null && iiopBean.getSslClientConfig().getSsl() != null && (outboundSsl = iiopBean.getSslClientConfig().getSsl()) != null) {
                    boolean ssl2Enabled = Boolean.valueOf(outboundSsl.getSsl2Enabled());
                    boolean ssl3Enabled = Boolean.valueOf(outboundSsl.getSsl3Enabled());
                    boolean tlsEnabled = Boolean.valueOf(outboundSsl.getTlsEnabled());
                    boolean tlsEnabled11 = Boolean.valueOf(outboundSsl.getTls11Enabled());
                    boolean tlsEnabled12 = Boolean.valueOf(outboundSsl.getTls12Enabled());
                    boolean tlsEnabled13 = Boolean.valueOf(outboundSsl.getTls13Enabled());
                    this.clientSslInfo = this.init(outboundSsl.getCertNickname(), ssl2Enabled, outboundSsl.getSsl2Ciphers(), ssl3Enabled, outboundSsl.getSsl3TlsCiphers(), tlsEnabled, tlsEnabled11, tlsEnabled12, tlsEnabled13);
                }
                if (this.clientSslInfo == null) {
                    this.clientSslInfo = this.getDefaultSslInfo();
                }
            } else {
                IIOPSSLUtil sslUtil;
                AppClientSSL clientSsl;
                this.clientSslInfo = processType == ProcessEnvironment.ProcessType.ACC ? ((clientSsl = (AppClientSSL)(sslUtil = (IIOPSSLUtil)Globals.getDefaultHabitat().getService(IIOPSSLUtil.class, new Annotation[0])).getAppClientSSL()) != null ? this.init(clientSsl.getCertNickname(), clientSsl.getSsl2Enabled(), clientSsl.getSsl2Ciphers(), clientSsl.getSsl3Enabled(), clientSsl.getSsl3TlsCiphers(), clientSsl.getTlsEnabled(), clientSsl.getTls11Enabled(), clientSsl.getTls12Enabled(), clientSsl.getTls13Enabled()) : this.getDefaultSslInfo()) : this.getDefaultSslInfo();
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.init_exception", e);
            throw new IllegalStateException(e);
        }
    }

    private SSLInfo getDefaultSslInfo() throws Exception {
        return this.init(null, false, null, true, null, true, true, true, false);
    }

    private SSLInfo init(String alias, boolean ssl2Enabled, String ssl2Ciphers, boolean ssl3Enabled, String ssl3TlsCiphers, boolean tlsEnabled, boolean tlsEnabled11, boolean tlsEnabled12, boolean tlsEnabled13) throws Exception {
        String protocol = tlsEnabled13 ? "TLSv1.3" : (tlsEnabled12 ? "TLSv1.2" : (tlsEnabled11 ? "TLSv1.1" : (tlsEnabled ? "TLS" : (ssl3Enabled ? "SSLv3" : (ssl2Enabled ? "SSLv2" : "SSL")))));
        String[] ssl3TlsCipherArr = null;
        if (tlsEnabled11 || tlsEnabled12 || tlsEnabled13 || tlsEnabled || ssl3Enabled) {
            ssl3TlsCipherArr = this.getEnabledCipherSuites(ssl3TlsCiphers, false, ssl3Enabled, tlsEnabled, tlsEnabled11, tlsEnabled12, tlsEnabled13);
        }
        String[] ssl2CipherArr = null;
        if (ssl2Enabled) {
            ssl2CipherArr = this.getEnabledCipherSuites(ssl2Ciphers, true, false, false, false, false, false);
        }
        SSLContext ctx = SSLContext.getInstance(protocol);
        if (Globals.getDefaultHabitat() != null) {
            IIOPSSLUtil sslUtil = (IIOPSSLUtil)Globals.getDefaultHabitat().getService(IIOPSSLUtil.class, new Annotation[0]);
            KeyManager[] mgrs = sslUtil.getKeyManagers(alias);
            ctx.init(mgrs, sslUtil.getTrustManagers(), sslUtil.getInitializedSecureRandom());
        }
        SSLInfo newInfo = new SSLInfo(ctx, ssl3TlsCipherArr, ssl2CipherArr);
        if (ssl3Enabled) {
            newInfo.addProtocol("SSLv3");
        }
        if (tlsEnabled) {
            newInfo.addProtocol("TLS");
        }
        if (tlsEnabled11) {
            newInfo.addProtocol("TLSv1.1");
        }
        if (tlsEnabled12) {
            newInfo.addProtocol("TLSv1.2");
        }
        if (tlsEnabled13) {
            newInfo.addProtocol("TLSv1.3");
        }
        return newInfo;
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    public ServerSocket createServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating server socket for type =" + type + " inetSocketAddress =" + inetSocketAddress);
        }
        if (type.equals(SSL_MUTUALAUTH) || type.equals("SSL") || type.equals(PERSISTENT_SSL)) {
            return this.createSSLServerSocket(type, inetSocketAddress);
        }
        ServerSocket serverSocket = null;
        if (this.orb.getORBData().acceptorSocketType().equals("SocketChannel")) {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocket = serverSocketChannel.socket();
        } else {
            serverSocket = new ServerSocket();
        }
        serverSocket.bind(inetSocketAddress);
        return serverSocket;
    }

    public Socket createSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        try {
            String host = inetSocketAddress.getHostName();
            int port = inetSocketAddress.getPort();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "createSocket(" + type + ", " + host + ", " + port + ")");
            }
            if (type.equals("SSL") || type.equals(SSL_MUTUALAUTH)) {
                return this.createSSLSocket(host, port);
            }
            Socket socket = null;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Creating CLEAR_TEXT socket for:" + port);
            }
            if (this.orb.getORBData().connectionSocketType().equals("SocketChannel")) {
                SocketChannel socketChannel = ORBUtility.openSocketChannel((SocketAddress)inetSocketAddress);
                socket = socketChannel.socket();
            } else {
                socket = new Socket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            }
            this.enableSOKeepAliveAsRequired(socket);
            socket.setTcpNoDelay(true);
            return socket;
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception creating socket", ex);
            }
            throw new RuntimeException(ex);
        }
    }

    public void setAcceptedSocketOptions(Acceptor acceptor, ServerSocket serverSocket, Socket socket) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "setAcceptedSocketOptions: " + acceptor + " " + serverSocket + " " + socket);
        }
        try {
            socket.setTcpNoDelay(true);
            this.enableSOKeepAliveAsRequired(socket);
        }
        catch (SocketException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ServerSocket createSSLServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        if (inetSocketAddress == null) {
            throw new IOException(this.getFormatMessage("iiop.invalid_sslserverport", new Object[]{null}));
        }
        int port = inetSocketAddress.getPort();
        Integer iport = port;
        SSLInfo sslInfo = this.portToSSLInfo.get(iport);
        if (sslInfo == null) {
            throw new IOException(this.getFormatMessage("iiop.invalid_sslserverport", new Object[]{iport}));
        }
        SSLServerSocketFactory ssf = sslInfo.getContext().getServerSocketFactory();
        String[] ssl3TlsCiphers = sslInfo.getSsl3TlsCiphers();
        String[] ssl2Ciphers = sslInfo.getSsl2Ciphers();
        String[] ciphers = null;
        if (ssl3TlsCiphers != null || ssl2Ciphers != null) {
            String[] socketCiphers = ssf.getDefaultCipherSuites();
            ciphers = this.mergeCiphers(socketCiphers, ssl3TlsCiphers, ssl2Ciphers);
        }
        String[] cs = null;
        if (_logger.isLoggable(Level.FINE)) {
            cs = ssf.getSupportedCipherSuites();
            for (int i = 0; i < cs.length; ++i) {
                _logger.log(Level.FINE, "Cipher Suite: " + cs[i]);
            }
        }
        ServerSocket ss = null;
        try {
            ss = ssf.createServerSocket(port, 50, inetSocketAddress.getAddress());
            if (ciphers != null) {
                ((SSLServerSocket)ss).setEnabledCipherSuites(ciphers);
            }
            if (sslInfo.allowedProtocols.size() > 0) {
                ArrayList<String> socketSupported = new ArrayList<String>(Arrays.asList(((SSLServerSocket)ss).getSupportedProtocols()));
                ArrayList<String> allowedProtocols = new ArrayList<String>();
                for (String protocolName : sslInfo.allowedProtocols) {
                    if (!socketSupported.contains(protocolName)) continue;
                    allowedProtocols.add(protocolName);
                }
                if (allowedProtocols.size() > 0) {
                    ((SSLServerSocket)ss).setEnabledProtocols(allowedProtocols.toArray(new String[allowedProtocols.size()]));
                }
            }
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "iiop.createsocket_exception", new Object[]{type, String.valueOf(port)});
            _logger.log(Level.SEVERE, "", e);
            throw e;
        }
        try {
            if (type.equals(SSL_MUTUALAUTH)) {
                _logger.log(Level.FINE, "Setting Mutual auth");
                ((SSLServerSocket)ss).setNeedClientAuth(true);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.cipher_exception", e);
            throw new IOException(e.getMessage());
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Created server socket:" + ss);
        }
        return ss;
    }

    private Socket createSSLSocket(String host, int port) throws IOException {
        SSLSocket socket = null;
        SSLSocketFactory factory = null;
        try {
            factory = this.clientSslInfo.getContext().getSocketFactory();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Creating SSL Socket for host:" + host + " port:" + port);
            }
            String[] ssl3TlsCiphers = this.clientSslInfo.getSsl3TlsCiphers();
            String[] ssl2Ciphers = this.clientSslInfo.getSsl2Ciphers();
            String[] clientCiphers = null;
            if (ssl3TlsCiphers != null || ssl2Ciphers != null) {
                String[] socketCiphers = factory.getDefaultCipherSuites();
                clientCiphers = this.mergeCiphers(socketCiphers, ssl3TlsCiphers, ssl2Ciphers);
            }
            socket = (SSLSocket)factory.createSocket(host, port);
            if (clientCiphers != null) {
                socket.setEnabledCipherSuites(clientCiphers);
            }
            this.enableSOKeepAliveAsRequired(socket);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "iiop.createsocket_exception", new Object[]{host, String.valueOf(port)});
                _logger.log(Level.FINE, "", e);
            }
            IOException e2 = new IOException("Error opening SSL socket to host=" + host + " port=" + port);
            e2.initCause(e);
            throw e2;
        }
        return socket;
    }

    private String[] getEnabledCipherSuites(String cipherSuiteStr, boolean ssl2Enabled, boolean ssl3Enabled, boolean tlsEnabled, boolean tlsEnabled11, boolean tlsEnabled12, boolean tlsEnabled13) {
        String[] cipherArr = null;
        if (cipherSuiteStr != null && cipherSuiteStr.length() > 0) {
            ArrayList<String> cipherList = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(cipherSuiteStr, ",");
            while (tokens.hasMoreTokens()) {
                CipherInfo cipherInfo;
                String cipher;
                String cipherAction = tokens.nextToken();
                if (cipherAction.startsWith("+")) {
                    cipher = cipherAction.substring(1);
                    cipherInfo = CipherInfo.getCipherInfo((String)cipher);
                    if (cipherInfo != null && this.isValidProtocolCipher(cipherInfo, ssl2Enabled, ssl3Enabled, tlsEnabled, tlsEnabled11, tlsEnabled12, tlsEnabled13)) {
                        cipherList.add(cipherInfo.getCipherName());
                        continue;
                    }
                    throw new IllegalStateException(this.getFormatMessage("iiop.unknown_cipher", new Object[]{cipher}));
                }
                if (cipherAction.startsWith("-")) {
                    cipher = cipherAction.substring(1);
                    cipherInfo = CipherInfo.getCipherInfo((String)cipher);
                    if (cipherInfo != null && this.isValidProtocolCipher(cipherInfo, ssl2Enabled, ssl3Enabled, tlsEnabled, tlsEnabled11, tlsEnabled12, tlsEnabled13)) continue;
                    throw new IllegalStateException(this.getFormatMessage("iiop.unknown_cipher", new Object[]{cipher}));
                }
                if (cipherAction.trim().length() <= 0) continue;
                throw new IllegalStateException(this.getFormatMessage("iiop.invalid_cipheraction", new Object[]{cipherAction}));
            }
            cipherArr = cipherList.toArray(new String[cipherList.size()]);
        }
        return cipherArr;
    }

    private String[] mergeCiphers(String[] enableCiphers, String[] ssl3TlsCiphers, String[] ssl2Ciphers) {
        CipherInfo cInfo;
        String cipher;
        int i;
        int eSize;
        if (ssl3TlsCiphers == null && ssl2Ciphers == null) {
            return null;
        }
        int n = eSize = enableCiphers != null ? enableCiphers.length : 0;
        if (_logger.isLoggable(Level.FINE)) {
            StringBuilder buf = new StringBuilder("Default socket ciphers: ");
            for (i = 0; i < eSize; ++i) {
                buf.append(enableCiphers[i] + ", ");
            }
            _logger.log(Level.FINE, buf.toString());
        }
        ArrayList<String> cList = new ArrayList<String>();
        if (ssl3TlsCiphers != null) {
            for (i = 0; i < ssl3TlsCiphers.length; ++i) {
                cList.add(ssl3TlsCiphers[i]);
            }
        } else {
            for (i = 0; i < eSize; ++i) {
                cipher = enableCiphers[i];
                cInfo = CipherInfo.getCipherInfo((String)cipher);
                if (cInfo == null || !cInfo.isTLS() && !cInfo.isSSL3()) continue;
                cList.add(cipher);
            }
        }
        if (ssl2Ciphers != null) {
            for (i = 0; i < ssl2Ciphers.length; ++i) {
                cList.add(ssl2Ciphers[i]);
            }
        } else {
            for (i = 0; i < eSize; ++i) {
                cipher = enableCiphers[i];
                cInfo = CipherInfo.getCipherInfo((String)cipher);
                if (cInfo == null || !cInfo.isSSL2()) continue;
                cList.add(cipher);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Merged socket ciphers: " + cList);
        }
        return cList.toArray(new String[cList.size()]);
    }

    private boolean isValidProtocolCipher(CipherInfo cipherInfo, boolean ssl2Enabled, boolean ssl3Enabled, boolean tlsEnabled, boolean tlsEnabled11, boolean tlsEnabled12, boolean tlsEnabled13) {
        return tlsEnabled && cipherInfo.isTLS() || tlsEnabled11 && cipherInfo.isTLS() || tlsEnabled12 && cipherInfo.isTLS() || tlsEnabled13 && cipherInfo.isTLS() || ssl3Enabled && cipherInfo.isSSL3() || ssl2Enabled && cipherInfo.isSSL2();
    }

    private void enableSOKeepAliveAsRequired(Socket socket) throws SocketException {
        boolean shouldSet;
        block10: {
            shouldSet = false;
            try {
                IiopService iiopService = IIOPUtils.getInstance().getIiopService();
                for (IiopListener iiopListener : IIOPUtils.getInstance().getIiopService().getIiopListener()) {
                    if (Integer.valueOf(iiopListener.getPort()).intValue() != socket.getLocalPort()) continue;
                    if (System.getProperty(SO_KEEPALIVE) == null && Boolean.getBoolean(SO_KEEPALIVE_DEPRECATED) || Boolean.getBoolean(SO_KEEPALIVE)) {
                        if (this.soKeepAlivePropertyPresentOnIiopListener(iiopListener)) {
                            if (this.soKeepAlivePropertyEnabledOnIiopListener(iiopListener)) {
                                shouldSet = true;
                            }
                        } else {
                            shouldSet = true;
                        }
                    } else if (this.soKeepAlivePropertyPresentOnIiopListener(iiopListener) && this.soKeepAlivePropertyEnabledOnIiopListener(iiopListener)) {
                        shouldSet = true;
                    }
                    break;
                }
            }
            catch (NotServerException notServerException) {
                if (!Boolean.getBoolean(SO_KEEPALIVE) || socket.getKeepAlive()) break block10;
                shouldSet = true;
            }
        }
        if (shouldSet) {
            _logger.log(Level.FINER, "Enabling SO_KEEPALIVE");
            socket.setKeepAlive(true);
        }
    }

    private boolean soKeepAlivePropertyPresentOnIiopListener(IiopListener iiopListener) {
        boolean soKeepAlivePropertyPresentOnListener = false;
        if (iiopListener.getPropertyValue(SO_KEEPALIVE) != null || iiopListener.getPropertyValue(SO_KEEPALIVE_DEPRECATED) != null) {
            soKeepAlivePropertyPresentOnListener = true;
        }
        return soKeepAlivePropertyPresentOnListener;
    }

    private boolean soKeepAlivePropertyEnabledOnIiopListener(IiopListener iiopListener) {
        boolean soKeepAliveEnabledOnListener = false;
        if (iiopListener.getPropertyValue(SO_KEEPALIVE) == null && Boolean.valueOf(iiopListener.getPropertyValue(SO_KEEPALIVE_DEPRECATED)).booleanValue() || Boolean.valueOf(iiopListener.getPropertyValue(SO_KEEPALIVE)).booleanValue()) {
            soKeepAliveEnabledOnListener = true;
        }
        return soKeepAliveEnabledOnListener;
    }

    private String getFormatMessage(String key, Object[] params) {
        return MessageFormat.format(_logger.getResourceBundle().getString(key), params);
    }

    class SSLInfo {
        private final SSLContext ctx;
        private String[] ssl3TlsCiphers = null;
        private String[] ssl2Ciphers = null;
        private ArrayList<String> allowedProtocols;

        SSLInfo(SSLContext ctx, String[] ssl3TlsCiphers, String[] ssl2Ciphers) {
            this.ctx = ctx;
            this.ssl3TlsCiphers = ssl3TlsCiphers;
            this.ssl2Ciphers = ssl2Ciphers;
            this.allowedProtocols = new ArrayList();
        }

        SSLContext getContext() {
            return this.ctx;
        }

        void addProtocol(String protocol) {
            this.allowedProtocols.add(protocol);
        }

        String[] getSsl3TlsCiphers() {
            return this.ssl3TlsCiphers;
        }

        String[] getSsl2Ciphers() {
            return this.ssl2Ciphers;
        }
    }
}

