/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.enterprise.container.common.spi.JCDIService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Inject;
import javax.inject.Scope;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.Rank;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.WeldDeployer;
import org.glassfish.weld.connector.WeldUtils;
import org.glassfish.weld.services.JCDIAroundConstructCallback;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.manager.api.WeldManager;
import org.jvnet.hk2.annotations.Service;

@Service
@Rank(value=10)
public class JCDIServiceImpl
implements JCDIService {
    @LogMessagesResourceBundle
    public static final String SHARED_LOGMESSAGE_RESOURCE = "org.glassfish.cdi.LogMessages";
    private static final HashSet<String> validScopes = new HashSet();
    private static final HashSet<String> excludedScopes;
    @Inject
    private WeldDeployer weldDeployer;
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationManager;
    @LoggerInfo(subsystem="AS-WELD", description="WELD", publish=true)
    public static final String WELD_LOGGER_SUBSYSTEM_NAME = "javax.enterprise.resource.weld";
    private static final Logger logger;

    public boolean isCurrentModuleJCDIEnabled() {
        BundleDescriptor bundle = null;
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv == null) {
            return false;
        }
        JndiNameEnvironment componentEnv = this.compEnvManager.getJndiNameEnvironment(inv.getComponentId());
        if (componentEnv != null) {
            if (componentEnv instanceof BundleDescriptor) {
                bundle = (BundleDescriptor)componentEnv;
            } else if (componentEnv instanceof com.sun.enterprise.deployment.EjbDescriptor) {
                bundle = ((com.sun.enterprise.deployment.EjbDescriptor)componentEnv).getEjbBundleDescriptor();
            }
        }
        return bundle != null ? this.isJCDIEnabled(bundle) : false;
    }

    public boolean isJCDIEnabled(BundleDescriptor bundle) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        return this.weldDeployer.is299Enabled(topLevelBundleDesc);
    }

    public boolean isCDIScoped(Class<?> clazz) {
        return WeldUtils.hasValidAnnotation(clazz, validScopes, excludedScopes);
    }

    public void setELResolver(ServletContext servletContext) throws NamingException {
        InitialContext context = new InitialContext();
        BeanManager beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
        if (beanManager != null) {
            servletContext.setAttribute("org.glassfish.jsp.beanManagerELResolver", beanManager.getELResolver());
        }
    }

    public <T> JCDIService.JCDIInjectionContext<T> createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejbDesc, T instance, Map<Class<?>, Object> ejbInfo) {
        return this._createJCDIInjectionContext(ejbDesc, instance, ejbInfo);
    }

    public <T> JCDIService.JCDIInjectionContext<T> createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejbDesc, Map<Class<?>, Object> ejbInfo) {
        return this._createJCDIInjectionContext(ejbDesc, null, ejbInfo);
    }

    private <T> JCDIService.JCDIInjectionContext<T> _createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejb, T instance, Map<Class<?>, Object> ejbInfo) {
        BaseContainer baseContainer = null;
        EJBContextImpl ejbContext = null;
        JCDIInjectionContextImpl jcdiCtx = null;
        WeldCreationalContext creationalContext = null;
        if (ejbInfo != null) {
            baseContainer = (BaseContainer)ejbInfo.get(BaseContainer.class);
            ejbContext = (EJBContextImpl)ejbInfo.get(EJBContextImpl.class);
        }
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)ejb.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.getBDAForBeanClass(topLevelBundleDesc, ejb.getEjbClassName());
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(ejb.getEjbBundleDescriptor().getApplication());
        BeanManagerImpl weldManager = bootstrap.getManager(bda);
        if (weldManager == null) {
            logger.severe("The reference for weldManager is not available, this is an un-sync state of the container");
            return null;
        }
        EjbDescriptor ejbDesc = weldManager.getEjbDescriptor(ejb.getName());
        if (null != ejbInfo) {
            jcdiCtx = (JCDIInjectionContextImpl)ejbInfo.get(JCDIService.JCDIInjectionContext.class);
        }
        if (null != jcdiCtx) {
            creationalContext = jcdiCtx.getCreationalContext();
        }
        if (null != jcdiCtx && creationalContext == null) {
            Bean bean = weldManager.getBean(ejbDesc);
            creationalContext = weldManager.createCreationalContext((Contextual)bean);
            jcdiCtx.setCreationalContext(creationalContext);
        }
        InjectionTarget<T> it = null;
        it = ejbDesc.isMessageDriven() ? this.createMdbInjectionTarget((WeldManager)weldManager, ejbDesc) : weldManager.createInjectionTarget(ejbDesc);
        if (null != jcdiCtx) {
            jcdiCtx.setInjectionTarget(it);
        }
        org.jboss.weld.contexts.WeldCreationalContext weldCreationalContext = (org.jboss.weld.contexts.WeldCreationalContext)creationalContext;
        weldCreationalContext.setConstructorInterceptionSuppressed(true);
        JCDIAroundConstructCallback aroundConstructCallback = new JCDIAroundConstructCallback(baseContainer, ejbContext);
        weldCreationalContext.registerAroundConstructCallback(aroundConstructCallback);
        if (null != jcdiCtx) {
            jcdiCtx.setJCDIAroundConstructCallback(aroundConstructCallback);
        }
        T beanInstance = instance;
        if (null != jcdiCtx) {
            jcdiCtx.setInstance(beanInstance);
        }
        return jcdiCtx;
    }

    private <T> InjectionTarget<T> createMdbInjectionTarget(WeldManager weldManager, EjbDescriptor<T> ejbDesc) {
        AnnotatedType type = weldManager.createAnnotatedType(ejbDesc.getBeanClass());
        WeldInjectionTarget target = weldManager.createInjectionTargetBuilder(type).setDecorationEnabled(false).setInterceptionEnabled(false).setTargetClassLifecycleCallbacksEnabled(false).setBean(weldManager.getBean(ejbDesc)).build();
        return weldManager.fireProcessInjectionTarget(type, (InjectionTarget)target);
    }

    private BeanDeploymentArchive getBDAForBeanClass(BundleDescriptor bundleDesc, String beanClassName) {
        BeanDeploymentArchive topLevelBDA;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AS-CDI-00043", new Object[]{bundleDesc.getModuleName(), beanClassName});
        }
        if ((topLevelBDA = this.weldDeployer.getBeanDeploymentArchiveForBundle(bundleDesc)).getBeanClasses().contains(beanClassName)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "AS-CDI-00044", new Object[]{topLevelBDA.getId(), beanClassName});
            }
            return topLevelBDA;
        }
        for (BeanDeploymentArchive bda : topLevelBDA.getBeanDeploymentArchives()) {
            if (!bda.getBeanClasses().contains(beanClassName)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "AS-CDI-00045", new Object[]{bda.getId(), beanClassName});
            }
            return bda;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AS-CDI-00046", new Object[]{topLevelBDA.getId(), beanClassName});
        }
        return topLevelBDA;
    }

    public <T> void injectEJBInstance(JCDIService.JCDIInjectionContext<T> injectionCtx) {
        JCDIInjectionContextImpl injectionCtxImpl = (JCDIInjectionContextImpl)injectionCtx;
        injectionCtxImpl.inject();
    }

    public <T> JCDIService.JCDIInjectionContext<T> createManagedObject(Class<T> managedClass, BundleDescriptor bundle) {
        return this.createManagedObject(managedClass, bundle, true);
    }

    public <T> void injectManagedObject(T managedObject, BundleDescriptor bundle) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.weldDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(bundle.getApplication());
        BeanManagerImpl beanManager = bootstrap.getManager(bda);
        AnnotatedType annotatedType = beanManager.createAnnotatedType(managedObject.getClass());
        InjectionTarget it = beanManager.createInjectionTarget(annotatedType);
        CreationalContext cc = beanManager.createCreationalContext(null);
        it.inject(managedObject, cc);
    }

    private Interceptor findEjbInterceptor(Class interceptorClass, Set<EjbInterceptor> ejbInterceptors) {
        for (EjbInterceptor oneInterceptor : ejbInterceptors) {
            Interceptor interceptor = oneInterceptor.getInterceptor();
            if (interceptor == null || !interceptor.getBeanClass().equals(interceptorClass)) continue;
            return oneInterceptor.getInterceptor();
        }
        return null;
    }

    public <T> T createInterceptorInstance(Class<T> interceptorClass, com.sun.enterprise.deployment.EjbDescriptor ejb, JCDIService.JCDIInjectionContext<T> ejbContext, Set<EjbInterceptor> ejbInterceptors) {
        Bean interceptorBean;
        Interceptor interceptor;
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)ejb.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.getBDAForBeanClass(topLevelBundleDesc, ejb.getEjbClassName());
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(ejb.getEjbBundleDescriptor().getApplication());
        BeanManagerImpl beanManager = bootstrap.getManager(bda);
        EjbDescriptor ejbDesc = beanManager.getEjbDescriptor(ejb.getName());
        CreationalContext creationalContext = ejbContext.getCreationalContext();
        if (creationalContext == null) {
            SessionBean bean = beanManager.getBean(ejbDesc);
            creationalContext = beanManager.createCreationalContext((Contextual)bean);
            ejbContext.setCreationalContext(creationalContext);
        }
        if ((interceptor = this.findEjbInterceptor(interceptorClass, ejbInterceptors)) != null) {
            Object instance = beanManager.getReference((Bean)interceptor, interceptorClass, creationalContext);
            return (T)instance;
        }
        Set availableBeans = beanManager.getBeans(interceptorClass, new Annotation[0]);
        if (availableBeans != null && !availableBeans.isEmpty()) {
            interceptorBean = beanManager.resolve(availableBeans);
        } else {
            AnnotatedType annotatedType = beanManager.createAnnotatedType(interceptorClass);
            BeanAttributes attributes = beanManager.createBeanAttributes(annotatedType);
            EnhancedAnnotatedType enhancedAnnotatedType = beanManager.createEnhancedAnnotatedType(interceptorClass);
            interceptorBean = InterceptorImpl.of((BeanAttributes)attributes, (EnhancedAnnotatedType)enhancedAnnotatedType, (BeanManagerImpl)beanManager);
        }
        Object instance = beanManager.getReference(interceptorBean, interceptorClass, creationalContext);
        return (T)instance;
    }

    public <T> JCDIService.JCDIInjectionContext<T> createManagedObject(Class<T> managedClass, BundleDescriptor bundle, boolean invokePostConstruct) {
        InjectionTarget it;
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.weldDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(bundle.getApplication());
        BeanManagerImpl beanManager = bootstrap.getManager(bda);
        NoPostConstructPreDestroyAnnotatedType annotatedType = beanManager.createAnnotatedType(managedClass);
        if (!invokePostConstruct) {
            annotatedType = new NoPostConstructPreDestroyAnnotatedType(annotatedType);
        }
        if ((it = ((BeanDeploymentArchiveImpl)bda).getInjectionTarget(annotatedType)) == null) {
            it = ((WeldManager)beanManager).fireProcessInjectionTarget(annotatedType);
        }
        CreationalContext cc = beanManager.createCreationalContext(null);
        Object managedObject = it.produce(cc);
        it.inject(managedObject, cc);
        if (invokePostConstruct) {
            it.postConstruct(managedObject);
        }
        return new JCDIInjectionContextImpl<Object>(it, cc, managedObject);
    }

    public <T> JCDIService.JCDIInjectionContext<T> createEmptyJCDIInjectionContext() {
        return new JCDIInjectionContextImpl();
    }

    static {
        validScopes.add(Scope.class.getName());
        validScopes.add(NormalScope.class.getName());
        validScopes.add(RequestScoped.class.getName());
        validScopes.add(SessionScoped.class.getName());
        validScopes.add(ApplicationScoped.class.getName());
        validScopes.add(ConversationScoped.class.getName());
        excludedScopes = new HashSet();
        excludedScopes.add(Dependent.class.getName());
        logger = Logger.getLogger(WELD_LOGGER_SUBSYSTEM_NAME, SHARED_LOGMESSAGE_RESOURCE);
    }

    private static class JCDIInjectionContextImpl<T>
    implements JCDIService.JCDIInjectionContext<T> {
        InjectionTarget<T> it;
        CreationalContext<T> cc;
        private T instance;
        private final List<JCDIService.JCDIInjectionContext<T>> dependentContexts = new ArrayList<JCDIService.JCDIInjectionContext<T>>();
        private JCDIAroundConstructCallback jcdiAroundConstructCallback;

        public JCDIInjectionContextImpl() {
        }

        public JCDIInjectionContextImpl(InjectionTarget<T> it, CreationalContext<T> cc, T i) {
            this.it = it;
            this.cc = cc;
            this.instance = i;
        }

        void inject() {
            this.it.inject(this.getInstance(), this.cc);
        }

        public T getInstance() {
            if (this.instance == null) {
                if (this.it == null || this.cc == null) {
                    throw new IllegalStateException("Incomplete injection context: it=" + this.it + " cc=" + this.cc);
                }
                this.instance = this.it.produce(this.cc);
            }
            return this.instance;
        }

        public void setInstance(T instance) {
            this.instance = instance;
        }

        public void cleanup(boolean callPreDestroy) {
            for (JCDIService.JCDIInjectionContext<T> context : this.dependentContexts) {
                context.cleanup(true);
            }
            if (callPreDestroy && this.it != null) {
                this.it.preDestroy(this.instance);
            }
            if (this.it != null) {
                this.it.dispose(this.instance);
            }
            if (this.cc != null) {
                this.cc.release();
            }
        }

        public InjectionTarget<T> getInjectionTarget() {
            return this.it;
        }

        public void setInjectionTarget(InjectionTarget<T> injectionTarget) {
            this.it = injectionTarget;
        }

        public CreationalContext<T> getCreationalContext() {
            return this.cc;
        }

        public void setCreationalContext(CreationalContext<T> creationalContext) {
            this.cc = creationalContext;
        }

        public void addDependentContext(JCDIService.JCDIInjectionContext<T> dependentContext) {
            this.dependentContexts.add(dependentContext);
        }

        public Collection<JCDIService.JCDIInjectionContext<T>> getDependentContexts() {
            return this.dependentContexts;
        }

        public T createEjbAfterAroundConstruct() {
            if (null != this.jcdiAroundConstructCallback) {
                this.setInstance(this.jcdiAroundConstructCallback.createEjb());
            }
            return this.getInstance();
        }

        public void setJCDIAroundConstructCallback(JCDIAroundConstructCallback jcdiAroundConstructCallback) {
            this.jcdiAroundConstructCallback = jcdiAroundConstructCallback;
        }
    }

    private static class NoPostConstructPreDestroyAnnotatedType<X>
    implements AnnotatedType<X> {
        private final AnnotatedType<X> delegate;

        private NoPostConstructPreDestroyAnnotatedType(AnnotatedType<X> delegate) {
            this.delegate = delegate;
        }

        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return (T)this.delegate.getAnnotation(annotationType);
        }

        public Set<Annotation> getAnnotations() {
            return this.delegate.getAnnotations();
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.delegate.isAnnotationPresent(annotationType);
        }

        public Class<X> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        public Set<AnnotatedConstructor<X>> getConstructors() {
            return this.delegate.getConstructors();
        }

        public Set<AnnotatedMethod<? super X>> getMethods() {
            HashSet<AnnotatedMethod<X>> retVal = new HashSet<AnnotatedMethod<X>>();
            for (AnnotatedMethod m : this.delegate.getMethods()) {
                if (m.isAnnotationPresent(PostConstruct.class) || m.isAnnotationPresent(PreDestroy.class)) continue;
                retVal.add(m);
            }
            return retVal;
        }

        public Set<AnnotatedField<? super X>> getFields() {
            return this.delegate.getFields();
        }
    }
}

