/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import com.sun.enterprise.config.serverbeans.Application;
import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

public class ApplicationConfigSource
extends PayaraConfigSource {
    private final String configurationName;

    public ApplicationConfigSource(String configurationName) {
        this.configurationName = configurationName;
    }

    public Map<String, String> getProperties() {
        Application config = this.domainConfiguration.getApplications().getApplication(this.configurationName);
        HashMap<String, String> result = new HashMap<String, String>();
        if (config != null) {
            List properties = config.getProperty();
            for (Property property : properties) {
                if (!property.getName().startsWith("payara.microprofile.")) continue;
                result.put(property.getName().substring("payara.microprofile.".length()), property.getValue());
            }
        }
        return result;
    }

    public int getOrdinal() {
        String storedOrdinal = this.getValue("config_ordinal");
        if (storedOrdinal != null) {
            return Integer.parseInt(storedOrdinal);
        }
        return Integer.parseInt(this.configService.getMPConfig().getApplicationOrdinality());
    }

    public String getValue(String propertyName) {
        String result = null;
        Application app = this.domainConfiguration.getApplications().getApplication(this.configurationName);
        if (app != null) {
            result = app.getPropertyValue("payara.microprofile." + propertyName);
        }
        return result;
    }

    public String getName() {
        return "Application";
    }

    public boolean setValue(final String propertyName, final String propertyValue) throws TransactionFailure {
        boolean result = false;
        Application app = this.domainConfiguration.getApplications().getApplication(this.configurationName);
        if (app != null) {
            Property p = app.getProperty("payara.microprofile." + propertyName);
            if (p == null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Application>(){

                    public Object run(Application config) throws TransactionFailure, PropertyVetoException {
                        Property prop = (Property)config.createChild(Property.class);
                        prop.setName("payara.microprofile." + propertyName);
                        prop.setValue(propertyValue);
                        config.getProperty().add(prop);
                        return null;
                    }
                }, (ConfigBeanProxy)app);
            } else {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Property>(){

                    public Object run(Property config) throws TransactionFailure, PropertyVetoException {
                        config.setValue(propertyValue);
                        return null;
                    }
                }, (ConfigBeanProxy)p);
            }
            result = true;
        }
        return result;
    }

    public boolean deleteValue(String propertyName) throws TransactionFailure {
        boolean result = false;
        Application app = this.domainConfiguration.getApplications().getApplication(this.configurationName);
        if (app != null) {
            for (Property object : app.getProperty()) {
                if (!("payara.microprofile." + propertyName).equals(object.getName())) continue;
                ConfigSupport.deleteChild((ConfigBean)((ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)app)), (ConfigBean)((ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)object)));
                result = true;
            }
        }
        return result;
    }
}

