/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.spi;

import fish.payara.nucleus.microprofile.config.spi.ConfigValueImpl;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.glassfish.config.support.TranslatedConfigView;

final class ConfigExpressionResolver {
    private final Iterable<ConfigSource> sources;
    private final boolean expansionEnabled;
    private final Set<String> resolvingExpressions;
    private final String profile;

    protected ConfigExpressionResolver(Iterable<ConfigSource> sources) {
        this(sources, true, null);
    }

    protected ConfigExpressionResolver(Iterable<ConfigSource> sources, String profile) {
        this(sources, true, profile);
    }

    protected ConfigExpressionResolver(Iterable<ConfigSource> sources, boolean expansionEnabled) {
        this(sources, expansionEnabled, null);
    }

    protected ConfigExpressionResolver(Iterable<ConfigSource> sources, boolean expansionEnabled, String profile) {
        this.sources = sources;
        this.expansionEnabled = expansionEnabled;
        this.resolvingExpressions = new HashSet<String>();
        this.profile = profile;
    }

    protected ConfigValueImpl resolve(String propertyName) {
        return this.resolve(propertyName, null);
    }

    protected ConfigValueImpl resolve(String propertyName, String propertyDefault) {
        return this.resolve(propertyName, propertyDefault, false);
    }

    private ConfigValueImpl resolve(String propertyName, String propertyDefault, boolean resolveDefault) {
        String translated = TranslatedConfigView.expandConfigValue((String)propertyName);
        if (!translated.equals(propertyName)) {
            return new ConfigValueImpl(propertyName, translated, this.resolveExpression(translated), "TranslatedConfigView", 0);
        }
        String profiledPropertyName = this.resolveExpression((this.profile == null ? "" : "%" + this.profile + ".") + propertyName);
        ConfigValueImpl result = this.getValue(profiledPropertyName);
        if (result == null) {
            String resolvedPropertyName = this.resolveExpression(propertyName);
            result = this.getValue(resolvedPropertyName);
        }
        if (result == null) {
            result = new ConfigValueImpl(profiledPropertyName, propertyDefault, resolveDefault ? this.resolveExpression(propertyDefault) : propertyDefault, null, 0);
        }
        return result;
    }

    private ConfigValueImpl getValue(String propertyName) {
        for (ConfigSource source : this.sources) {
            String result = source.getValue(propertyName);
            if (result == null || result.isEmpty()) continue;
            return new ConfigValueImpl(propertyName, result, this.resolveExpression(result), source.getName(), source.getOrdinal());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String resolveExpression(String expression) {
        if (expression == null) {
            return null;
        }
        if (!this.expansionEnabled) {
            return expression;
        }
        if (this.resolvingExpressions.contains(expression)) {
            throw new IllegalArgumentException("Infinitely recursive expression found within expression: " + expression);
        }
        String result = "";
        try {
            this.resolvingExpressions.add(expression);
            char[] characters = expression.toCharArray();
            boolean isExpression = false;
            String expressionBuilder = "";
            boolean isDefaultValue = false;
            String expressionDefaultBuilder = "";
            boolean defaultValueFound = false;
            int bracketDepth = 0;
            for (int i = 0; i < characters.length; ++i) {
                char c = characters[i];
                if (c == ':' && bracketDepth == 1) {
                    isDefaultValue = true;
                    defaultValueFound = true;
                    continue;
                }
                if (bracketDepth == 0 && ConfigExpressionResolver.isExpressionStart(characters, i)) continue;
                if (ConfigExpressionResolver.isExpressionStart(characters, i - 1) && bracketDepth++ == 0) {
                    isExpression = true;
                    continue;
                }
                if (isExpression && ConfigExpressionResolver.isExpressionEnd(characters, i) && bracketDepth-- == 1) {
                    isDefaultValue = false;
                    isExpression = false;
                } else if (ConfigExpressionResolver.isCharacterEscaped(characters, i + 1) && !ConfigExpressionResolver.isCharacterEscaped(characters, i)) continue;
                if (isDefaultValue) {
                    expressionDefaultBuilder = expressionDefaultBuilder + c;
                    continue;
                }
                if (isExpression) {
                    expressionBuilder = expressionBuilder + c;
                    continue;
                }
                if (expressionBuilder.isEmpty()) {
                    result = result + c;
                    continue;
                }
                String resolvedExpression = this.resolve(expressionBuilder, expressionDefaultBuilder, true).getValue();
                expressionBuilder = "";
                expressionDefaultBuilder = "";
                if (resolvedExpression != null) {
                    result = result + resolvedExpression;
                }
                if (!result.isEmpty() || defaultValueFound) continue;
                throw new NoSuchElementException("Unable to resolve expression " + expression);
            }
        }
        finally {
            this.resolvingExpressions.remove(expression);
        }
        return result;
    }

    private static boolean isExpressionStart(char[] characters, int index) {
        return index >= 0 && index + 1 < characters.length && characters[index] == '$' && characters[index + 1] == '{' && !ConfigExpressionResolver.isCharacterEscaped(characters, index);
    }

    private static boolean isExpressionEnd(char[] characters, int index) {
        return index >= 0 && index < characters.length && characters[index] == '}' && !ConfigExpressionResolver.isCharacterEscaped(characters, index);
    }

    private static boolean isCharacterEscaped(char[] characters, int index) {
        boolean backslashFound;
        if (index == 0 || index >= characters.length) {
            return false;
        }
        char c = characters[index];
        boolean bl = backslashFound = characters[index - 1] == '\\';
        if (!backslashFound) {
            return false;
        }
        switch (c) {
            case '$': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }
}

