/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.spi;

import fish.payara.nucleus.microprofile.config.converters.ArrayConverter;
import fish.payara.nucleus.microprofile.config.converters.AutomaticConverter;
import fish.payara.nucleus.microprofile.config.spi.ConfigExpressionResolver;
import fish.payara.nucleus.microprofile.config.spi.ConfigSourceComparator;
import fish.payara.nucleus.microprofile.config.spi.ConfigValueImpl;
import fish.payara.nucleus.microprofile.config.spi.ConfigValueResolver;
import fish.payara.nucleus.microprofile.config.spi.ConfigValueResolverImpl;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class PayaraConfig
implements Config {
    private static final String MP_CONFIG_CACHE_DURATION = "mp.config.cache.duration";
    private static final String MP_CONFIG_EXPANSION_ENABLED_STRING = "mp.config.property.expressions.enabled";
    private static final String MP_CONFIG_PROFILE_NAME_STRING = "mp.config.profile";
    private final List<ConfigSource> sources;
    private final Map<Class<?>, Converter<?>> converters;
    private final long defaultCacheDurationSeconds;
    private final Map<String, CacheEntry> cachedValuesByProperty = new ConcurrentHashMap<String, CacheEntry>();
    private volatile Long configuredCacheValue = null;
    private final Object configuredCacheValueLock = new Object();
    private final String profile;

    public PayaraConfig(List<ConfigSource> sources, Map<Class<?>, Converter<?>> converters, long defaultCacheDurationSeconds) {
        this.sources = sources;
        this.converters = new ConcurrentHashMap(converters);
        this.defaultCacheDurationSeconds = defaultCacheDurationSeconds;
        Collections.sort(sources, new ConfigSourceComparator());
        this.profile = this.getConfigValue(MP_CONFIG_PROFILE_NAME_STRING).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCacheDurationSeconds() {
        Optional converter = Optional.ofNullable(this.converters.get(Long.class));
        if (converter.isPresent()) {
            Object object = this.configuredCacheValueLock;
            synchronized (object) {
                if (this.configuredCacheValue != null && this.configuredCacheValue > System.currentTimeMillis()) {
                    return this.configuredCacheValue;
                }
                ConfigValueImpl value = this.searchConfigSources(MP_CONFIG_CACHE_DURATION, null);
                if (value.getValue() != null) {
                    this.configuredCacheValue = (Long)this.convertValue(value, null, converter);
                    return this.configuredCacheValue;
                }
                this.configuredCacheValue = this.defaultCacheDurationSeconds;
            }
        }
        return this.defaultCacheDurationSeconds;
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        if (propertyType == ConfigValueResolver.class) {
            return (T)new ConfigValueResolverImpl(this, propertyName);
        }
        T value = this.getValueInternal(propertyName, propertyType);
        if (value != null && propertyType.isArray() && Array.getLength(value) == 0) {
            throw new NoSuchElementException("No value for key of" + propertyName);
        }
        ConfigValueResolverImpl.throwWhenNotExists(propertyName, value);
        return value;
    }

    public ConfigValue getConfigValue(String propertyName) {
        return this.getValue(propertyName, ConfigValue.class);
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        T internalValue = this.getValueInternal(propertyName, propertyType);
        if (internalValue != null && propertyType.isArray() && Array.getLength(internalValue) == 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(internalValue);
    }

    public <T> Optional<List<T>> getOptionalValues(String propertyName, Class<T> propertyType) {
        return super.getOptionalValues(propertyName, propertyType).filter(list -> !list.isEmpty());
    }

    private <T> T getValueInternal(String propertyName, Class<T> propertyType) {
        if (propertyType == ConfigValue.class) {
            return (T)this.getConfigValue(propertyName, ConfigValueResolverImpl.getCacheKey(propertyName, propertyType), null, null);
        }
        Optional converter = this.getConverter(propertyType);
        if (!converter.isPresent()) {
            throw new IllegalArgumentException("Unable to convert value to type " + propertyType.getName());
        }
        return this.getValue(propertyName, ConfigValueResolverImpl.getCacheKey(propertyName, propertyType), null, null, () -> converter);
    }

    public Iterable<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ConfigSource configSource : this.sources) {
            result.addAll(configSource.getPropertyNames());
        }
        return result;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.sources;
    }

    public Set<Class<?>> getConverterTypes() {
        return this.converters.keySet();
    }

    protected <T> T getValue(String propertyName, String cacheKey, Long ttl, String defaultValue, Supplier<Optional<Converter<T>>> converter) {
        ConfigValueImpl result = this.getConfigValue(propertyName, cacheKey, ttl, defaultValue);
        return this.convertValue(result, defaultValue, converter.get());
    }

    protected ConfigValueImpl getConfigValue(String propertyName, String cacheKey, Long ttl, String defaultValue) {
        long entryTTL;
        long l = entryTTL = ttl != null ? ttl.longValue() : this.getCacheDurationSeconds();
        if (entryTTL <= 0L) {
            return this.searchConfigSources(propertyName, defaultValue);
        }
        String entryKey = cacheKey + (defaultValue != null ? ":" + defaultValue : "") + ":" + entryTTL / 1000L + "s";
        long now = System.currentTimeMillis();
        long expires = now + entryTTL;
        CacheEntry cacheEntry = this.cachedValuesByProperty.get(entryKey);
        if (cacheEntry != null && now < cacheEntry.expires) {
            return cacheEntry.value;
        }
        boolean isExpansionEnabled = this.isExpansionEnabled(propertyName);
        ConfigValueImpl newValue = this.searchConfigSources(propertyName, defaultValue, isExpansionEnabled);
        CacheEntry newCacheEntry = new CacheEntry(newValue, expires);
        cacheEntry = this.cachedValuesByProperty.compute(entryKey, (key, entry) -> {
            if (entry != null && newCacheEntry.expires < entry.expires) {
                return entry;
            }
            return newCacheEntry;
        });
        return cacheEntry.value;
    }

    private <T> T convertValue(ConfigValue configValue, String defaultValue, Optional<Converter<T>> optionalConverter) {
        Converter<T> converter;
        block5: {
            String sourceValue = configValue.getValue();
            if (sourceValue == null || sourceValue.isEmpty()) {
                return null;
            }
            if (!optionalConverter.isPresent()) {
                throw new IllegalArgumentException(String.format("Unable to find converter for property %s with value %s.", configValue.getName(), sourceValue));
            }
            converter = optionalConverter.get();
            try {
                if (sourceValue != null) {
                    return (T)converter.convert(sourceValue);
                }
            }
            catch (IllegalArgumentException ex) {
                if (defaultValue != null) break block5;
                throw ex;
            }
        }
        return (T)converter.convert(defaultValue);
    }

    public <T> Optional<Converter<T>> getConverter(Class<T> propertyType) {
        if (propertyType.isArray()) {
            return this.createArrayConverter(propertyType.getComponentType());
        }
        Class<?> type = PayaraConfig.boxedTypeOf(propertyType);
        Converter<?> converter = this.converters.get(type);
        if (converter != null) {
            return Optional.of(converter);
        }
        Optional<Converter<T>> automaticConverter = AutomaticConverter.forType(type);
        if (automaticConverter.isPresent()) {
            this.converters.put(type, automaticConverter.get());
            return automaticConverter;
        }
        return Optional.empty();
    }

    public void clearCache() {
        this.cachedValuesByProperty.clear();
    }

    private <E> Optional<Converter<Object>> createArrayConverter(Class<E> elementType) {
        Optional<Converter<E>> elementConverter = this.getConverter(elementType);
        if (!elementConverter.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new ArrayConverter<E>(elementType, this.getConverter(elementType).get()));
    }

    private ConfigValueImpl searchConfigSources(String propertyName, String defaultValue) {
        boolean expansionEnabled = this.isExpansionEnabled(propertyName);
        return this.searchConfigSources(propertyName, defaultValue, expansionEnabled);
    }

    private boolean isExpansionEnabled(String propertyName) {
        boolean expansionEnabled = !MP_CONFIG_CACHE_DURATION.equals(propertyName) && !MP_CONFIG_EXPANSION_ENABLED_STRING.equals(propertyName) && this.getOptionalValue(MP_CONFIG_EXPANSION_ENABLED_STRING, Boolean.class).orElse(true) != false;
        return expansionEnabled;
    }

    private ConfigValueImpl searchConfigSources(String propertyName, String defaultValue, boolean expansionEnabled) {
        return new ConfigExpressionResolver(this.sources, expansionEnabled, this.profile).resolve(propertyName, defaultValue);
    }

    static Class<?> boxedTypeOf(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        return Void.class;
    }

    public <T> T unwrap(Class<T> type) {
        if (type == PayaraConfig.class) {
            return (T)this;
        }
        throw new IllegalArgumentException("Unable to cast config source to type " + type);
    }

    public String getProfile() {
        return this.profile;
    }

    void addConfigSource(ConfigSource added) {
        this.sources.add(added);
        Collections.sort(this.sources, new ConfigSourceComparator());
    }

    private static final class CacheEntry {
        final ConfigValueImpl value;
        final long expires;

        CacheEntry(ConfigValueImpl value, long expires) {
            this.value = value;
            this.expires = expires;
        }
    }
}

