/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.monitor.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.admin.amx.config.AMXConfiguration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-monitoring-service-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.monitoring.service.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get-monitoring-service-configuration", description="List Monitoring Service Configuration")})
public class GetMonitoringServiceConfiguration
implements AdminCommand {
    @Inject
    private Target targetUtil;
    @Param(name="target", defaultValue="server", optional=true)
    private String target;

    @Override
    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            context.getActionReport().setMessage("No such config named: " + this.target);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        MonitoringService monitoringService = config.getMonitoringService();
        AMXConfiguration amxConfiguration = (AMXConfiguration)config.getExtensionByType(AMXConfiguration.class);
        ActionReport actionReport = context.getActionReport();
        String[] headers = new String[]{"Monitoring Enabled", "AMX Enabled", "MBeans Enabled", "DTrace Enabled"};
        ColumnFormatter columnFormatter = new ColumnFormatter(headers);
        columnFormatter.addRow(new Object[]{monitoringService.getMonitoringEnabled(), amxConfiguration.getEnabled(), monitoringService.getMbeanEnabled(), monitoringService.getDtraceEnabled()});
        actionReport.appendMessage(columnFormatter.toString());
        HashMap<String, String> extraPropertiesMap = new HashMap<String, String>();
        extraPropertiesMap.put("monitoringEnabled", monitoringService.getMonitoringEnabled());
        extraPropertiesMap.put("amxEnabled", amxConfiguration.getEnabled());
        extraPropertiesMap.put("mbeanEnabled", monitoringService.getMbeanEnabled());
        extraPropertiesMap.put("dtraceEnabled", monitoringService.getDtraceEnabled());
        Properties extraProperties = new Properties();
        extraProperties.put("getMonitoringServiceConfiguration", extraPropertiesMap);
        actionReport.setExtraProperties(extraProperties);
        actionReport.setMessage(columnFormatter.toString());
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

