/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXParseException;

@Service
public class ApplicationFactory {
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    ArchivistFactory archivistFactory;
    @Inject
    DasConfig dasConfig;
    protected static final Logger logger = DOLUtils.getDefaultLogger();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Archivist.class);

    public Application openArchive(URI jarFile, String archiveType) throws IOException, SAXParseException {
        return this.openArchive(jarFile, archiveType, false);
    }

    public Application openArchive(Archivist archivist, URI jarFile, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        ReadableArchive archive = this.archiveFactory.openArchive(jarFile);
        Application application = this.openArchive(archivist, archive, handleRuntimeInfo);
        archive.close();
        return application;
    }

    public Application openArchive(Archivist archivist, ReadableArchive in, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        return this.openArchive(in.getURI().getSchemeSpecificPart(), archivist, in, handleRuntimeInfo);
    }

    public Application openArchive(String appName, Archivist archivist, ReadableArchive in, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        Application application;
        archivist.setHandleRuntimeInfo(false);
        Object descriptor = archivist.open(in);
        if (descriptor instanceof Application) {
            application = (Application)descriptor;
            application.setAppName(appName);
            application.setRegistrationName(appName);
        } else {
            if (descriptor == null) {
                logger.log(Level.SEVERE, localStrings.getLocalString("enterprise.deployment.cannotreadDDs", "Cannot read the Deployment Descriptors for module {0}", new Object[]{in.getURI()}));
                return null;
            }
            ModuleDescriptor newModule = archivist.createModuleDescriptor(descriptor);
            newModule.setArchiveUri(in.getURI().getSchemeSpecificPart());
            application = Application.createVirtualApplication(appName, (ModuleDescriptor<BundleDescriptor>)newModule);
        }
        if (handleRuntimeInfo) {
            archivist.setHandleRuntimeInfo(true);
            archivist.readRuntimeDeploymentDescriptor(in, descriptor);
        }
        if (application != null) {
            application.setClassLoader(archivist.getClassLoader());
            application.visit(new ApplicationValidator());
        }
        return application;
    }

    public Application createApplicationFromStandardDD(ReadableArchive archive, String archiveType) throws IOException, SAXParseException {
        Archivist archivist = this.archivistFactory.getArchivist(archiveType, null);
        String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
        archivist.setXMLValidationLevel(xmlValidationLevel);
        if (xmlValidationLevel.equals("none")) {
            archivist.setXMLValidation(false);
        }
        Object desc = archivist.readStandardDeploymentDescriptor(archive);
        Application application = null;
        if (desc instanceof Application) {
            application = (Application)desc;
        } else {
            ModuleDescriptor newModule = archivist.createModuleDescriptor(desc);
            newModule.setArchiveUri(archive.getURI().getSchemeSpecificPart());
            String moduleName = newModule.getModuleName();
            application = Application.createVirtualApplication(moduleName, (ModuleDescriptor<BundleDescriptor>)newModule);
        }
        return application;
    }

    public Application openWith(Application application, ReadableArchive archive, Archivist archivist) throws IOException, SAXParseException {
        archivist.openWith(application, archive);
        if (application.isVirtual()) {
            application.setClassLoader(archivist.getClassLoader());
            application.visit(new ApplicationValidator());
        }
        return application;
    }

    public Application openArchive(URI jarFile, String archiveType, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        Archivist archivist = this.archivistFactory.getArchivist(archiveType);
        return this.openArchive(archivist, jarFile, handleRuntimeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApplicationName(File jarFile) throws IOException {
        block8: {
            if (!jarFile.exists()) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionjarfiledoesn'texist", "{0} does not exist", new Object[]{jarFile}));
            }
            try (JarFile jar = null;){
                jar = new JarFile(jarFile);
                ApplicationDeploymentDescriptorFile node = new ApplicationDeploymentDescriptorFile();
                node.setXMLValidation(false);
                ZipEntry deploymentEntry = jar.getEntry(node.getDeploymentDescriptorPath());
                if (deploymentEntry == null) break block8;
                try {
                    Application application = (Application)node.read(jar.getInputStream(deploymentEntry));
                    String string = application.getDisplayName();
                    return string;
                }
                catch (Exception pe) {
                    logger.log(Level.WARNING, "Error occurred", pe);
                }
            }
        }
        return null;
    }
}

