/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.connectors.PoolMetaData;
import java.io.Serializable;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class ResourceSpec
implements Serializable {
    private String resourceId;
    private int resourceIdType;
    private boolean pmResource;
    private boolean nonTxResource;
    private boolean isXA_;
    private boolean lazyEnlistable_;
    private boolean lazyAssociatable_;
    private Object connectionToAssoc_;
    private PoolInfo poolInfo;
    public static final int JDBC_URL = 0;
    public static final int JNDI_NAME = 1;
    public static final int JMS = 2;

    public ResourceSpec(String resourceId, int resourceIdType) {
        if (resourceId == null) {
            throw new NullPointerException();
        }
        this.resourceId = resourceId;
        this.resourceIdType = resourceIdType;
        if (resourceId.endsWith("__nontx")) {
            this.nonTxResource = true;
        }
        if (resourceId.endsWith("__pm")) {
            this.pmResource = true;
        }
    }

    public ResourceSpec(String resourceId, int resourceIdType, PoolMetaData pmd) {
        this(resourceId, resourceIdType);
        if (pmd.isPM()) {
            this.pmResource = true;
        }
        if (pmd.isNonTx()) {
            this.nonTxResource = true;
        }
        if (pmd.isLazyEnlistable() && !this.nonTxResource && !this.pmResource) {
            this.lazyEnlistable_ = true;
        }
        if (pmd.isLazyAssociatable() && !this.nonTxResource && !this.pmResource) {
            this.lazyAssociatable_ = true;
            this.lazyEnlistable_ = false;
        }
    }

    public PoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    public void setPoolInfo(PoolInfo poolInfo) {
        this.poolInfo = poolInfo;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ResourceSpec) {
            ResourceSpec obj = (ResourceSpec)other;
            if (this.poolInfo == null) {
                return this.resourceId.equals(obj.resourceId) && this.resourceIdType == obj.resourceIdType;
            }
            return this.poolInfo.equals((Object)obj.poolInfo);
        }
        return false;
    }

    public int hashCode() {
        if (this.poolInfo == null) {
            return this.resourceId.hashCode() + this.resourceIdType;
        }
        return this.poolInfo.hashCode();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public boolean isPM() {
        return this.pmResource;
    }

    public boolean isNonTx() {
        return this.nonTxResource;
    }

    public boolean isXA() {
        return this.isXA_;
    }

    public void markAsXA() {
        this.isXA_ = true;
    }

    public boolean isLazyEnlistable() {
        return this.lazyEnlistable_;
    }

    public void setLazyEnlistable(boolean lazyEnlist) {
        this.lazyEnlistable_ = lazyEnlist;
    }

    public boolean isLazyAssociatable() {
        return this.lazyAssociatable_;
    }

    public void setLazyAssociatable(boolean lazyAssoc) {
        this.lazyAssociatable_ = lazyAssoc;
    }

    public void setConnectionToAssociate(Object conn) {
        this.connectionToAssoc_ = conn;
    }

    public Object getConnectionToAssociate() {
        return this.connectionToAssoc_;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResourceSpec :- ");
        sb.append("\nconnectionPoolName : ").append(this.poolInfo);
        sb.append("\nisXA_ : ").append(this.isXA_);
        sb.append("\nresoureId : ").append(this.resourceId);
        sb.append("\nresoureIdType : ").append(this.resourceIdType);
        sb.append("\npmResource : ").append(this.pmResource);
        sb.append("\nnonTxResource : ").append(this.nonTxResource);
        sb.append("\nlazyEnlistable : ").append(this.lazyEnlistable_);
        sb.append("\nlazyAssociatable : ").append(this.lazyAssociatable_);
        return sb.toString();
    }
}

