/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.opentracing;

import fish.payara.ejb.opentracing.OpenTracingIiopObjectInputStream;
import fish.payara.ejb.opentracing.OpenTracingIiopTextMap;
import fish.payara.opentracing.OpenTracingScope;
import fish.payara.opentracing.OpenTracingService;
import fish.payara.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class OpenTracingIiopServerInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private OpenTracingService openTracingService;
    private Tracer tracer;

    public OpenTracingIiopServerInterceptor(OpenTracingService openTracingService) {
        this.openTracingService = openTracingService;
        if (openTracingService.isEnabled()) {
            this.tracer = openTracingService.getTracer("__PAYARA_CORBA_RMI");
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        if (!this.tracerAvailable()) {
            return;
        }
        ServiceContext serviceContext = serverRequestInfo.get_request_service_context(3226428);
        if (serviceContext == null) {
            return;
        }
        OpenTracingIiopTextMap openTracingIiopTextMap = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(serviceContext.context_data);
             OpenTracingIiopObjectInputStream in = new OpenTracingIiopObjectInputStream(bis);){
            openTracingIiopTextMap = (OpenTracingIiopTextMap)in.readObject();
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new ForwardRequest(exception.getMessage(), (Object)serverRequestInfo);
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan("rmi").withTag(Tags.COMPONENT.getKey(), "ejb");
        if (openTracingIiopTextMap != null) {
            SpanContext spanContext = this.tracer.extract(Format.Builtin.TEXT_MAP, (java.lang.Object)openTracingIiopTextMap);
            spanBuilder.asChildOf(spanContext);
        }
        this.tracer.activateSpan(spanBuilder.start());
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        this.closeScope();
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.closeScope();
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.closeScope();
    }

    private void closeScope() {
        if (!this.tracerAvailable()) {
            return;
        }
        Span activeSpan = this.tracer.scopeManager().activeSpan();
        if (activeSpan != null) {
            activeSpan.finish();
        }
        if (this.tracer.scopeManager() instanceof ScopeManager) {
            ScopeManager manager = (ScopeManager)this.tracer.scopeManager();
            OpenTracingScope activeScope = manager.activeScope();
            Throwable throwable = null;
            if (activeScope != null) {
                if (throwable != null) {
                    try {
                        activeScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    activeScope.close();
                }
            }
        }
    }

    private boolean tracerAvailable() {
        if (this.tracer == null) {
            if (!this.openTracingService.isEnabled()) {
                return false;
            }
            this.tracer = this.openTracingService.getTracer("__PAYARA_CORBA_RMI");
            if (this.tracer == null) {
                return false;
            }
        }
        return true;
    }

    public String name() {
        return ((java.lang.Object)((java.lang.Object)this)).getClass().getSimpleName();
    }

    public void destroy() {
    }
}

