/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;

@Taxonomy(stability=Stability.UNCOMMITTED)
public final class PathnameParser {
    private final char mDelim;
    private final char mNameLeft;
    private final char mNameRight;
    private final String mPath;
    private final List<PathPart> mParts;
    private final boolean mIsFullPath;
    private static final Pattern TYPE_SEARCH_PATTERN = Pattern.compile("([**$a-zA-Z0-9._-][**$a-zA-Z0-9._-]*).*");
    private static final Pattern LEGAL_TYPE_PATTERN_COMPILED = Pattern.compile("([**$a-zA-Z0-9._-][**$a-zA-Z0-9._-]*)");
    private static final Pattern LEGAL_NAME_PATTERN_COMPILED = Pattern.compile("[^]]*");

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.mPath).append(" as ").append(this.mParts.size()).append(" parts: ");
        buf.append("{");
        String delim = ", ";
        for (PathPart part : this.mParts) {
            buf.append(part.toString());
            buf.append(", ");
        }
        if (!this.mParts.isEmpty()) {
            buf.setLength(buf.length() - ", ".length());
        }
        buf.append("}");
        return buf.toString();
    }

    public PathnameParser(String path) {
        this(path, '/', '[', ']');
    }

    public PathnameParser(String path, char delim, char nameLeft, char nameRight) {
        this.mPath = path;
        this.mDelim = delim;
        this.mNameLeft = nameLeft;
        this.mNameRight = nameRight;
        this.mParts = this.parse();
        this.mIsFullPath = path.startsWith("/");
    }

    public boolean isFullPath() {
        return this.mIsFullPath;
    }

    public boolean isRoot() {
        return this.mParts.isEmpty();
    }

    public boolean isWild() {
        for (PathPart part : this.mParts) {
            if (!part.isWildType() && !part.isWildName()) continue;
            return true;
        }
        return false;
    }

    public List<PathPart> parts() {
        return this.mParts;
    }

    public String type() {
        return this.mParts.get(this.mParts.size() - 1).type();
    }

    public String name() {
        return this.mParts.get(this.mParts.size() - 1).name();
    }

    public String parentPath() {
        if (this.mParts.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.mParts.size() - 1; ++i) {
            PathPart part = this.mParts.get(i);
            buf.append(part.toString());
            if (i >= this.mParts.size() - 2) continue;
            buf.append('/');
        }
        return "/" + buf.toString();
    }

    private static boolean isValidType(String type) {
        Matcher matcher = LEGAL_TYPE_PATTERN_COMPILED.matcher(type);
        return matcher.matches();
    }

    private static boolean isValidName(String type) {
        Matcher matcher = LEGAL_NAME_PATTERN_COMPILED.matcher(type);
        return matcher.matches();
    }

    private void parse(String path, List<PathPart> parts) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException(path);
        }
        String remaining = path;
        if (remaining.startsWith("/")) {
            remaining = remaining.substring("/".length());
        }
        Pattern typePattern = TYPE_SEARCH_PATTERN;
        while (remaining.length() != 0) {
            Matcher matcher = typePattern.matcher(remaining);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("No match: " + remaining);
            }
            String type = matcher.group(1);
            if (type.length() >= remaining.length()) {
                PathPart part = new PathPart(type, null);
                parts.add(part);
                break;
            }
            char matchChar = remaining.charAt(type.length());
            remaining = remaining.substring(type.length() + 1);
            String name = null;
            if (matchChar == this.mNameLeft) {
                int idx = remaining.indexOf(this.mNameRight);
                if (idx < 0) {
                    throw new IllegalArgumentException(path);
                }
                name = remaining.substring(0, idx);
                if ((remaining = remaining.substring(idx + 1)).length() != 0 && remaining.charAt(0) == this.mDelim) {
                    remaining = remaining.substring(1);
                }
            }
            PathPart part = new PathPart(type, name);
            parts.add(part);
        }
    }

    private List<PathPart> parse() {
        ArrayList<PathPart> parts = new ArrayList<PathPart>();
        this.parse(this.mPath, parts);
        return parts;
    }

    private static void checkName(String name) {
        if (name != null && !PathnameParser.isValidName(name)) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
    }

    private static void checkType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Illegal type: null");
        }
        if (type.indexOf(91) >= 0 || type.indexOf(93) >= 0) {
            throw new IllegalArgumentException("Illegal type: " + type);
        }
        if (!PathnameParser.isValidType(type)) {
            throw new IllegalArgumentException("Illegal type: " + type);
        }
    }

    public static String pathPart(String type, String name) {
        PathnameParser.checkName(name);
        String namePart = name == null ? "" : '[' + name + ']';
        return PathnameParser.pathPart(type) + namePart;
    }

    public static String pathPart(String type) {
        PathnameParser.checkType(type);
        return type;
    }

    public static String path(String parentPath, String type, String name) {
        if (parentPath != null && parentPath.length() == 0 && !type.equals(Util.deduceType(DomainRoot.class))) {
            throw new IllegalArgumentException("parent path cannot be the empty string");
        }
        String path = parentPath == null || parentPath.equals("/") ? "/" : parentPath + '/';
        path = path + PathnameParser.pathPart(type, name);
        new PathnameParser(path);
        return path;
    }

    public static String parentPath(ObjectName objectName) {
        return Util.unquoteIfNeeded(objectName.getKeyProperty("pp"));
    }

    public static final class PathPart {
        private final String mType;
        private final String mName;

        public PathPart(String type, String name) {
            this.mType = type;
            this.mName = name;
        }

        public String type() {
            return this.mType;
        }

        public String name() {
            return this.mName;
        }

        public boolean isWildType() {
            return this.mType.indexOf(42) >= 0;
        }

        public boolean isWildName() {
            return this.mName != null && this.mName.indexOf(42) >= 0;
        }

        public String toString() {
            return PathnameParser.pathPart(this.mType, this.mName);
        }
    }
}

