/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.microprofile.restclient.ReflectionUtil;

class RestClientProducer
implements Bean<Object>,
PassivationCapable {
    private static final String CONFIG_URL = "/mp-rest/url";
    private static final String CONFIG_URI = "/mp-rest/uri";
    private static final String CONFIG_SCOPE = "/mp-rest/scope";
    private static final String CONFIG_CONNECTION_TIMEOUT = "/mp-rest/connectTimeout";
    private static final String CONFIG_READ_TIMEOUT = "/mp-rest/readTimeout";
    private static final String CONFIG_SSL_TRUST_STORE_LOCATION = "/mp-rest/trustStore";
    private static final String CONFIG_SSL_TRUST_STORE_TYPE = "/mp-rest/trustStoreType";
    private static final String CONFIG_SSL_TRUST_STORE_PASSWORD = "/mp-rest/trustStorePassword";
    private static final String CONFIG_SSL_KEY_STORE_LOCATION = "/mp-rest/keyStore";
    private static final String CONFIG_SSL_KEY_STORE_TYPE = "/mp-rest/keyStoreType";
    private static final String CONFIG_SSL_KEY_STORE_PASSWORD = "/mp-rest/keyStorePassword";
    private static final String CONFIG_SSL_HOSTNAME_VERIFIER = "/mp-rest/hostnameVerifier";
    private static final String CONFIG_PROVIDERS = "/mp-rest/providers";
    private static final String CONFIG_FOLLOW_REDIRECTS = "/mp-rest/followRedirects";
    private static final String CONFIG_QUERY_PARAM_STYLE = "/mp-rest/queryParamStyle";
    private static final String CONFIG_PROXY_ADDRESS = "/mp-rest/proxyAddress";
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final String CLASSPATH_LOCATION = "classpath:";
    private static final String FILE_LOCATION = "file:";
    private final Class<?> interfaceType;
    private final Config config;
    private final String fqcn;
    private final Optional<RegisterRestClient> restClientAnnotation;
    private final Optional<String> configKey;
    private final Class<? extends Annotation> scope;

    RestClientProducer(Class<?> interfaceType, BeanManager beanManager) {
        this.interfaceType = interfaceType;
        this.config = ConfigProvider.getConfig();
        this.fqcn = interfaceType.getName();
        this.restClientAnnotation = Optional.ofNullable(interfaceType.getAnnotation(RegisterRestClient.class));
        this.configKey = this.restClientAnnotation.map(RegisterRestClient::configKey);
        this.scope = RestClientProducer.resolveClientScope(interfaceType, beanManager, this.config, this.fqcn, this.configKey);
    }

    public Class<?> getBeanClass() {
        return this.interfaceType;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        RestClientBuilder restClientBuilder = RestClientBuilder.newBuilder().baseUrl(this.getBaseUrl());
        this.getConfigOption(Long.class, CONFIG_CONNECTION_TIMEOUT).ifPresent(aLong -> restClientBuilder.connectTimeout(aLong.longValue(), TimeUnit.MILLISECONDS));
        this.getConfigOption(Long.class, CONFIG_READ_TIMEOUT).ifPresent(aLong -> restClientBuilder.readTimeout(aLong.longValue(), TimeUnit.MILLISECONDS));
        this.getConfigOption(Boolean.class, CONFIG_FOLLOW_REDIRECTS).ifPresent(arg_0 -> ((RestClientBuilder)restClientBuilder).followRedirects(arg_0));
        this.getConfigOption(String.class, CONFIG_QUERY_PARAM_STYLE).ifPresent(value -> restClientBuilder.queryParamStyle(QueryParamStyle.valueOf((String)value)));
        this.getConfigOption(String.class, CONFIG_PROXY_ADDRESS).ifPresent(proxy -> {
            int proxyPort;
            int index = proxy.lastIndexOf(58);
            if (index < 0 || proxy.length() - 1 == index) {
                throw new IllegalArgumentException("Invalid proxy URI: " + proxy);
            }
            String proxyHost = proxy.substring(0, index);
            String proxyPortStr = proxy.substring(index + 1);
            try {
                proxyPort = Integer.parseInt(proxyPortStr);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid proxy port: " + proxyPortStr, nfe);
            }
            restClientBuilder.proxyAddress(proxyHost, proxyPort);
        });
        this.addConfiguredProviders(restClientBuilder);
        this.getHostnameVerifier().ifPresent(arg_0 -> ((RestClientBuilder)restClientBuilder).hostnameVerifier(arg_0));
        this.getKeyStore(CONFIG_SSL_KEY_STORE_LOCATION, CONFIG_SSL_KEY_STORE_TYPE, CONFIG_SSL_KEY_STORE_PASSWORD).ifPresent(keyStore -> restClientBuilder.keyStore(((KeyStoreConfig)keyStore).keyStore, ((KeyStoreConfig)keyStore).password));
        this.getKeyStore(CONFIG_SSL_TRUST_STORE_LOCATION, CONFIG_SSL_TRUST_STORE_TYPE, CONFIG_SSL_TRUST_STORE_PASSWORD).ifPresent(keystore -> restClientBuilder.trustStore(((KeyStoreConfig)keystore).keyStore));
        return restClientBuilder.build(this.interfaceType);
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.interfaceType);
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        annotations.add((Annotation)new AnnotationLiteral<Default>(){});
        annotations.add((Annotation)new AnnotationLiteral<Any>(){});
        annotations.add((Annotation)RestClient.LITERAL);
        return annotations;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.interfaceType.getName() + "RestClient";
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String toString() {
        return "RestClientProducer [ interfaceType: " + this.interfaceType.getSimpleName() + " ] with Qualifiers [" + this.getQualifiers() + "]";
    }

    public String getId() {
        return this.interfaceType.getName();
    }

    private void addConfiguredProviders(RestClientBuilder restClientBuilder) {
        String[] classNames;
        Optional<String[]> configOption = this.getConfigOption(String[].class, CONFIG_PROVIDERS);
        if (!configOption.isPresent()) {
            return;
        }
        for (String className : classNames = configOption.get()) {
            Class providerClass = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)className));
            Optional<Integer> priority = this.getConfigOption(Integer.class, "/mp-rest/providers/" + className + "/priority");
            if (priority.isPresent()) {
                restClientBuilder.register(providerClass, priority.get().intValue());
                continue;
            }
            restClientBuilder.register(providerClass);
        }
    }

    private URL getBaseUrl() {
        Supplier<String> baseUrlDefault = () -> {
            throw new DeploymentException("This interface has to be annotated with @RegisterRestClient annotation.");
        };
        String baseUrl = RestClientProducer.getOption(this.config, this.fqcn, this.configKey, this.restClientAnnotation.map(RegisterRestClient::baseUri), baseUrlDefault, String.class, CONFIG_URI, CONFIG_URL);
        try {
            return new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("URL is not in valid format for Rest interface " + this.interfaceType.getName() + ": " + baseUrl, e);
        }
    }

    private <T> Optional<T> getConfigOption(Class<T> optionType, String propertySuffix) {
        return Optional.ofNullable(RestClientProducer.getOption(this.config, this.fqcn, this.configKey, Optional.empty(), () -> null, optionType, propertySuffix));
    }

    private static <T> T getOption(Config config, String fqcn, Optional<String> configKey, Optional<T> valueFromAnnotation, Supplier<T> defaultValue, Class<T> propertyType, String ... propertySuffixes) {
        String theKey;
        for (String propertySuffix : propertySuffixes) {
            Optional value = config.getOptionalValue(fqcn + propertySuffix, propertyType);
            if (!value.isPresent()) continue;
            return value.get();
        }
        if (configKey.isPresent() && !(theKey = configKey.get()).isEmpty()) {
            for (String propertySuffix : propertySuffixes) {
                Optional value = config.getOptionalValue(theKey + propertySuffix, propertyType);
                if (!value.isPresent()) continue;
                return value.get();
            }
        }
        return valueFromAnnotation.orElseGet(defaultValue);
    }

    private Optional<KeyStoreConfig> getKeyStore(String configLocation, String configType, String configPassword) {
        KeyStore keyStore;
        String keyStoreLocation = this.getConfigOption(String.class, configLocation).orElse(null);
        if (keyStoreLocation == null) {
            return Optional.empty();
        }
        String keyStoreType = this.getConfigOption(String.class, configType).orElse(DEFAULT_KEYSTORE_TYPE);
        String password = this.getConfigOption(String.class, configPassword).orElse(null);
        try {
            keyStore = KeyStore.getInstance(keyStoreType);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Failed to create keystore of type: " + keyStoreType + " for " + this.interfaceType, e);
        }
        try (InputStream storeStream = this.locationToStream(keyStoreLocation);){
            keyStore.load(storeStream, password.toCharArray());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException("Failed to load keystore from " + keyStoreLocation, e);
        }
        return Optional.of(new KeyStoreConfig(keyStore, password));
    }

    private InputStream locationToStream(String location) throws IOException {
        if (location.startsWith(CLASSPATH_LOCATION)) {
            String resource = location.substring(CLASSPATH_LOCATION.length());
            InputStream result = this.interfaceType.getResourceAsStream(resource);
            if (null == result && (result = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource)) == null && resource.startsWith("/")) {
                result = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource.substring(1));
            }
            return result;
        }
        if (location.startsWith(FILE_LOCATION)) {
            return Files.newInputStream(Paths.get(URI.create(location)), new OpenOption[0]);
        }
        throw new IllegalStateException("Location of keystore must start with either classpath: or file:, but is: " + location + " for " + this.interfaceType);
    }

    private Optional<HostnameVerifier> getHostnameVerifier() {
        Optional<String> verifier = this.getConfigOption(String.class, CONFIG_SSL_HOSTNAME_VERIFIER);
        return verifier.map(className -> {
            Class theClass = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)className));
            if (theClass == null) {
                throw new IllegalStateException("Invalid hostname verifier class: " + className);
            }
            return (HostnameVerifier)ReflectionUtil.createInstance(theClass);
        });
    }

    private static Class<? extends Annotation> resolveClientScope(Class<?> interfaceType, BeanManager beanManager, Config config, String fqcn, Optional<String> configKey) {
        String configuredScope = RestClientProducer.getOption(config, fqcn, configKey, Optional.empty(), () -> null, String.class, CONFIG_SCOPE);
        if (configuredScope != null) {
            Class scope = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)configuredScope));
            if (scope == null) {
                throw new IllegalStateException("Invalid scope from config: " + configuredScope);
            }
            return scope;
        }
        List possibleScopes = Arrays.stream(interfaceType.getDeclaredAnnotations()).filter(annotation -> beanManager.isScope(annotation.annotationType())).collect(Collectors.toList());
        if (possibleScopes.size() == 1) {
            return ((Annotation)possibleScopes.get(0)).annotationType();
        }
        if (possibleScopes.isEmpty()) {
            return Dependent.class;
        }
        throw new IllegalArgumentException("Client should have only one scope defined: " + interfaceType + " has " + possibleScopes);
    }

    private static final class KeyStoreConfig {
        private final KeyStore keyStore;
        private final String password;

        private KeyStoreConfig(KeyStore keyStore, String password) {
            this.keyStore = keyStore;
            this.password = password;
        }
    }
}

