/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class Series
implements Comparable<Series>,
Serializable {
    private static final char VALUE_WILDCARD = '*';
    private static final char NAME_WILDCARD = '?';
    public static final char TAG_ASSIGN = ':';
    public static final char TAG_SEPARATOR = ' ';
    private static final char[] TAG_SEPARATORS = new char[]{' ', ',', ';'};
    private static final String SPLIT_PATTERN = "[" + Pattern.quote(new String(TAG_SEPARATORS)) + "]+";
    public static final Series ANY = new Series("*");
    private final String metric;
    private final String[] tags;
    private final String[] values;

    public Series(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Series key cannot be null or empty!");
        }
        String[] parts = key.split(SPLIT_PATTERN);
        this.tags = new String[parts.length - 1];
        this.values = new String[this.tags.length];
        this.metric = parts[parts.length - 1].intern();
        for (int i = 0; i < parts.length - 1; ++i) {
            int eqIndex = parts[i].indexOf(58);
            if (eqIndex <= 0) {
                throw new IllegalArgumentException("Malformed series key, `:` missing or misplaced in " + key);
            }
            this.tags[i] = parts[i].substring(0, eqIndex).intern();
            this.values[i] = parts[i].substring(eqIndex + 1).intern();
        }
    }

    public String getMetric() {
        return this.metric;
    }

    public int tagCount() {
        return this.tags.length;
    }

    public String key(int index) {
        return this.tags[index];
    }

    public String value(int index) {
        return this.values[index];
    }

    public boolean isPattern() {
        if (Series.isWildCardValue(this.metric)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!Series.isWildCardValue(this.values[i]) && !Series.isWildCardName(this.tags[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isWildCardValue(String str) {
        return str.length() == 1 && str.charAt(0) == '*';
    }

    private static boolean isWildCardName(String str) {
        return str.length() == 1 && str.charAt(0) == '?';
    }

    public boolean matches(Series other) {
        if (!Series.isWildCardValue(this.metric) && !this.metric.equals(other.metric) || other.tags.length < this.tags.length - 1) {
            return false;
        }
        for (int i = 0; i < this.tags.length - 1; ++i) {
            if (this.tags[i].equals(other.tags[i]) && (Series.isWildCardValue(this.values[i]) || this.values[i].equals(other.values[i]))) continue;
            return false;
        }
        if (this.tags.length == 0) {
            return other.tags.length == 0;
        }
        int n = this.tags.length - 1;
        if (Series.isWildCardName(this.tags[n])) {
            return other.tags.length <= n || Series.isWildCardValue(this.values[n]) || this.values[n].equals(other.values[n]);
        }
        return this.tags.length == other.tags.length && this.tags[n].equals(other.tags[n]) && (Series.isWildCardValue(this.values[n]) || this.values[n].equals(other.values[n]));
    }

    public boolean equals(Object obj) {
        return obj instanceof Series && this.compareTo((Series)obj) == 0;
    }

    public int hashCode() {
        return this.metric.hashCode() ^ Arrays.hashCode(this.values);
    }

    public boolean equalTo(Series other) {
        return this.metric.equals(other.metric) && Arrays.equals(this.tags, other.tags) && Arrays.equals(this.values, other.values);
    }

    @Override
    public int compareTo(Series other) {
        int res = this.metric.compareTo(other.metric);
        if (res != 0) {
            return res;
        }
        res = Integer.compare(this.tags.length, other.tags.length);
        if (res != 0) {
            return res;
        }
        for (int i = 0; i < this.tags.length; ++i) {
            int tagIndex = other.indexOf(this.tags[i]);
            if (tagIndex < 0) {
                return -1;
            }
            res = this.values[i].compareTo(other.values[tagIndex]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    private int indexOf(String tag) {
        for (int i = 0; i < this.tags.length; ++i) {
            if (!this.tags[i].equals(tag)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.tags.length; ++i) {
            str.append(this.tags[i]).append(':').append(this.values[i]).append(' ');
        }
        str.append(this.metric);
        return str.toString();
    }

    public static boolean isSpecialTagCharacter(char c) {
        if (c == ':' || c == '*' || c == '?') {
            return true;
        }
        for (char sep : TAG_SEPARATORS) {
            if (sep != c) continue;
            return true;
        }
        return false;
    }
}

