/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechList;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechListHelper;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.ServiceConfiguration;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import com.sun.corba.ee.org.omg.CSIIOP.TransportAddress;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.Lookups;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.impl.CSIv2Policy;
import org.glassfish.pfl.basic.func.UnaryFunction;
import org.ietf.jgss.GSSException;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.PortableInterceptor.IORInfo;

public final class CSIV2TaggedComponentInfo {
    public static final int SUPPORTED_IDENTITY_TOKEN_TYPES = 15;
    private static final String DEFAULT_REALM = "default";
    private static final Logger logger = LogDomains.getLogger(CSIV2TaggedComponentInfo.class, (String)"javax.enterprise.system.core.security");
    private static final org.omg.IOP.TaggedComponent NULL_TAGGED_COMPONENT;
    private ORB orb;
    private int sslMutualAuthPort;
    private GlassFishORBHelper orbHelper;

    public CSIV2TaggedComponentInfo(ORB orb) {
        this.orb = orb;
        this.orbHelper = Lookups.getGlassFishORBHelper();
    }

    public CSIV2TaggedComponentInfo(ORB orb, int sslMutualAuthPort) {
        this(orb);
        this.sslMutualAuthPort = sslMutualAuthPort;
    }

    public EjbDescriptor getEjbDescriptor(IORInfo iorInfo) {
        CSIv2Policy csiv2Policy = null;
        try {
            csiv2Policy = (CSIv2Policy)iorInfo.get_effective_policy(this.orbHelper.getCSIv2PolicyType());
        }
        catch (INV_POLICY ex) {
            logger.log(Level.FINE, "CSIV2TaggedComponentInfo.getEjbDescriptor: CSIv2Policy not present");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "TxSecIORInterceptor.establish_components: CSIv2Policy: " + csiv2Policy);
        }
        EjbDescriptor ejbDesc = null;
        if (csiv2Policy != null) {
            ejbDesc = csiv2Policy.getEjbDescriptor();
        }
        return ejbDesc;
    }

    public org.omg.IOP.TaggedComponent createSecurityTaggedComponent(int sslPort, EjbDescriptor ejbDescriptor) {
        org.omg.IOP.TaggedComponent securityTaggedComponent = null;
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "IIOP: Creating a Security Tagged Component");
            }
            securityTaggedComponent = this.createCompoundSecMechListComponent(this.createCompoundSecMechs(sslPort, ejbDescriptor));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "iiop.createcompund_exception", e);
        }
        return securityTaggedComponent;
    }

    public org.omg.IOP.TaggedComponent createSecurityTaggedComponent(List<SocketInfo> socketInfos, EjbDescriptor ejbDescriptor) {
        org.omg.IOP.TaggedComponent securityTaggedComponent = null;
        if (ejbDescriptor != null) {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "IIOP: Creating a Security Tagged Component");
                }
                securityTaggedComponent = this.createCompoundSecMechListComponent(this.createCompoundSecMechs(socketInfos, ejbDescriptor));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "iiop.createcompund_exception", e);
            }
        }
        return securityTaggedComponent;
    }

    private boolean getBooleanValue(Properties props, String name) {
        return props.getProperty(name, "false").equals("true");
    }

    public org.omg.IOP.TaggedComponent createSecurityTaggedComponent(int sslPort) {
        org.omg.IOP.TaggedComponent securityTaggedComponent = null;
        try {
            Properties props = this.orbHelper.getCSIv2Props();
            boolean sslRequired = this.getBooleanValue(props, "com.sun.CSIV2.ssl.server.required");
            boolean clientAuthRequired = this.getBooleanValue(props, "com.sun.CSIV2.client.auth.required");
            CompoundSecMech[] mechList = new CompoundSecMech[1];
            org.omg.IOP.TaggedComponent transportMech = this.createSSLInfo(sslPort, null, sslRequired);
            AS_ContextSec asContext = this.createASContextSec(null, DEFAULT_REALM);
            SAS_ContextSec sasContext = this.createSASContextSec(null);
            short targetRequires = clientAuthRequired ? (short)64 : 0;
            mechList[0] = new CompoundSecMech(targetRequires, transportMech, asContext, sasContext);
            securityTaggedComponent = this.createCompoundSecMechListComponent(mechList);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "iiop.createcompund_exception", e);
        }
        return securityTaggedComponent;
    }

    private org.omg.IOP.TaggedComponent createCompoundSecMechListComponent(CompoundSecMech[] mechList) {
        CDROutputObject out = (CDROutputObject)this.orb.create_output_stream();
        out.putEndian();
        boolean stateful = false;
        CompoundSecMechListHelper.write((OutputStream)out, (CompoundSecMechList)new CompoundSecMechList(stateful, mechList));
        return new org.omg.IOP.TaggedComponent(33, out.toByteArray());
    }

    private Set<EjbIORConfigurationDescriptor> getIORConfigurationDescriptors(EjbDescriptor ejbDescriptor) {
        if (ejbDescriptor == null) {
            return null;
        }
        Set iorDescriptors = ejbDescriptor.getIORConfigurationDescriptors();
        int size = iorDescriptors.size();
        if (size == 0) {
            EjbIORConfigurationDescriptor iorDescriptor = new EjbIORConfigurationDescriptor();
            iorDescriptor.setIntegrity("SUPPORTED");
            iorDescriptor.setConfidentiality("SUPPORTED");
            iorDescriptor.setEstablishTrustInClient("SUPPORTED");
            iorDescriptors.add(iorDescriptor);
            Set permissions = ejbDescriptor.getPermissionedRoles();
            if (permissions.size() > 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "IIOP:Application has protected methods");
                }
                iorDescriptor.setAuthMethodRequired(true);
                String realmName = DEFAULT_REALM;
                if (ejbDescriptor.getApplication() != null) {
                    realmName = ejbDescriptor.getApplication().getRealm();
                }
                if (realmName == null) {
                    realmName = DEFAULT_REALM;
                }
                iorDescriptor.setRealmName(realmName);
                for (MethodPermission methodPermission : ejbDescriptor.getMethodPermissionsFromDD().keySet()) {
                    if (!methodPermission.isUnchecked()) continue;
                    EjbIORConfigurationDescriptor uncheckedDescriptor = new EjbIORConfigurationDescriptor();
                    uncheckedDescriptor.setIntegrity("SUPPORTED");
                    uncheckedDescriptor.setConfidentiality("SUPPORTED");
                    uncheckedDescriptor.setEstablishTrustInClient("SUPPORTED");
                    uncheckedDescriptor.setRealmName(realmName);
                    iorDescriptors.add(uncheckedDescriptor);
                    break;
                }
            }
        }
        return iorDescriptors;
    }

    private CompoundSecMech[] createCompoundSecMechs(DescriptorMaker maker, EjbDescriptor ejbDescriptor) throws GSSException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "IIOP: Creating CompoundSecMech");
        }
        if (ejbDescriptor == null) {
            return null;
        }
        Set<EjbIORConfigurationDescriptor> iorDescriptors = this.getIORConfigurationDescriptors(ejbDescriptor);
        CompoundSecMech[] mechList = new CompoundSecMech[iorDescriptors.size()];
        Iterator<EjbIORConfigurationDescriptor> itr = iorDescriptors.iterator();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "IORDescSet SIZE:" + iorDescriptors.size());
        }
        String realmName = DEFAULT_REALM;
        for (int i = 0; i < iorDescriptors.size(); ++i) {
            EjbIORConfigurationDescriptor iorDescriptor = itr.next();
            int targetRequires = this.getTargetRequires(iorDescriptor);
            org.omg.IOP.TaggedComponent comp = (org.omg.IOP.TaggedComponent)maker.evaluate(iorDescriptor);
            if (ejbDescriptor.getApplication() != null) {
                realmName = ejbDescriptor.getApplication().getRealm();
            }
            if (realmName == null) {
                realmName = iorDescriptor.getRealmName();
            }
            if (realmName == null) {
                realmName = DEFAULT_REALM;
            }
            AS_ContextSec asContext = this.createASContextSec(iorDescriptor, realmName);
            SAS_ContextSec sasContext = this.createSASContextSec(iorDescriptor);
            int targ_req = targetRequires | asContext.target_requires | sasContext.target_requires;
            mechList[i] = new CompoundSecMech((short)targ_req, comp, asContext, sasContext);
        }
        return mechList;
    }

    private CompoundSecMech[] createCompoundSecMechs(final List<SocketInfo> socketInfos, EjbDescriptor ejbDescriptor) throws GSSException {
        DescriptorMaker maker = new DescriptorMaker(){

            public org.omg.IOP.TaggedComponent evaluate(EjbIORConfigurationDescriptor iorDescriptor) {
                return CSIV2TaggedComponentInfo.this.createSSLInfo(socketInfos, iorDescriptor, false);
            }
        };
        return this.createCompoundSecMechs(maker, ejbDescriptor);
    }

    private CompoundSecMech[] createCompoundSecMechs(final int sslPort, EjbDescriptor ejbDescriptor) throws GSSException {
        DescriptorMaker maker = new DescriptorMaker(){

            public org.omg.IOP.TaggedComponent evaluate(EjbIORConfigurationDescriptor iorDescriptor) {
                return CSIV2TaggedComponentInfo.this.createSSLInfo(sslPort, iorDescriptor, false);
            }
        };
        return this.createCompoundSecMechs(maker, ejbDescriptor);
    }

    public AS_ContextSec createASContextSec(EjbIORConfigurationDescriptor iorDescriptor, String realmName) throws GSSException {
        int targetSupports = 0;
        int targetRequires = 0;
        byte[] clientAuthenticationMmechanism = new byte[]{};
        byte[] targetNname = new byte[]{};
        String authMethod = null;
        boolean authMethodRequired = false;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "IIOP: Creating AS_Context");
        }
        if (iorDescriptor != null) {
            authMethod = iorDescriptor.getAuthenticationMethod();
            authMethodRequired = iorDescriptor.isAuthMethodRequired();
        }
        if (authMethod != null && authMethod.equalsIgnoreCase("NONE")) {
            return new AS_ContextSec((short)targetSupports, (short)targetRequires, clientAuthenticationMmechanism, targetNname);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "IIOP:AS_Context: Realm Name for login = " + realmName);
        }
        if (realmName == null) {
            realmName = iorDescriptor.getRealmName();
        }
        if (realmName == null) {
            realmName = DEFAULT_REALM;
        }
        targetNname = GSSUtils.createExportedName(GSSUtils.GSSUP_MECH_OID, realmName.getBytes());
        targetSupports = 64;
        if (authMethodRequired) {
            targetRequires = 64;
        }
        clientAuthenticationMmechanism = GSSUtils.getMechanism();
        return new AS_ContextSec((short)targetSupports, (short)targetRequires, clientAuthenticationMmechanism, targetNname);
    }

    public SAS_ContextSec createSASContextSec(EjbIORConfigurationDescriptor iorDescriptor) throws GSSException {
        int targetSupports = 0;
        boolean targetRequires = false;
        ServiceConfiguration[] privilegeAuthorities = new ServiceConfiguration[]{};
        String callerPropagation = null;
        Object mechanisms = new byte[][]{};
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "IIOP: Creating SAS_Context");
        }
        int supportedIdentityTokenType = 0;
        if (iorDescriptor != null) {
            callerPropagation = iorDescriptor.getCallerPropagation();
        }
        if (callerPropagation != null && callerPropagation.equalsIgnoreCase("NONE")) {
            return new SAS_ContextSec((short)targetSupports, (short)(targetRequires ? 1 : 0), privilegeAuthorities, (byte[][])mechanisms, supportedIdentityTokenType);
        }
        targetSupports = 1024;
        byte[] upm = GSSUtils.getMechanism();
        mechanisms = new byte[1][upm.length];
        for (int i = 0; i < upm.length; ++i) {
            mechanisms[0][i] = upm[i];
        }
        if (targetSupports != 0) {
            supportedIdentityTokenType = 15;
        }
        return new SAS_ContextSec((short)targetSupports, (short)(targetRequires ? 1 : 0), privilegeAuthorities, (byte[][])mechanisms, supportedIdentityTokenType);
    }

    public int getTargetSupports(EjbIORConfigurationDescriptor iorDescriptor) {
        if (iorDescriptor == null) {
            return 0;
        }
        int supports = 0;
        String integrity = iorDescriptor.getIntegrity();
        if (!integrity.equalsIgnoreCase("NONE")) {
            supports |= 2;
        }
        if (!iorDescriptor.getConfidentiality().equalsIgnoreCase("NONE")) {
            supports |= 4;
        }
        if (!iorDescriptor.getEstablishTrustInTarget().equalsIgnoreCase("NONE")) {
            supports |= 0x20;
        }
        if (!iorDescriptor.getEstablishTrustInClient().equalsIgnoreCase("NONE")) {
            supports |= 0x40;
        }
        return supports;
    }

    public int getTargetRequires(EjbIORConfigurationDescriptor iorDescriptor) {
        if (iorDescriptor == null) {
            return 0;
        }
        int requires = 0;
        if (iorDescriptor.getIntegrity().equalsIgnoreCase("REQUIRED")) {
            requires |= 2;
        }
        if (iorDescriptor.getConfidentiality().equalsIgnoreCase("REQUIRED")) {
            requires |= 4;
        }
        if (iorDescriptor.getEstablishTrustInTarget().equalsIgnoreCase("REQUIRED")) {
            requires |= 0x20;
        }
        if (iorDescriptor.getEstablishTrustInClient().equalsIgnoreCase("REQUIRED")) {
            requires |= 0x40;
        }
        return requires;
    }

    private int getTargetSupportsDefault(EjbIORConfigurationDescriptor iorDescriptor) {
        if (iorDescriptor == null) {
            return 102;
        }
        return this.getTargetSupports(iorDescriptor);
    }

    private int getTargetRequiresDefault(EjbIORConfigurationDescriptor iorDescriptor, boolean sslRequired) {
        int targetRequires = 0;
        if (iorDescriptor == null) {
            if (sslRequired) {
                targetRequires = 70;
            }
        } else {
            targetRequires = this.getTargetRequires(iorDescriptor);
        }
        return targetRequires;
    }

    private org.omg.IOP.TaggedComponent createTlsSecTransComponent(int targetSupports, int targetRequires, TransportAddress[] transportAddresses) {
        TLS_SEC_TRANS tls_sec = new TLS_SEC_TRANS((short)targetSupports, (short)targetRequires, transportAddresses);
        CDROutputObject out = (CDROutputObject)this.orb.create_output_stream();
        out.putEndian();
        TLS_SEC_TRANSHelper.write((OutputStream)out, (TLS_SEC_TRANS)tls_sec);
        return new org.omg.IOP.TaggedComponent(36, out.toByteArray());
    }

    private TransportAddress[] generateTransportAddresses(int sslPort) {
        return new TransportAddress[]{new TransportAddress(Utility.getLocalAddress(), Utility.intToShort((int)sslPort))};
    }

    private TransportAddress[] generateTransportAddresses(List<SocketInfo> socketInfos) {
        TransportAddress[] transportAddresses = new TransportAddress[socketInfos.size()];
        for (int i = 0; i < socketInfos.size(); ++i) {
            SocketInfo socketInfo = socketInfos.get(i);
            transportAddresses[i] = new TransportAddress(socketInfo.host(), Utility.intToShort((int)socketInfo.port()));
        }
        return transportAddresses;
    }

    private org.omg.IOP.TaggedComponent createSSLInfo(int initialSslPort, EjbIORConfigurationDescriptor iorDescriptor, boolean sslRequired) {
        int sslPort;
        int targetSupports = this.getTargetSupportsDefault(iorDescriptor);
        int targetRequires = this.getTargetRequiresDefault(iorDescriptor, sslRequired);
        boolean mutualAuthRequired = iorDescriptor != null && (targetRequires & 0x40) == 64;
        int n = sslPort = mutualAuthRequired ? this.sslMutualAuthPort : initialSslPort;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "IIOP: Creating Transport Mechanism for sslport " + sslPort);
        }
        if ((targetSupports | targetRequires) == 0 || sslPort == -1) {
            return NULL_TAGGED_COMPONENT;
        }
        return this.createTlsSecTransComponent(targetSupports, targetRequires, this.generateTransportAddresses(sslPort));
    }

    private org.omg.IOP.TaggedComponent createSSLInfo(List<SocketInfo> socketInfos, EjbIORConfigurationDescriptor iorDescriptor, boolean sslRequired) {
        int targetSupports = this.getTargetSupportsDefault(iorDescriptor);
        int targetRequires = this.getTargetRequiresDefault(iorDescriptor, sslRequired);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "IIOP: Creating Transport Mechanism for socketInfos " + socketInfos);
        }
        if ((targetSupports | targetRequires) == 0) {
            return NULL_TAGGED_COMPONENT;
        }
        return this.createTlsSecTransComponent(targetSupports, targetRequires, this.generateTransportAddresses(socketInfos));
    }

    public boolean allMechanismsRequireSSL(Set iorDescSet) {
        int size = iorDescSet.size();
        if (size == 0) {
            return false;
        }
        Iterator itr = iorDescSet.iterator();
        for (int i = 0; i < size; ++i) {
            EjbIORConfigurationDescriptor iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            int target_requires = this.getTargetRequires(iorDesc);
            if (target_requires != 0) continue;
            return false;
        }
        return true;
    }

    public CompoundSecMech[] getSecurityMechanisms(IOR ior) {
        IIOPProfile prof = ior.getProfile();
        IIOPProfileTemplate ptemp = (IIOPProfileTemplate)prof.getTaggedProfileTemplate();
        Iterator itr = ptemp.iteratorById(33);
        if (!itr.hasNext()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "IIOP:TAG_CSI_SEC_MECH_LIST tagged component not found");
            }
            return null;
        }
        TaggedComponent tcomp = (TaggedComponent)itr.next();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Component:" + tcomp);
        }
        if (itr.hasNext()) {
            String msg = "More than one TAG_CSI_SEC_MECH_LIST tagged component found ";
            logger.log(Level.SEVERE, "iiop.many_tagged_component");
            throw new RuntimeException(msg);
        }
        org.omg.IOP.TaggedComponent comp = tcomp.getIOPComponent(this.orb);
        byte[] b = comp.component_data;
        EncapsInputStream in = new EncapsInputStream(this.orb, b, b.length);
        in.consumeEndian();
        CompoundSecMechList l = CompoundSecMechListHelper.read((InputStream)in);
        CompoundSecMech[] list = l.mechanism_list;
        return list;
    }

    public TLS_SEC_TRANS getSSLInformation(CompoundSecMech mech) {
        org.omg.IOP.TaggedComponent pcomp = mech.transport_mech;
        TLS_SEC_TRANS ssl = this.getSSLComponent(pcomp);
        return ssl;
    }

    private TLS_SEC_TRANS getSSLComponent(org.omg.IOP.TaggedComponent comp) {
        TLS_SEC_TRANS ssl = null;
        if (comp.tag == 34) {
            ssl = null;
        } else {
            byte[] b = comp.component_data;
            EncapsInputStream in = new EncapsInputStream(this.orb, b, b.length);
            in.consumeEndian();
            ssl = TLS_SEC_TRANSHelper.read((InputStream)in);
        }
        return ssl;
    }

    static {
        byte[] b = new byte[]{};
        NULL_TAGGED_COMPONENT = new org.omg.IOP.TaggedComponent(34, b);
    }

    private static interface DescriptorMaker
    extends UnaryFunction<EjbIORConfigurationDescriptor, org.omg.IOP.TaggedComponent> {
    }
}

