/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.cluster.SyncRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public final class ServerSynchronizer
implements PostConstruct {
    private static final LocalStringManagerImpl STRINGS = new LocalStringManagerImpl(ServerSynchronizer.class);
    private static final String DOMAIN_XML = "domain.xml";
    private static boolean syncArchive;
    @Inject
    private ServerEnvironment env;
    @Inject
    private Domain domain;
    @Inject
    @Optional
    private Applications applications;
    private URI domainRootUri;
    private Logger logger;

    public void postConstruct() {
        this.domainRootUri = this.env.getInstanceRoot().toURI();
    }

    public void synchronize(Server server, SyncRequest syncRequest, Payload.Outbound payload, ActionReport report, Logger logger) {
        this.logger = logger;
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ServerSynchronizer: synchronization request for server {0}, directory {1}", new Object[]{server.getName(), syncRequest.dir});
            }
            switch (syncRequest.dir) {
                case "config": {
                    this.synchronizeConfig(payload, server, syncRequest);
                    break;
                }
                case "applications": {
                    this.synchronizeApplications(payload, server, syncRequest);
                    break;
                }
                case "lib": {
                    this.synchronizeLib(payload, server, syncRequest);
                    break;
                }
                case "docroot": {
                    this.synchronizeDocroot(payload, server, syncRequest);
                    break;
                }
                case "endpoints": {
                    this.synchronizeEndpoints(payload, server, syncRequest);
                    break;
                }
                case "config-specific": {
                    this.synchronizeConfigSpecificDir(payload, server, syncRequest);
                    break;
                }
                default: {
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(STRINGS.getLocalString("serversync.unknown.dir", "Unknown directory: {0}", new Object[]{syncRequest.dir}));
                    return;
                }
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (URISyntaxException ex) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ServerSynchronizer: Exception processing request");
                logger.fine(ex.toString());
            }
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(STRINGS.getLocalString("serversync.exception.processing", "ServerSynchronizer: Exception processing request"));
            report.setFailureCause((Throwable)ex);
        }
    }

    private void synchronizeConfig(Payload.Outbound payload, Server server, SyncRequest syncRequest) throws URISyntaxException {
        File configDir;
        this.logger.finer("ServerSynchronizer: synchronize config");
        SyncRequest.ModTime domainXmlMT = null;
        for (SyncRequest.ModTime modTime : syncRequest.files) {
            if (!modTime.name.equals(DOMAIN_XML)) continue;
            domainXmlMT = modTime;
            break;
        }
        if (domainXmlMT == null) {
            domainXmlMT = new SyncRequest.ModTime(DOMAIN_XML, 0L);
        }
        if (!this.syncFile(this.domainRootUri, configDir = this.env.getConfigDirPath(), domainXmlMT, payload)) {
            this.logger.fine("ServerSynchronizer: domain.xml HAS NOT CHANGED, thus no files will be synchronized");
            return;
        }
        Set<String> configFileSet = this.getConfigFileNames();
        configFileSet.remove(DOMAIN_XML);
        this.getRealmFileNames(server, configFileSet);
        for (SyncRequest.ModTime modTime : syncRequest.files) {
            if (modTime.name.equals(DOMAIN_XML)) continue;
            if (configFileSet.contains(modTime.name)) {
                configFileSet.remove(modTime.name);
                this.syncFile(this.domainRootUri, configDir, modTime, payload);
                continue;
            }
            this.removeFile(this.domainRootUri, configDir, modTime, payload);
        }
        for (String name : configFileSet) {
            this.syncFile(this.domainRootUri, configDir, new SyncRequest.ModTime(name, 0L), payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getConfigFileNames() {
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        BufferedReader in = null;
        try {
            File configDir = this.env.getConfigDirPath();
            File configFiles = new File(configDir, "config-files");
            if (configFiles.exists()) {
                in = new BufferedReader(new InputStreamReader(new FileInputStream(configFiles)));
            } else {
                InputStream res = this.getClass().getResourceAsStream("/META-INF/config-files");
                if (res != null) {
                    in = new BufferedReader(new InputStreamReader(res));
                } else {
                    this.logger.severe("ServerSynchronizer: can't find list of config files to synchronize!");
                }
            }
            if (in != null) {
                String line;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#") || (line = line.trim()).length() == 0) continue;
                    files.add(line);
                }
            }
        }
        catch (IOException ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("ServerSynchronizer: IOException in getConfigFileNames");
                this.logger.fine(ex.toString());
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return files;
    }

    private void getRealmFileNames(Server server, Set<String> files) {
        File configDir = this.env.getConfigDirPath();
        URI configURI = configDir.toURI();
        Config config = this.domain.getConfigNamed(server.getConfigRef());
        for (String file : FileRealm.getRealmFileNames((Config)config)) {
            URI realmFileUri;
            File realmfile = new File(file);
            if (!realmfile.exists() || (realmFileUri = configURI.relativize(realmfile.toURI())).isAbsolute()) continue;
            files.add(realmFileUri.toString());
        }
    }

    private boolean syncFile(URI root, File base, SyncRequest.ModTime modTime, Payload.Outbound payload) throws URISyntaxException {
        block6: {
            File f = this.fileOf(base, modTime.name);
            if (!f.exists()) {
                return false;
            }
            if (modTime.time != 0L && f.lastModified() == modTime.time) {
                return false;
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "ServerSynchronizer: file {0} out of date, time {1}", new Object[]{modTime.name, f.lastModified()});
            }
            try {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "ServerSynchronizer: sending file {0}{1}", new Object[]{f, modTime.time == 0L ? " because it doesn't exist on the instance" : " because it was out of date"});
                }
                payload.requestFileReplacement("application/octet-stream", root.relativize(f.toURI()), "configChange", null, f, true);
            }
            catch (IOException ioex) {
                if (!this.logger.isLoggable(Level.FINE)) break block6;
                this.logger.log(Level.FINE, "ServerSynchronizer: IOException attaching file: {0}", f);
                this.logger.fine(ioex.toString());
            }
        }
        return true;
    }

    private void removeFile(URI root, File base, SyncRequest.ModTime mt, Payload.Outbound payload) throws URISyntaxException {
        block3: {
            File f = this.fileOf(base, mt.name);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "ServerSynchronizer: file {0} removed from client", mt.name);
            }
            try {
                this.logger.log(Level.FINE, "ServerSynchronizer: removing file {0} because it does not exist on the DAS", f);
                payload.requestFileRemoval(root.relativize(f.toURI()), "configChange", null);
            }
            catch (IOException ioex) {
                if (!this.logger.isLoggable(Level.FINE)) break block3;
                this.logger.log(Level.FINE, "ServerSynchronizer: IOException removing file: {0}", f);
                this.logger.fine(ioex.toString());
            }
        }
    }

    private void synchronizeApplications(Payload.Outbound payload, Server server, SyncRequest syncRequest) throws URISyntaxException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "ServerSynchronizer: synchronize application instance {0}", syncRequest.instance);
        }
        Map<String, Application> apps = this.getApps(server);
        File appsDir = this.env.getApplicationRepositoryPath();
        for (SyncRequest.ModTime modTime : syncRequest.files) {
            if (apps.containsKey(modTime.name)) {
                this.syncApp(apps.get(modTime.name), appsDir, modTime, payload);
                apps.remove(modTime.name);
                continue;
            }
            this.removeApp(apps.get(modTime.name), appsDir, modTime, payload);
        }
        for (Map.Entry entry : apps.entrySet()) {
            this.syncApp((Application)entry.getValue(), appsDir, new SyncRequest.ModTime((String)entry.getKey(), 0L), payload);
        }
    }

    private Map<String, Application> getApps(Server server) {
        HashMap<String, Application> apps = new HashMap<String, Application>();
        if (this.applications == null) {
            return apps;
        }
        for (ApplicationRef ref : server.getApplicationRef()) {
            Application app = this.applications.getApplication(ref.getRef());
            if (app == null) continue;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "ServerSynchronizer: got app {0}", app.getName());
            }
            if (Boolean.parseBoolean(app.getDirectoryDeployed())) {
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.log(Level.FINEST, "ServerSynchronizer: skipping directory deployed app: {0}", app.getName());
                continue;
            }
            apps.put(VersioningUtils.getRepositoryName((String)app.getName()), app);
        }
        return apps;
    }

    private boolean syncApp(Application app, File base, SyncRequest.ModTime modTime, Payload.Outbound payload) throws URISyntaxException {
        block9: {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "ServerSynchronizer: sync app {0}", modTime.name);
            }
            try {
                File appDir = this.fileOf(base, modTime.name);
                if (syncArchive) {
                    File archive = app.application();
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "ServerSynchronizer: check archive {0}", archive);
                    }
                    if (modTime.time != 0L && archive.lastModified() == modTime.time) {
                        return false;
                    }
                    this.attachAppArchive(archive, payload);
                } else {
                    this.logger.log(Level.FINEST, "ServerSynchronizer: check app dir {0}", appDir);
                    if (modTime.time != 0L && appDir.lastModified() == modTime.time) {
                        return false;
                    }
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "ServerSynchronizer: sending files for application {0}{1}", new Object[]{modTime.name, modTime.time == 0L ? " because it doesn't exist on the instance" : " because it was out of date"});
                    }
                    this.attachAppDir(appDir, payload);
                }
                File gdir = this.env.getApplicationCompileJspPath();
                this.attachAppDir(this.fileOf(gdir, modTime.name), payload);
                gdir = this.env.getApplicationGeneratedXMLPath();
                this.attachAppDir(this.fileOf(gdir, modTime.name), payload);
                gdir = this.env.getApplicationEJBStubPath();
                this.attachAppDir(this.fileOf(gdir, modTime.name), payload);
                gdir = new File(this.env.getApplicationStubPath(), "policy");
                this.attachAppDir(this.fileOf(gdir, modTime.name), payload);
                gdir = this.env.getApplicationAltDDPath();
                this.attachAppDir(this.fileOf(gdir, modTime.name), payload);
            }
            catch (IOException ioex) {
                if (!this.logger.isLoggable(Level.FINE)) break block9;
                this.logger.log(Level.FINE, "ServerSynchronizer: IOException syncing app {0}", modTime.name);
                this.logger.fine(ioex.toString());
            }
        }
        return true;
    }

    private void synchronizeLib(Payload.Outbound payload, Server server, SyncRequest syncRequest) throws URISyntaxException {
        ArrayList<String> skip = new ArrayList<String>();
        skip.add("databases");
        this.synchronizeDirectory(payload, server, syncRequest, this.env.getLibPath(), skip, SyncLevel.RECURSIVE);
    }

    private void synchronizeDocroot(Payload.Outbound payload, Server server, SyncRequest syncRequest) throws URISyntaxException {
        this.synchronizeDirectory(payload, server, syncRequest, new File(this.env.getInstanceRoot(), "docroot"), null, SyncLevel.DIRECTORY);
    }

    private void synchronizeEndpoints(Payload.Outbound payload, Server server, SyncRequest syncRequest) throws URISyntaxException {
        this.synchronizeDirectory(payload, server, syncRequest, new File(this.env.getInstanceRoot(), "endpoints"), null, SyncLevel.RECURSIVE);
    }

    private void synchronizeDirectory(Payload.Outbound payload, Server server, SyncRequest syncRequest, File dir, List<String> skip, SyncLevel level) throws URISyntaxException {
        this.logger.log(Level.FINEST, "ServerSynchronizer: directory is {0}", dir);
        this.synchronizeDirectory(payload, server, syncRequest, dir, this.getFileNames(dir, skip, level));
    }

    private void synchronizeDirectory(Payload.Outbound payload, Server server, SyncRequest syncRequest, File dir, List<String> fileSet) throws URISyntaxException {
        for (SyncRequest.ModTime modTime : syncRequest.files) {
            if (fileSet.contains(modTime.name)) {
                fileSet.remove(modTime.name);
                this.syncFile(this.domainRootUri, dir, modTime, payload);
                continue;
            }
            this.removeFile(this.domainRootUri, dir, modTime, payload);
        }
        for (String name : fileSet) {
            this.syncFile(this.domainRootUri, dir, new SyncRequest.ModTime(name, 0L), payload);
        }
    }

    private void synchronizeConfigSpecificDir(Payload.Outbound payload, Server server, SyncRequest syncRequest) throws URISyntaxException {
        String configDirName = server.getConfigRef();
        File configDir = this.env.getConfigDirPath();
        File configSpecificDir = new File(configDir, configDirName);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("ServerSynchronizer: config-specific directory is " + configSpecificDir);
        }
        if (!configSpecificDir.exists()) {
            this.logger.log(Level.FINE, "ServerSynchronizer: no config-specific directory to synchronize: {0}", configSpecificDir);
            return;
        }
        ArrayList<String> fileSet = new ArrayList<String>();
        this.getFileNames(configSpecificDir, configDir, null, fileSet, SyncLevel.DIRECTORY);
        this.synchronizeDirectory(payload, server, syncRequest, configDir, fileSet);
    }

    private List<String> getFileNames(File dir, List<String> skip, SyncLevel level) {
        ArrayList<String> names = new ArrayList<String>();
        if (dir.exists()) {
            this.getFileNames(dir, dir, skip, names, level);
        } else {
            this.logger.log(Level.FINEST, "ServerSynchronizer: directory doesn''t exist: {0}", dir);
        }
        return names;
    }

    private int getFileNames(File dir, File baseDir, List<String> skip, List<String> names, SyncLevel level) {
        if (level == SyncLevel.TOP) {
            String name = baseDir.toURI().relativize(dir.toURI()).getPath();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            names.add(name);
            return 1;
        }
        int cnt = 0;
        for (String file : dir.list()) {
            File f = new File(dir, file);
            String name = baseDir.toURI().relativize(f.toURI()).getPath();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            if (skip != null && skip.contains(name)) continue;
            if (f.isDirectory() && level == SyncLevel.RECURSIVE) {
                int subFileCnt = this.getFileNames(f, baseDir, skip, names, level);
                if (subFileCnt == 0) {
                    names.add(name);
                    ++cnt;
                    continue;
                }
                cnt += subFileCnt;
                continue;
            }
            names.add(name);
            ++cnt;
        }
        return cnt;
    }

    private void attachAppArchive(File file, Payload.Outbound payload) throws IOException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "ServerSynchronizer: domainRootUri {0}", this.domainRootUri);
            this.logger.log(Level.FINER, "ServerSynchronizer: file.toURI() {0}", file.toURI());
            this.logger.log(Level.FINER, "ServerSynchronizer: attach file {0}", this.domainRootUri.relativize(file.toURI()));
        }
        payload.attachFile("application/octet-stream", this.domainRootUri.relativize(file.toURI()), "configChange", file, true);
    }

    private void attachAppDir(File dir, Payload.Outbound payload) throws IOException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "ServerSynchronizer: attach directory {0}", this.domainRootUri.relativize(dir.toURI()));
        }
        if (!dir.exists()) {
            this.logger.finer("ServerSynchronizer: nothing to attach");
            return;
        }
        payload.requestFileReplacement("application/octet-stream", this.domainRootUri.relativize(dir.toURI()), "configChange", null, dir, true);
    }

    private void removeApp(Application app, File base, SyncRequest.ModTime modTime, Payload.Outbound payload) throws URISyntaxException {
        block3: {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "ServerSynchronizer: removing files for application {0} because it is no longer deployed to this instance", modTime.name);
            }
            try {
                this.removeDir(this.fileOf(base, modTime.name), payload);
                this.removeDir(this.fileOf(this.env.getApplicationCompileJspPath(), modTime.name), payload);
                this.removeDir(this.fileOf(this.env.getApplicationGeneratedXMLPath(), modTime.name), payload);
                this.removeDir(this.fileOf(this.env.getApplicationEJBStubPath(), modTime.name), payload);
                this.removeDir(this.fileOf(new File(this.env.getApplicationStubPath(), "policy"), modTime.name), payload);
            }
            catch (IOException ioex) {
                if (!this.logger.isLoggable(Level.FINE)) break block3;
                this.logger.log(Level.FINE, "ServerSynchronizer: IOException removing app {0}", modTime.name);
                this.logger.fine(ioex.toString());
            }
        }
    }

    private void removeDir(File file, Payload.Outbound payload) throws IOException {
        payload.requestFileRemoval(this.domainRootUri.relativize(file.toURI()), "configChange", null, true);
    }

    private File fileOf(File base, String uri) throws URISyntaxException {
        return new File(new URI(base.toURI().toString() + "/" + uri));
    }

    private static enum SyncLevel {
        TOP,
        DIRECTORY,
        RECURSIVE;

    }
}

