/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.admin;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.util.StringUtils;
import fish.payara.ejb.http.admin.EjbInvokerConfiguration;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.web.deployment.runtime.SunWebAppImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="ejb-invoker-service")
@RunLevel(value=10)
public class EjbInvokerService
implements EventListener,
ConfigListener {
    @Inject
    private Events events;
    @Inject
    private EjbInvokerConfiguration config;

    @PostConstruct
    public void init() {
        if (this.events == null) {
            this.events = (Events)Globals.getDefaultBaseServiceLocator().getService(Events.class, new Annotation[0]);
        }
        this.events.register((EventListener)this);
    }

    public void event(EventListener.Event event) {
        DeploymentContext context;
        Application app;
        if (event.is(Deployment.APPLICATION_PREPARED) && (app = (Application)(context = (DeploymentContext)event.hook()).getModuleMetaData(Application.class)) != null && "__ejb-invoker".equals(app.getAppName()) && Boolean.parseBoolean(this.config.getSecurityEnabled())) {
            for (WebBundleDescriptor descriptor : app.getBundleDescriptors(WebBundleDescriptor.class)) {
                String moduleName;
                SunWebAppImpl webApp = (SunWebAppImpl)descriptor.getSunDescriptor();
                if (StringUtils.ok((String)this.config.getAuthModuleClass()) && this.config.getAuthModuleClass().indexOf(46) != -1) {
                    moduleName = this.config.getAuthModuleClass().substring(this.config.getAuthModuleClass().lastIndexOf(46) + 1);
                    webApp.setAttributeValue("HttpServletSecurityProvider", moduleName);
                } else if (StringUtils.ok((String)this.config.getAuthModule())) {
                    moduleName = this.config.getAuthModule();
                    webApp.setAttributeValue("HttpServletSecurityProvider", moduleName);
                }
                LoginConfiguration loginConf = descriptor.getLoginConfiguration();
                String authType = this.config.getAuthType();
                String realmName = this.config.getRealmName();
                if (StringUtils.ok((String)authType)) {
                    loginConf.setAuthenticationMethod(authType);
                }
                if (StringUtils.ok((String)realmName)) {
                    loginConf.setRealmName(realmName);
                }
                if (!"FORM".equals(this.config.getAuthType())) continue;
                loginConf.setFormErrorPage("/error.xhtml");
                loginConf.setFormLoginPage("/login.xhtml");
            }
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList<UnprocessedChangeEvent> unchangedList = new ArrayList<UnprocessedChangeEvent>();
        if (!Boolean.parseBoolean(this.config.getEnabled())) {
            return null;
        }
        for (PropertyChangeEvent event : events) {
            if ("enabled".equals(event.getPropertyName())) {
                unchangedList.clear();
                break;
            }
            unchangedList.add(new UnprocessedChangeEvent(event, "EJB Invoker configuration changed: " + event.getPropertyName() + " was changed from " + event.getOldValue() + " to " + event.getNewValue()));
        }
        return unchangedList.size() > 0 ? new UnprocessedChangeEvents(unchangedList) : null;
    }
}

