/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.opentracing.tracer;

import fish.payara.notification.requesttracing.EventType;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.notification.requesttracing.RequestTraceSpanContext;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.ScopeManager;
import fish.payara.opentracing.span.Span;
import fish.payara.opentracing.tracer.InvalidCarrierFormatException;
import io.opentracing.Scope;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;

public class Tracer
implements io.opentracing.Tracer {
    private final String applicationName;
    private static final ScopeManager scopeManager = new ScopeManager();
    private static final String TRACEID_KEY = "traceid";
    private static final String SPANID_KEY = "spanid";
    private RequestTracingService requestTracingService;

    public Tracer(String applicationName, RequestTracingService requestTracingService) {
        this.applicationName = applicationName;
        this.requestTracingService = requestTracingService;
    }

    public SpanBuilder buildSpan(String operationName) {
        return new SpanBuilder(operationName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        RequestTraceSpanContext payaraSpanContext = (RequestTraceSpanContext)spanContext;
        Iterable baggageItems = payaraSpanContext.baggageItems();
        if (carrier instanceof TextMap) {
            TextMap map = (TextMap)carrier;
            if (format.equals((Object)Format.Builtin.HTTP_HEADERS)) {
                for (Map.Entry baggage : baggageItems) {
                    map.put(this.encodeURLString((String)baggage.getKey()), this.encodeURLString((String)baggage.getValue()));
                }
                map.put(TRACEID_KEY, this.encodeURLString(payaraSpanContext.getTraceId().toString()));
                map.put(SPANID_KEY, this.encodeURLString(payaraSpanContext.getSpanId().toString()));
                return;
            } else {
                if (!format.equals((Object)Format.Builtin.TEXT_MAP)) throw new InvalidCarrierFormatException(format, carrier);
                for (Map.Entry baggage : baggageItems) {
                    map.put((String)baggage.getKey(), (String)baggage.getValue());
                }
                map.put(TRACEID_KEY, payaraSpanContext.getTraceId().toString());
                map.put(SPANID_KEY, payaraSpanContext.getSpanId().toString());
            }
            return;
        }
        if (!(carrier instanceof ByteBuffer)) throw new InvalidCarrierFormatException(format, carrier);
        ByteBuffer buffer = (ByteBuffer)carrier;
        if (!format.equals((Object)Format.Builtin.BINARY)) throw new InvalidCarrierFormatException(format, carrier);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectWriter = new ObjectOutputStream(bytesOut);
            objectWriter.writeObject(spanContext);
            objectWriter.flush();
            buffer.put(bytesOut.toByteArray());
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(Tracer.class.getName()).log(Level.WARNING, null, ex);
            throw new UncheckedIOException(ex);
        }
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        boolean traceIDRecieved = false;
        if (carrier instanceof TextMap) {
            TextMap map = (TextMap)carrier;
            HashMap<String, String> baggageItems = new HashMap<String, String>();
            Iterator allEntries = map.iterator();
            UUID traceId = null;
            UUID spanId = null;
            if (format.equals((Object)Format.Builtin.HTTP_HEADERS)) {
                block18: while (allEntries.hasNext()) {
                    Map.Entry entry = (Map.Entry)allEntries.next();
                    switch ((String)entry.getKey()) {
                        case "traceid": {
                            traceId = UUID.fromString(this.decodeURLString((String)entry.getValue()));
                            traceIDRecieved = true;
                            continue block18;
                        }
                        case "spanid": {
                            spanId = UUID.fromString(this.decodeURLString((String)entry.getValue()));
                            continue block18;
                        }
                    }
                    baggageItems.put(this.decodeURLString((String)entry.getKey()), this.decodeURLString((String)entry.getValue()));
                }
            } else if (format.equals((Object)Format.Builtin.TEXT_MAP)) {
                block19: while (allEntries.hasNext()) {
                    Map.Entry entry = (Map.Entry)allEntries.next();
                    switch ((String)entry.getKey()) {
                        case "traceid": {
                            traceId = UUID.fromString((String)entry.getValue());
                            traceIDRecieved = true;
                            continue block19;
                        }
                        case "spanid": {
                            spanId = UUID.fromString((String)entry.getValue());
                            continue block19;
                        }
                    }
                    baggageItems.put((String)entry.getKey(), (String)entry.getValue());
                }
            } else {
                throw new InvalidCarrierFormatException(format, carrier);
            }
            if (traceIDRecieved) {
                if (spanId == null) {
                    throw new IllegalArgumentException("No SpanId recieved");
                }
                return new RequestTraceSpanContext(traceId, spanId, baggageItems);
            }
            return null;
        }
        if (carrier instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)carrier;
            if (format.equals((Object)Format.Builtin.BINARY)) {
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer.array());
                    ObjectInputStream objectStream = new ObjectInputStream(inputStream);
                    return (SpanContext)objectStream.readObject();
                }
                catch (IOException | ClassCastException | ClassNotFoundException ex) {
                    Logger.getLogger(Tracer.class.getName()).log(Level.FINER, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            throw new InvalidCarrierFormatException(format, carrier);
        }
        throw new InvalidCarrierFormatException(format, carrier);
    }

    public io.opentracing.ScopeManager scopeManager() {
        return scopeManager;
    }

    public io.opentracing.Span activeSpan() {
        return this.scopeManager().activeSpan();
    }

    private String decodeURLString(String toDecode) {
        try {
            return URLDecoder.decode(toDecode, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String encodeURLString(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Scope activateSpan(io.opentracing.Span span) {
        return scopeManager.activate(span);
    }

    public void close() {
        if (scopeManager instanceof ScopeManager) {
            scopeManager.activeScope().close();
        }
    }

    public class SpanBuilder
    implements Tracer.SpanBuilder {
        private boolean ignoreActiveSpan = false;
        private long microsecondsStartTime = 0L;
        private final Span span;

        public SpanBuilder(String operationName) {
            ServiceHandle serviceHandle;
            ServiceLocator serviceLocator;
            this.span = new Span(operationName, Tracer.this.applicationName);
            if (Tracer.this.requestTracingService == null && (serviceLocator = Globals.getDefaultBaseServiceLocator()) != null && (serviceHandle = serviceLocator.getServiceHandle(RequestTracingService.class, new Annotation[0])) != null && serviceHandle.isActive()) {
                Tracer.this.requestTracingService = (RequestTracingService)serviceHandle.getService();
            }
        }

        public SpanBuilder asChildOf(SpanContext parentSpanContext) {
            this.span.addSpanReference((RequestTraceSpanContext)parentSpanContext, RequestTraceSpan.SpanContextRelationshipType.ChildOf);
            return this;
        }

        public SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
            this.span.addSpanReference((RequestTraceSpanContext)referencedContext, RequestTraceSpan.SpanContextRelationshipType.valueOf((String)referenceType));
            return this;
        }

        public SpanBuilder asChildOf(io.opentracing.Span parentSpan) {
            this.asChildOf(parentSpan.context());
            return this;
        }

        public SpanBuilder ignoreActiveSpan() {
            this.ignoreActiveSpan = true;
            return this;
        }

        public SpanBuilder withTag(String key, String value) {
            this.span.setTag(key, value);
            return this;
        }

        public SpanBuilder withTag(String key, boolean value) {
            this.span.setTag(key, value);
            return this;
        }

        public SpanBuilder withTag(String key, Number value) {
            this.span.setTag(key, value);
            return this;
        }

        public <T> SpanBuilder withTag(Tag<T> key, T value) {
            this.span.setTag(key, value);
            return this;
        }

        public SpanBuilder withStartTimestamp(long microseconds) {
            this.microsecondsStartTime = microseconds;
            return this;
        }

        public io.opentracing.Span start() {
            Span activeSpan;
            if (!this.ignoreActiveSpan && (activeSpan = (Span)Tracer.this.activeSpan()) != null) {
                this.asChildOf(activeSpan);
            }
            if (this.microsecondsStartTime != 0L) {
                this.span.setStartTime(this.microsecondsStartTime);
            } else {
                this.span.setStartTime(TimeUnit.MICROSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
            }
            if (Tracer.this.requestTracingService != null && !Tracer.this.requestTracingService.isTraceInProgress()) {
                if (this.span.getSpanReferences().isEmpty()) {
                    this.span.setEventType(EventType.TRACE_START);
                } else {
                    this.span.setEventType(EventType.PROPAGATED_TRACE);
                    this.span.setTraceId(((RequestTraceSpan.SpanReference)this.span.getSpanReferences().get(0)).getReferenceSpanContext().getTraceId());
                }
                Tracer.this.requestTracingService.startTrace(this.span);
            }
            return this.span;
        }
    }
}

