/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.batch;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchRuntime;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.batch.spi.impl.BatchRuntimeConfiguration;
import org.glassfish.batch.spi.impl.BatchRuntimeHelper;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="clean-jbatch-repository")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.INSTANCE})
public class CleanJbatchRepository
implements AdminCommand {
    @Param(acceptableValues="ALL,COMPLETED", defaultValue="COMPLETED", optional=true)
    String status;
    @Param(optional=true, defaultValue="1")
    int days;
    @Param(name="jobname", primary=true, optional=false)
    String jobname;
    @Inject
    BatchRuntimeHelper batchRuntimeHelper;
    @Inject
    BatchRuntimeConfiguration config;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            BatchRuntime.getJobOperator();
        }
        catch (ServiceConfigurationError error) {
            report.setMessage("Could not get JobOperator. Check if the Batch DataSource is configured properly and Check if the Database is up and running");
            report.setFailureCause((Throwable)error);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.days < 1) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("The value for parameter --day must be 1 or higher.");
            return;
        }
        try {
            String dataSourceName = this.batchRuntimeHelper.getDataSourceLookupName();
            InitialContext ctx = new InitialContext();
            Object object = ctx.lookup(dataSourceName);
            if (!(object instanceof DataSource)) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Invalid data source type for JBatch");
                return;
            }
            DataSource datasource = (DataSource)object;
            Feedback feedback = new Feedback();
            try {
                Throwable throwable = null;
                try (Connection conn = datasource.getConnection();){
                    boolean valid = conn.isValid(0);
                    if (!valid) {
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setMessage("Database not accessible");
                        return;
                    }
                    this.cleanTables(conn, feedback);
                    return;
                }
                catch (SQLException ex) {
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage("Database not accessible");
                    report.setFailureCause((Throwable)ex);
                    return;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger("fish.payara.batch").log(Level.SEVERE, "Error cleaning repository with table " + feedback.tableToClean, ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Error cleaning repository");
                report.setFailureCause((Throwable)ex);
                return;
            }
        }
        catch (NamingException ex) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Unable to get data source for JBatch");
            report.setFailureCause((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTables(Connection connection, Feedback feedback) throws SQLException {
        try {
            connection.setAutoCommit(false);
            Timestamp threshold = this.determineEndTime();
            String prefix = this.config.getTablePrefix();
            String suffix = this.config.getTableSuffix();
            String tableStepStatus = prefix + "STEPSTATUS" + suffix;
            String tableJobInstanceData = prefix + "JOBINSTANCEDATA" + suffix;
            String tableExecutionInstanceData = prefix + "EXECUTIONINSTANCEDATA" + suffix;
            String tableStepExecutionInstanceData = prefix + "STEPEXECUTIONINSTANCEDATA" + suffix;
            String tableJobStatus = prefix + "JOBSTATUS" + suffix;
            String statusCheck1 = "";
            String statusCheck2 = "";
            if (this.status.equals("COMPLETED")) {
                statusCheck1 = " AND eid.batchstatus = 'COMPLETED'";
                statusCheck2 = " AND batchstatus = 'COMPLETED'";
            }
            feedback.tableToClean = tableStepStatus;
            String sql = "DELETE FROM " + tableStepStatus + " WHERE id IN (SELECT seid.stepexecid FROM " + tableJobInstanceData + " jid, " + tableExecutionInstanceData + " eid, " + tableStepExecutionInstanceData + " seid WHERE jid.jobinstanceid = eid.jobinstanceid AND eid.jobexecid = seid.jobexecid AND jid.name = ? AND eid.endtime < ? " + statusCheck1 + " )";
            PreparedStatement deleteStatement = connection.prepareStatement(sql);
            deleteStatement.setString(1, this.jobname);
            deleteStatement.setTimestamp(2, threshold);
            deleteStatement.execute();
            feedback.tableToClean = tableStepExecutionInstanceData;
            sql = "DELETE FROM " + tableStepExecutionInstanceData + " WHERE jobexecid IN (SELECT eid.jobexecid FROM " + tableJobInstanceData + " jid, " + tableExecutionInstanceData + " eid WHERE jid.jobinstanceid = eid.jobinstanceid AND jid.name = ? AND eid.endtime < ? " + statusCheck1 + " )";
            deleteStatement = connection.prepareStatement(sql);
            deleteStatement.setString(1, this.jobname);
            deleteStatement.setTimestamp(2, threshold);
            deleteStatement.execute();
            feedback.tableToClean = tableExecutionInstanceData;
            sql = "DELETE FROM " + tableExecutionInstanceData + " WHERE jobinstanceid IN (SELECT jid.jobinstanceid FROM " + tableJobInstanceData + " jid WHERE jid.name = ?) AND endtime < ? " + statusCheck2;
            deleteStatement = connection.prepareStatement(sql);
            deleteStatement.setString(1, this.jobname);
            deleteStatement.setTimestamp(2, threshold);
            deleteStatement.execute();
            feedback.tableToClean = tableJobStatus;
            deleteStatement = connection.prepareStatement("DELETE FROM " + tableJobStatus + " WHERE id NOT IN (SELECT DISTINCT jobinstanceid FROM " + tableExecutionInstanceData + ")");
            deleteStatement.execute();
            feedback.tableToClean = tableJobInstanceData;
            deleteStatement = connection.prepareStatement("DELETE FROM " + tableJobInstanceData + " WHERE jobinstanceid NOT IN (SELECT DISTINCT jobinstanceid FROM " + tableExecutionInstanceData + ")");
            deleteStatement.execute();
            connection.commit();
        }
        finally {
            connection.rollback();
        }
    }

    private Timestamp determineEndTime() {
        LocalDateTime threshold = LocalDateTime.now().minusDays(this.days);
        return Timestamp.valueOf(threshold);
    }

    private static class Feedback {
        String tableToClean;

        private Feedback() {
        }
    }
}

