<!--

    DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.

    Copyright (c) 2013 Oracle and/or its affiliates. All rights reserved.

    The contents of this file are subject to the terms of either the GNU
    General Public License Version 2 only ("GPL") or the Common Development
    and Distribution License("CDDL") (collectively, the "License").  You
    may not use this file except in compliance with the License.  You can
    obtain a copy of the License at
    https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
    or packager/legal/LICENSE.txt.  See the License for the specific
    language governing permissions and limitations under the License.

    When distributing the software, include this License Header Notice in each
    file and include the License file at packager/legal/LICENSE.txt.

    GPL Classpath Exception:
    Oracle designates this particular file as subject to the "Classpath"
    exception as provided by Oracle in the GPL Version 2 section of the License
    file that accompanied this code.

    Modifications:
    If applicable, add the following below the License Header, with the fields
    enclosed by brackets [] replaced by your own identifying information:
    "Portions Copyright [year] [name of copyright owner]"

    Contributor(s):
    If you wish your version of this file to be governed by only the CDDL or
    only the GPL Version 2, indicate your decision by adding "[Contributor]
    elects to include this software in this distribution under the [CDDL or GPL
    Version 2] license."  If you don't indicate a single choice of license, a
    recipient has the option to distribute your version of this file under
    either the CDDL, the GPL Version 2 or to extend the choice of license to
    its licensees as provided above.  However, if you add GPL Version 2 code
    and therefore, elected the GPL Version 2 license, then the option applies
    only if the new code is made subject to such option by the copyright
    holder.

-->
<!-- Portions Copyright [2016] [Payara Foundation] -->
#include "/common/shared/alertMsg_1.inc"
    <sun:title id="propertyContentPage" title="$resource{i18nf.batch.configurationTitle}" helpText="$resource{i18nf.batch.configurationTitleHelp}" >
    <!facet pageButtonsTop>
            <sun:panelGroup id="topButtons">
                <sun:button id="saveButton"  text="$resource{i18n.button.Save}"
                        onClick="submitAndDisable(this, '$resource{i18n.button.Processing}'); return false;" >
                    <!command
                        prepareSuccessfulMsg();
                        gf.restRequest(endpoint="#{sessionScope.REST_URL}/set-batch-runtime-configuration" method="POST" attrs="#{pageSession.valueMap}");
                    />
                </sun:button>
            </sun:panelGroup>
        </facet>
    </sun:title>
#include "/common/shared/nameSection.inc"
            <sun:propertySheetSection >
                <sun:property id="executorServiceLookupName"  labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{i18nf.batch.configuration.executorServiceLookupName}" helpText="$resource{i18nf.batch.configuration.executorServiceLookupNameHelp}">
                    <sun:dropDown id="executorServiceLookupName" selected="#{pageSession.valueMap['executorServiceLookupName']}" labels="$pageSession{mesList}"  values="$pageSession{mesList}"  >
                        <!beforeCreate
                            gf.getChildrenNameFromListCmd(endpoint="#{sessionScope.REST_URL}/resources/list-managed-executor-services", attrs="#{pageSession.attrsMap}"  result="#{pageSession.mesList}");
                        />
                    </sun:dropDown>
                </sun:property>

                <sun:property id="poolNameProp"  labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{i18nf.batch.configuration.dataSourceLookupName}"  helpText="$resource{i18nf.batch.configuration.dataSourceLookupNameHelp}">
                    <sun:dropDown id="PoolName" selected="#{pageSession.valueMap['dataSourceLookupName']}" labels="$pageSession{jdbcList}"  values="$pageSession{jdbcList}" >
                    <!beforeCreate
                        gf.getChildrenNameFromListCmd(endpoint="#{sessionScope.REST_URL}/resources/list-jdbc-resources", attrs="#{pageSession.attrsMap}" result="#{pageSession.jdbcList}");
                    />
                   </sun:dropDown>
               </sun:property>
                <!-- Payara Modifications -->
                <sun:property id="schemaNameProp" labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{i18nf.batch.configuration.schemaName}"  helpText="$resource{i18nf.batch.configuration.schemaNameHelp}">
                    	<sun:textField id="schemaName" columns="$int{40}" maxLength="30" text="#{pageSession.valueMap['schemaName']}" />
                </sun:property>
                <sun:property id="tablePrefixProp" labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{i18nf.batch.configuration.tablePrefix}"  helpText="$resource{i18nf.batch.configuration.tablePrefixHelp}">
                    	<sun:textField id="tablePrefix" columns="$int{40}" maxLength="30" text="#{pageSession.valueMap['tablePrefix']}" />
                </sun:property>
                <sun:property id="tableSuffixProp" labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{i18nf.batch.configuration.tableSuffix}"  helpText="$resource{i18nf.batch.configuration.tableSuffixHelp}">
                    	<sun:textField id="tableSuffix" columns="$int{40}" maxLength="30" text="#{pageSession.valueMap['tableSuffix']}" />
                </sun:property>
                <!-- End Payara Modifications -->
            </sun:propertySheetSection>

    <sun:hidden id="helpKey" value="$resource{help_full.batchConfiguration}" />
</sun:form>
</define>
</composition>
