-- Copyright 2004-2019 H2 Group. Multiple-Licensed under the MPL 2.0,
-- and the EPL 1.0 (https://h2database.com/html/license.html).
-- Initial Developer: H2 Group
--

CREATE TABLE T1(ID1 INT, ID2 INT);
> ok

CREATE TABLE T2(ID2 INT, ID1 INT);
> ok

ALTER TABLE T2 ADD CONSTRAINT C1 FOREIGN KEY(ID1) REFERENCES T1(ID1);
> ok

DROP TABLE T1 RESTRICT;
> exception CANNOT_DROP_2

DROP TABLE T1 CASCADE;
> ok

CREATE TABLE T1(ID1 INT, ID2 INT);
> ok

ALTER TABLE T2 ADD CONSTRAINT C1 FOREIGN KEY(ID1) REFERENCES T1(ID1);
> ok

DROP TABLE T2 RESTRICT;
> ok

CREATE VIEW V1 AS SELECT * FROM T1;
> ok

DROP TABLE T1 RESTRICT;
> exception CANNOT_DROP_2

DROP TABLE T1 CASCADE;
> ok

SELECT * FROM V1;
> exception TABLE_OR_VIEW_NOT_FOUND_1

CREATE TABLE T1(ID1 INT);
> ok

ALTER TABLE T1 ADD CONSTRAINT C1 CHECK ID1 > 0;
> ok

DROP TABLE T1 RESTRICT;
> ok

CREATE TABLE T1(ID1 INT, ID2 INT);
> ok

CREATE TABLE T2(ID2 INT, ID1 INT);
> ok

ALTER TABLE T2 ADD CONSTRAINT C1 FOREIGN KEY(ID1) REFERENCES T1(ID1);
> ok

ALTER TABLE T1 ADD CONSTRAINT C2 FOREIGN KEY(ID2) REFERENCES T2(ID2);
> ok

DROP TABLE T1, T2 RESTRICT;
> ok
