/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.core.StandardContext;
import org.glassfish.web.ha.LogFacade;
import org.glassfish.web.ha.authenticator.HASessionData;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;

public class HASingleSignOnEntry
extends SingleSignOnEntry {
    private static final Logger logger = LogFacade.getLogger();
    protected long maxIdleTime;
    protected JavaEEIOUtils ioUtils;
    protected HASingleSignOnEntryMetadata metadata = null;

    public HASingleSignOnEntry() {
        this(null, null, null, null, null, 0L, 0L, 0L, null);
    }

    public HASingleSignOnEntry(Container container, HASingleSignOnEntryMetadata m, JavaEEIOUtils ioUtils) {
        this(m.getId(), null, m.getAuthType(), m.getUserName(), m.getRealmName(), m.getLastAccessTime(), m.getMaxIdleTime(), m.getVersion(), ioUtils);
        this.principal = this.parsePrincipal(m);
        this.metadata.principalBytes = m.getPrincipalBytes() == null ? null : (byte[])m.getPrincipalBytes().clone();
        for (HASessionData data : m.getHASessionDataSet()) {
            StandardContext context = (StandardContext)container.findChild(data.getContextPath());
            Session session = null;
            try {
                session = context.getManager().findSession(data.getSessionId());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot find the session: " + data.getSessionId(), ex);
            }
            if (session == null) continue;
            this.sessions.put(data.getSessionId(), session);
        }
        logger.log(Level.FINER, "Loaded HA SSO entry from metadata. Principal: {}", this.principal);
    }

    public HASingleSignOnEntry(String id, Principal principal, String authType, String username, String realmName, long lastAccessTime, long maxIdleTime, long version, JavaEEIOUtils ioUtils) {
        super(id, version, principal, authType, username, realmName);
        this.lastAccessTime = lastAccessTime;
        this.maxIdleTime = maxIdleTime;
        this.ioUtils = ioUtils;
        this.metadata = new HASingleSignOnEntryMetadata(id, version, this.convertToByteArray(principal), authType, username, realmName, lastAccessTime, maxIdleTime);
        logger.log(Level.FINER, "Created HA SSO entry. Principal: {}", this.principal);
    }

    public HASingleSignOnEntryMetadata getMetadata() {
        return this.metadata;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public synchronized boolean addSession(SingleSignOn sso, Session session) {
        boolean result = super.addSession(sso, session);
        if (result) {
            this.metadata.addHASessionData(new HASessionData(session.getId(), session.getManager().getContainer().getName()));
        }
        return result;
    }

    public synchronized void removeSession(Session session) {
        super.removeSession(session);
        this.metadata.removeHASessionData(new HASessionData(session.getId(), session.getManager().getContainer().getName()));
    }

    public void setLastAccessTime(long lastAccessTime) {
        super.setLastAccessTime(lastAccessTime);
        this.metadata.setLastAccessTime(lastAccessTime);
    }

    public long incrementAndGetVersion() {
        long ver = super.incrementAndGetVersion();
        this.metadata.setVersion(ver);
        return ver;
    }

    /*
     * Exception decompiling
     */
    private byte[] convertToByteArray(Principal obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Principal parsePrincipal(HASingleSignOnEntryMetadata m) {
        try (ObjectInputStream ois = this.ioUtils.createObjectInputStream((InputStream)new BufferedInputStream(new ByteArrayInputStream(m.getPrincipalBytes())), true, ((Object)((Object)this)).getClass().getClassLoader(), 0L);){
            Principal principal = (Principal)ois.readObject();
            return principal;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not parse principal from HA-SSO Metadata", ex);
        }
    }
}

