/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.cdi.interceptor;

import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.microprofile.metrics.cdi.AnnotationReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.function.BiFunction;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.glassfish.internal.api.Globals;

abstract class AbstractInterceptor {
    @Inject
    @Intercepted
    protected Bean<?> bean;
    private MetricsService metricsService;
    private MetricsService.MetricsContext metricsContext;

    AbstractInterceptor() {
    }

    protected static <E extends Member & AnnotatedElement, M extends Metric> M apply(E element, Class<?> bean, AnnotationReader<?> reader, Class<M> metricType, BiFunction<MetricID, Class<M>, M> loader) {
        MetricID metricID = reader.metricID(bean, element);
        Metric metric = (Metric)loader.apply(metricID, metricType);
        if (metric == null) {
            throw new IllegalStateException("No " + metricType.getSimpleName() + " with ID [" + metricID + "] found in application registry");
        }
        return (M)metric;
    }

    public <T extends Metric> T getMetric(MetricID metricID, Class<T> metricType) {
        this.initService();
        return this.metricsContext.getApplicationRegistry().getMetric(metricID, metricType);
    }

    @AroundConstruct
    private Object constructorInvocation(InvocationContext context) throws Exception {
        return this.preInterceptor(context, context.getConstructor());
    }

    @AroundInvoke
    private Object methodInvocation(InvocationContext context) throws Exception {
        return this.preInterceptor(context, context.getMethod());
    }

    @AroundTimeout
    private Object timeoutInvocation(InvocationContext context) throws Exception {
        return this.preInterceptor(context, context.getMethod());
    }

    private <E extends Member & AnnotatedElement> Object preInterceptor(InvocationContext context, E element) throws Exception {
        this.initService();
        if (this.metricsService.isEnabled()) {
            return this.applyInterceptor(context, element);
        }
        return context.proceed();
    }

    private void initService() {
        if (this.metricsService == null) {
            this.metricsService = (MetricsService)Globals.getDefaultBaseServiceLocator().getService(MetricsService.class, new Annotation[0]);
            if (this.metricsService.isEnabled()) {
                this.metricsContext = this.metricsService.getContext(true);
            }
        }
    }

    protected abstract <E extends Member & AnnotatedElement> Object applyInterceptor(InvocationContext var1, E var2) throws Exception;
}

