/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.jmx;

import fish.payara.microprofile.metrics.jmx.XmlTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class MBeanMetadata
implements Metadata {
    private static final Logger LOGGER = Logger.getLogger(MBeanMetadata.class.getName());
    @XmlElement(name="mbean")
    private String mBean;
    @XmlElement
    private boolean dynamic = true;
    @XmlElement
    private String name;
    @XmlElement
    private String displayName;
    @XmlElement
    private String description;
    @XmlElement
    private String unit;
    @XmlElement
    private String type;
    @XmlTransient
    private Boolean valid;
    @XmlElementWrapper(name="tags", nillable=true)
    @XmlElement(name="tag")
    private List<XmlTag> tags = new ArrayList<XmlTag>();

    public MBeanMetadata() {
    }

    public MBeanMetadata(Metadata metadata) {
        this(null, metadata.getName(), metadata.getDisplayName(), metadata.description().orElse(null), metadata.getTypeRaw(), metadata.unit().orElse(null));
    }

    public MBeanMetadata(String mBean, String name, String displayName, String description, MetricType typeRaw, String unit) {
        this();
        this.mBean = mBean;
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.type = typeRaw.toString();
        this.unit = unit;
    }

    public String getMBean() {
        return this.mBean;
    }

    public void setMBean(String mBean) {
        this.mBean = mBean;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isValid() {
        if (this.valid == null) {
            this.valid = this.validateMetadata();
        }
        return this.valid;
    }

    List<XmlTag> getTags() {
        return this.tags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Optional<String> displayName() {
        return Optional.ofNullable(this.displayName);
    }

    @Override
    public String getUnit() {
        return this.unit == null ? "none" : this.unit;
    }

    @Override
    public Optional<String> unit() {
        return Optional.ofNullable(this.unit);
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public String getType() {
        return this.type;
    }

    private boolean validateMetadata() {
        boolean validationResult = true;
        MBeanMetadata metadata = this;
        if (Objects.isNull(metadata.getName())) {
            LOGGER.log(Level.WARNING, "'name' property not defined in " + metadata.getMBean() + " mbean metadata", new Exception());
            validationResult = false;
        }
        if (Objects.isNull(metadata.getMBean())) {
            LOGGER.log(Level.WARNING, "'mbean' property not defined in {0} metadata", metadata.getName());
            validationResult = false;
        }
        if (Objects.isNull(metadata.getType())) {
            LOGGER.log(Level.WARNING, "'type' property not defined in {0} metadata", metadata.getName());
            validationResult = false;
        }
        try {
            MetricType.from(this.type);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.WARNING, "'type' property is not valid in {0} metadata", metadata.getName());
            validationResult = false;
        }
        if (Objects.nonNull(metadata.getName()) && Objects.nonNull(metadata.getMBean())) {
            for (String keyword : new String[]{"%s", "${key}", "${attribute}", "${subattribute}"}) {
                if (metadata.getName().contains(keyword) && !metadata.getMBean().contains(keyword)) {
                    LOGGER.log(Level.WARNING, "{0} placeholder not found in 'mbean' {1} property", new String[]{keyword, metadata.getMBean()});
                    validationResult = false;
                    continue;
                }
                if (!metadata.getMBean().contains(keyword)) continue;
                boolean tagSpecifier = false;
                for (XmlTag tag : this.tags) {
                    if (tag.getValue() == null || !tag.getValue().contains(keyword)) continue;
                    tagSpecifier = true;
                    break;
                }
                if (metadata.getName().contains(keyword) || tagSpecifier) continue;
                LOGGER.log(Level.WARNING, "{0} placeholder not found in 'name' {1} property or in tags", new String[]{keyword, metadata.getName()});
                validationResult = false;
            }
        }
        return validationResult;
    }

    @Override
    public MetricType getTypeRaw() {
        return MetricType.from(this.type);
    }

    public void setTags(List<XmlTag> tags) {
        if (tags == null) {
            throw new IllegalArgumentException("tags must not be null");
        }
        this.tags = tags;
    }

    public void addTags(List<XmlTag> tags) {
        this.tags.addAll(tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.displayName, this.description, this.unit, this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.name, that.getName()) && Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getUnit(), that.getUnit()) && Objects.equals((Object)this.getTypeRaw(), (Object)that.getTypeRaw());
    }

    public String toString() {
        return new StringJoiner(", ", MBeanMetadata.class.getSimpleName() + "[", "]").add("mBean='" + this.mBean + "'").add("dynamic=" + this.dynamic).add("name='" + this.name + "'").add("displayName='" + this.displayName + "'").add("description='" + this.description + "'").add("unit='" + this.unit + "'").add("type='" + this.type + "'").add("valid=" + this.valid).add("tags=" + this.tags).toString();
    }
}

