/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl;

import fish.payara.microprofile.openapi.api.OpenAPIBuildException;
import fish.payara.microprofile.openapi.impl.OpenAPISupplier;
import fish.payara.microprofile.openapi.impl.admin.OpenApiServiceConfiguration;
import fish.payara.microprofile.openapi.impl.model.OpenAPIImpl;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.Globals;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="microprofile-openapi-service")
@Singleton
public class OpenApiService {
    private boolean enabled;
    private boolean securityEnabled;
    private boolean withCorsHeaders;
    private volatile OpenAPI cachedResult;
    private Map<String, OpenAPISupplier> documents = new ConcurrentHashMap<String, OpenAPISupplier>();

    @PostConstruct
    public void initConfig() {
        OpenApiServiceConfiguration config = (OpenApiServiceConfiguration)Globals.get(OpenApiServiceConfiguration.class);
        this.enabled = Boolean.valueOf(config.getEnabled());
        this.securityEnabled = Boolean.valueOf(config.getSecurityEnabled());
        this.withCorsHeaders = Boolean.valueOf(config.getCorsHeaders());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    public boolean withCorsHeaders() {
        return this.withCorsHeaders;
    }

    public void setCorsHeaders(boolean withCorsHeaders) {
        this.withCorsHeaders = withCorsHeaders;
    }

    public void registerApp(String applicationId, DeploymentContext ctx) {
        WebBundleDescriptorImpl descriptor = (WebBundleDescriptorImpl)ctx.getModuleMetaData(WebBundleDescriptorImpl.class);
        String contextRoot = descriptor.getContextRoot();
        ReadableArchive archive = ctx.getSource();
        ClassLoader classLoader = ctx.getClassLoader();
        this.documents.put(applicationId, new OpenAPISupplier(applicationId, contextRoot, archive, classLoader));
        this.cachedResult = null;
    }

    public void deregisterApp(String applicationId) {
        this.documents.remove(applicationId);
        this.cachedResult = null;
    }

    public void resumeApp(String applicationId) {
        this.documents.get(applicationId).setEnabled(true);
        this.cachedResult = null;
    }

    public void suspendApp(String applicationId) {
        this.documents.get(applicationId).setEnabled(false);
        this.cachedResult = null;
    }

    public synchronized OpenAPI getDocument() throws OpenAPIBuildException, IOException, CloneNotSupportedException {
        if (this.documents.isEmpty()) {
            return null;
        }
        if (this.cachedResult != null) {
            return this.cachedResult;
        }
        OpenAPI result = null;
        Iterator<OpenAPISupplier> iterator = this.documents.values().iterator();
        do {
            OpenAPI next = iterator.next().get();
            if (result == null) {
                result = ((OpenAPIImpl)next).clone();
                continue;
            }
            OpenAPIImpl.merge(next, result, true, null);
        } while (iterator.hasNext());
        this.cachedResult = result;
        return result;
    }

    public static final OpenApiService getInstance() {
        return (OpenApiService)Globals.getStaticHabitat().getService(OpenApiService.class, new Annotation[0]);
    }
}

