/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.processor;

import fish.payara.microprofile.openapi.api.processor.OASProcessor;
import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.api.visitor.ApiVisitor;
import fish.payara.microprofile.openapi.impl.config.OpenApiConfiguration;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.ExternalDocumentationImpl;
import fish.payara.microprofile.openapi.impl.model.OpenAPIImpl;
import fish.payara.microprofile.openapi.impl.model.OperationImpl;
import fish.payara.microprofile.openapi.impl.model.PathItemImpl;
import fish.payara.microprofile.openapi.impl.model.callbacks.CallbackImpl;
import fish.payara.microprofile.openapi.impl.model.media.ContentImpl;
import fish.payara.microprofile.openapi.impl.model.media.MediaTypeImpl;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.model.parameters.ParameterImpl;
import fish.payara.microprofile.openapi.impl.model.parameters.RequestBodyImpl;
import fish.payara.microprofile.openapi.impl.model.responses.APIResponseImpl;
import fish.payara.microprofile.openapi.impl.model.responses.APIResponsesImpl;
import fish.payara.microprofile.openapi.impl.model.security.SecurityRequirementImpl;
import fish.payara.microprofile.openapi.impl.model.security.SecuritySchemeImpl;
import fish.payara.microprofile.openapi.impl.model.servers.ServerImpl;
import fish.payara.microprofile.openapi.impl.model.tags.TagImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import fish.payara.microprofile.openapi.impl.visitor.OpenApiWalker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.EnumType;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.ParameterizedInterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParameterizedType;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;

public class ApplicationProcessor
implements OASProcessor,
ApiVisitor {
    private static final Logger LOGGER = Logger.getLogger(ApplicationProcessor.class.getName());
    private final Types allTypes;
    private final Set<Type> allowedTypes;
    private final ClassLoader appClassLoader;
    private OpenApiWalker<?> apiWalker;

    public ApplicationProcessor(Types allTypes, Set<Type> allowedTypes, ClassLoader appClassLoader) {
        this.allTypes = allTypes;
        this.allowedTypes = allowedTypes;
        this.appClassLoader = appClassLoader;
    }

    @Override
    public OpenAPI process(OpenAPI api, OpenApiConfiguration config) {
        if (config == null || !config.getScanDisable()) {
            this.apiWalker = new OpenApiWalker(api, this.allTypes, config == null ? this.allowedTypes : config.getValidClasses(this.allowedTypes), this.appClassLoader);
            this.apiWalker.accept(this);
        }
        return api;
    }

    @Override
    public void visitGET(AnnotationModel get, MethodModel element, ApiContext context) {
        if (context.getPath() == null) {
            return;
        }
        PathItem pathItem = context.getApi().getPaths().getPathItems().getOrDefault(context.getPath(), new PathItemImpl());
        context.getApi().getPaths().addPathItem(context.getPath(), pathItem);
        OperationImpl operation = new OperationImpl();
        pathItem.setGET((Operation)operation);
        operation.setOperationId(element.getName());
        operation.setMethod("GET");
        this.insertDefaultRequestBody(context, operation, element);
        this.insertDefaultResponse(context, operation, element);
    }

    @Override
    public void visitPOST(AnnotationModel post, MethodModel element, ApiContext context) {
        if (context.getPath() == null) {
            return;
        }
        PathItem pathItem = context.getApi().getPaths().getPathItems().getOrDefault(context.getPath(), new PathItemImpl());
        context.getApi().getPaths().addPathItem(context.getPath(), pathItem);
        OperationImpl operation = new OperationImpl();
        pathItem.setPOST((Operation)operation);
        operation.setOperationId(element.getName());
        operation.setMethod("POST");
        this.insertDefaultRequestBody(context, operation, element);
        this.insertDefaultResponse(context, operation, element);
    }

    @Override
    public void visitPUT(AnnotationModel put, MethodModel element, ApiContext context) {
        if (context.getPath() == null) {
            return;
        }
        PathItem pathItem = context.getApi().getPaths().getPathItems().getOrDefault(context.getPath(), new PathItemImpl());
        context.getApi().getPaths().addPathItem(context.getPath(), pathItem);
        OperationImpl operation = new OperationImpl();
        pathItem.setPUT((Operation)operation);
        operation.setOperationId(element.getName());
        operation.setMethod("PUT");
        this.insertDefaultRequestBody(context, operation, element);
        this.insertDefaultResponse(context, operation, element);
    }

    @Override
    public void visitDELETE(AnnotationModel delete, MethodModel element, ApiContext context) {
        if (context.getPath() == null) {
            return;
        }
        PathItem pathItem = context.getApi().getPaths().getPathItems().getOrDefault(context.getPath(), new PathItemImpl());
        context.getApi().getPaths().addPathItem(context.getPath(), pathItem);
        OperationImpl operation = new OperationImpl();
        pathItem.setDELETE((Operation)operation);
        operation.setOperationId(element.getName());
        operation.setMethod("DELETE");
        this.insertDefaultRequestBody(context, operation, element);
        this.insertDefaultResponse(context, operation, element);
    }

    @Override
    public void visitHEAD(AnnotationModel head, MethodModel element, ApiContext context) {
        if (context.getPath() == null) {
            return;
        }
        PathItem pathItem = context.getApi().getPaths().getPathItems().getOrDefault(context.getPath(), new PathItemImpl());
        context.getApi().getPaths().addPathItem(context.getPath(), pathItem);
        OperationImpl operation = new OperationImpl();
        pathItem.setHEAD((Operation)operation);
        operation.setOperationId(element.getName());
        operation.setMethod("HEAD");
        this.insertDefaultRequestBody(context, operation, element);
        this.insertDefaultResponse(context, operation, element);
    }

    @Override
    public void visitOPTIONS(AnnotationModel options, MethodModel element, ApiContext context) {
        if (context.getPath() == null) {
            return;
        }
        PathItem pathItem = context.getApi().getPaths().getPathItems().getOrDefault(context.getPath(), new PathItemImpl());
        context.getApi().getPaths().addPathItem(context.getPath(), pathItem);
        OperationImpl operation = new OperationImpl();
        pathItem.setOPTIONS((Operation)operation);
        operation.setOperationId(element.getName());
        operation.setMethod("OPTIONS");
        this.insertDefaultRequestBody(context, operation, element);
        this.insertDefaultResponse(context, operation, element);
    }

    @Override
    public void visitPATCH(AnnotationModel patch, MethodModel element, ApiContext context) {
        if (context.getPath() == null) {
            return;
        }
        PathItem pathItem = context.getApi().getPaths().getPathItems().getOrDefault(context.getPath(), new PathItemImpl());
        context.getApi().getPaths().addPathItem(context.getPath(), pathItem);
        OperationImpl operation = new OperationImpl();
        pathItem.setPATCH((Operation)operation);
        operation.setOperationId(element.getName());
        operation.setMethod("PATCH");
        this.insertDefaultRequestBody(context, operation, element);
        this.insertDefaultResponse(context, operation, element);
    }

    @Override
    public void visitProduces(AnnotationModel produces, AnnotatedElement element, ApiContext context) {
        if (element instanceof MethodModel && context.getWorkingOperation() != null) {
            for (APIResponse response : context.getWorkingOperation().getResponses().getAPIResponses().values()) {
                if (response == null || response.getContent() == null || response.getContent().getMediaType("*/*") == null) continue;
                MediaType wildcardMedia = response.getContent().getMediaType("*/*");
                List mediaTypes = (List)produces.getValue("value", List.class);
                for (String mediaType : mediaTypes) {
                    MediaType held = response.getContent().getMediaType(ApplicationProcessor.getContentType(mediaType));
                    if (held == null) {
                        response.getContent().addMediaType(ApplicationProcessor.getContentType(mediaType), wildcardMedia);
                        continue;
                    }
                    MediaTypeImpl.merge(held, wildcardMedia, true);
                }
                response.getContent().removeMediaType("*/*");
            }
        }
    }

    @Override
    public void visitConsumes(AnnotationModel consumes, AnnotatedElement element, ApiContext context) {
        RequestBody requestBody;
        if (element instanceof MethodModel && context.getWorkingOperation() != null && (requestBody = context.getWorkingOperation().getRequestBody()) != null && requestBody.getContent() != null && requestBody.getContent().getMediaType("*/*") != null) {
            MediaType wildcardMedia = requestBody.getContent().getMediaType("*/*");
            List mediaTypes = (List)consumes.getValue("value", List.class);
            for (String mediaType : mediaTypes) {
                requestBody.getContent().addMediaType(ApplicationProcessor.getContentType(mediaType), wildcardMedia);
            }
            requestBody.getContent().removeMediaType("*/*");
        }
    }

    @Override
    public void visitQueryParam(AnnotationModel param, AnnotatedElement element, ApiContext context) {
        ApplicationProcessor.addParameter(element, context, (String)param.getValue("value", String.class), Parameter.In.QUERY, null);
    }

    @Override
    public void visitPathParam(AnnotationModel param, AnnotatedElement element, ApiContext context) {
        ApplicationProcessor.addParameter(element, context, (String)param.getValue("value", String.class), Parameter.In.PATH, true);
    }

    @Override
    public void visitFormParam(AnnotationModel param, AnnotatedElement element, ApiContext context) {
        Operation workingOperation;
        Schema.SchemaType formSchemaType = null;
        if (element instanceof org.glassfish.hk2.classmodel.reflect.Parameter) {
            List parameters = ((org.glassfish.hk2.classmodel.reflect.Parameter)element).getMethod().getParameters();
            for (org.glassfish.hk2.classmodel.reflect.Parameter methodParam : parameters) {
                if (methodParam.getAnnotation(FormParam.class.getName()) == null) continue;
                formSchemaType = ModelUtils.getParentSchemaType(formSchemaType, ModelUtils.getSchemaType((ParameterizedType)methodParam, context));
            }
        }
        if ((workingOperation = context.getWorkingOperation()) != null) {
            if (workingOperation.getRequestBody() == null) {
                workingOperation.setRequestBody(new RequestBodyImpl().content(new ContentImpl().addMediaType("*/*", new MediaTypeImpl().schema(new SchemaImpl()))));
            }
            for (MediaType mediaType : workingOperation.getRequestBody().getContent().getMediaTypes().values()) {
                org.eclipse.microprofile.openapi.models.media.Schema schema = mediaType.getSchema();
                if (schema == null) continue;
                schema.setType(formSchemaType);
            }
        }
    }

    @Override
    public void visitHeaderParam(AnnotationModel param, AnnotatedElement element, ApiContext context) {
        ApplicationProcessor.addParameter(element, context, (String)param.getValue("value", String.class), Parameter.In.HEADER, null);
    }

    @Override
    public void visitCookieParam(AnnotationModel param, AnnotatedElement element, ApiContext context) {
        ApplicationProcessor.addParameter(element, context, (String)param.getValue("value", String.class), Parameter.In.COOKIE, null);
    }

    private static void addParameter(AnnotatedElement element, ApiContext context, String name, Parameter.In in, Boolean required) {
        Boolean hidden = false;
        AnnotationModel paramAnnotation = element.getAnnotation(org.eclipse.microprofile.openapi.annotations.parameters.Parameter.class.getName());
        if (paramAnnotation != null) {
            hidden = (Boolean)paramAnnotation.getValue("hidden", Boolean.class);
        }
        if (hidden != null && hidden.booleanValue()) {
            return;
        }
        ParameterImpl newParameter = new ParameterImpl();
        newParameter.setName(name);
        newParameter.setIn(in);
        newParameter.setRequired(required);
        SchemaImpl schema = new SchemaImpl();
        String defaultValue = ApplicationProcessor.getDefaultValueIfPresent(element);
        if (element instanceof org.glassfish.hk2.classmodel.reflect.Parameter) {
            org.glassfish.hk2.classmodel.reflect.Parameter parameter = (org.glassfish.hk2.classmodel.reflect.Parameter)element;
            schema.setType(ModelUtils.getSchemaType(parameter.getTypeName(), context));
        } else {
            FieldModel field = (FieldModel)element;
            schema.setType(ModelUtils.getSchemaType(field.getTypeName(), context));
        }
        if (schema.getType() == Schema.SchemaType.ARRAY) {
            schema.setItems(ApplicationProcessor.getArraySchema(element, context));
            if (defaultValue != null) {
                schema.getItems().setDefaultValue((Object)defaultValue);
            }
        } else if (defaultValue != null) {
            schema.setDefaultValue(defaultValue);
        }
        newParameter.setSchema(schema);
        Operation workingOperation = context.getWorkingOperation();
        if (workingOperation != null) {
            for (Parameter parameter : workingOperation.getParameters()) {
                String parameterName = parameter.getName();
                if (parameterName == null || !parameterName.equals(newParameter.getName())) continue;
                ParameterImpl.merge(newParameter, parameter, false, context);
                return;
            }
            workingOperation.addParameter((Parameter)newParameter);
        } else {
            LOGGER.log(Level.SEVERE, "Couldn''t add {0} parameter, \"{1}\" to the OpenAPI Document. This is usually caused by declaring parameter under a method with an unsupported annotation.", new Object[]{newParameter.getIn(), newParameter.getName()});
        }
    }

    private static SchemaImpl getArraySchema(AnnotatedElement element, ApiContext context) {
        List parameterizedType;
        SchemaImpl arraySchema = new SchemaImpl();
        if (element instanceof org.glassfish.hk2.classmodel.reflect.Parameter) {
            org.glassfish.hk2.classmodel.reflect.Parameter parameter = (org.glassfish.hk2.classmodel.reflect.Parameter)element;
            parameterizedType = parameter.getParameterizedTypes();
        } else {
            FieldModel field = (FieldModel)element;
            parameterizedType = field.getParameterizedTypes();
        }
        arraySchema.setType(ModelUtils.getSchemaType(((ParameterizedType)parameterizedType.get(0)).getTypeName(), context));
        return arraySchema;
    }

    private static String getDefaultValueIfPresent(AnnotatedElement element) {
        Collection annotations = element.getAnnotations();
        for (AnnotationModel annotation : annotations) {
            if (!DefaultValue.class.getName().equals(annotation.getType().getName())) continue;
            try {
                return (String)annotation.getValue("value", String.class);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Couldn't get the default value", ex);
            }
        }
        return null;
    }

    @Override
    public void visitOpenAPI(AnnotationModel definition, AnnotatedElement element, ApiContext context) {
        OpenAPIImpl.merge(OpenAPIImpl.createInstance(definition, context), context.getApi(), true, context);
    }

    @Override
    public void visitSchema(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        if (element instanceof ClassModel) {
            this.visitSchemaClass(null, annotation, (ClassModel)element, Collections.emptyList(), context);
        } else if (element instanceof EnumType) {
            this.vistEnumClass(annotation, (EnumType)element, context);
        } else if (element instanceof FieldModel) {
            this.visitSchemaField(annotation, (FieldModel)element, context);
        } else if (element instanceof MethodModel) {
            this.visitSchemaMethod(annotation, (MethodModel)element, context);
        } else if (element instanceof org.glassfish.hk2.classmodel.reflect.Parameter) {
            ApplicationProcessor.visitSchemaParameter(annotation, (org.glassfish.hk2.classmodel.reflect.Parameter)element, context);
        }
    }

    private void vistEnumClass(AnnotationModel schemaAnnotation, EnumType enumType, ApiContext context) {
        String schemaName = ModelUtils.getSchemaName(context, (AnnotatedElement)enumType);
        SchemaImpl schema = SchemaImpl.createInstance(schemaAnnotation, context);
        SchemaImpl newSchema = new SchemaImpl();
        context.getApi().getComponents().addSchema(schemaName, (org.eclipse.microprofile.openapi.models.media.Schema)newSchema);
        if (schema != null) {
            SchemaImpl.merge(schema, newSchema, true, context);
        }
        if (schema == null || schema.getEnumeration() == null || schema.getEnumeration().isEmpty()) {
            for (FieldModel enumField : enumType.getStaticFields()) {
                String enumValue = enumField.getName();
                if (enumValue.contains("$VALUES")) continue;
                newSchema.addEnumeration(enumValue);
            }
        }
    }

    private org.eclipse.microprofile.openapi.models.media.Schema visitSchemaClass(org.eclipse.microprofile.openapi.models.media.Schema schema, AnnotationModel schemaAnnotation, ClassModel clazz, Collection<ParameterizedInterfaceModel> parameterizedInterfaces, ApiContext context) {
        ClassModel superClass;
        String schemaName = ModelUtils.getSchemaName(context, (AnnotatedElement)clazz);
        if (schema == null) {
            Components components = context.getApi().getComponents();
            schema = components.getSchemas().getOrDefault(schemaName, new SchemaImpl());
            components.addSchema(schemaName, schema);
        }
        if (schemaAnnotation != null) {
            SchemaImpl.merge(SchemaImpl.createInstance(schemaAnnotation, context), schema, false, context);
        }
        for (FieldModel field : clazz.getFields()) {
            String fieldName = field.getName();
            Boolean hidden = false;
            AnnotationModel fieldSchemaAnnotation = field.getAnnotation(Schema.class.getName());
            if (fieldSchemaAnnotation != null) {
                hidden = (Boolean)fieldSchemaAnnotation.getValue("hidden", Boolean.class);
            }
            if (Boolean.TRUE.equals(hidden) || field.isTransient() || fieldName.startsWith("this$")) continue;
            org.eclipse.microprofile.openapi.models.media.Schema existingProperty = (org.eclipse.microprofile.openapi.models.media.Schema)schema.getProperties().get(fieldName);
            org.eclipse.microprofile.openapi.models.media.Schema newProperty = this.createSchema(null, context, (ParameterizedType)field, (ExtensibleType)clazz, parameterizedInterfaces);
            if (existingProperty != null) {
                SchemaImpl.merge(existingProperty, newProperty, true, context);
            }
            schema.addProperty(fieldName, newProperty);
        }
        if (schema.getType() == null) {
            schema.setType(ModelUtils.getSchemaType(clazz.getName(), context));
        }
        if ((superClass = (ClassModel)clazz.getParent()) != null && !superClass.getName().startsWith("java.")) {
            AnnotationModel parentSchemAnnotation = context.getAnnotationInfo((ExtensibleType<? extends ExtensibleType>)superClass).getAnnotation(Schema.class);
            ParameterizedInterfaceModel parameterizedInterface = clazz.getParameterizedInterface((ExtensibleType)superClass);
            if (parameterizedInterface == null) {
                org.eclipse.microprofile.openapi.models.media.Schema parentSchema = this.visitSchemaClass(null, parentSchemAnnotation, superClass, Collections.emptyList(), context);
                String parentSchemaName = ModelUtils.getSchemaName(context, (AnnotatedElement)superClass);
                schema.addAllOf((org.eclipse.microprofile.openapi.models.media.Schema)new SchemaImpl().ref(parentSchemaName));
                for (Map.Entry property : parentSchema.getProperties().entrySet()) {
                    schema.addProperty((String)property.getKey(), (org.eclipse.microprofile.openapi.models.media.Schema)property.getValue());
                }
            } else {
                this.visitSchemaClass(schema, parentSchemAnnotation, superClass, parameterizedInterface.getParametizedTypes(), context);
            }
        }
        return schema;
    }

    private void visitSchemaMethod(AnnotationModel schemaAnnotation, MethodModel method, ApiContext context) {
        ExtensibleType declaringType = method.getDeclaringType();
        String methodName = method.getName();
        String typeName = methodName.toLowerCase().contains("set") ? method.getArgumentTypes()[0] : method.getReturnType().getTypeName();
        this.visitSchemaFieldOrMethod(schemaAnnotation, (AnnotatedElement)method, declaringType, typeName, context);
    }

    private void visitSchemaField(AnnotationModel schemaAnnotation, FieldModel field, ApiContext context) {
        ExtensibleType declaringType = field.getDeclaringType();
        String typeName = field.getTypeName();
        this.visitSchemaFieldOrMethod(schemaAnnotation, (AnnotatedElement)field, declaringType, typeName, context);
    }

    private void visitSchemaFieldOrMethod(AnnotationModel schemaAnnotation, AnnotatedElement fieldOrMethod, ExtensibleType<?> declaringType, String typeName, ApiContext context) {
        assert (fieldOrMethod instanceof FieldModel || fieldOrMethod instanceof MethodModel);
        Boolean hidden = (Boolean)schemaAnnotation.getValue("hidden", Boolean.class);
        if (hidden == null || !hidden.booleanValue()) {
            String schemaName = ModelUtils.getSchemaName(context, fieldOrMethod);
            SchemaImpl schema = SchemaImpl.createInstance(schemaAnnotation, context);
            String parentName = null;
            AnnotationModel classSchemaAnnotation = context.getAnnotationInfo(declaringType).getAnnotation(Schema.class);
            if (classSchemaAnnotation != null) {
                parentName = (String)classSchemaAnnotation.getValue("name", String.class);
            }
            if (parentName == null || parentName.isEmpty()) {
                parentName = declaringType.getSimpleName();
            }
            Components components = context.getApi().getComponents();
            org.eclipse.microprofile.openapi.models.media.Schema parentSchema = components.getSchemas().getOrDefault(parentName, new SchemaImpl());
            components.addSchema(parentName, parentSchema);
            org.eclipse.microprofile.openapi.models.media.Schema property = parentSchema.getProperties().getOrDefault(schemaName, new SchemaImpl());
            parentSchema.addProperty(schemaName, property);
            if (schema.isRequired()) {
                parentSchema.addRequired(schemaName);
            }
            if (property.getRef() == null) {
                property.setType(ModelUtils.getSchemaType(typeName, context));
            }
            SchemaImpl.merge(schema, property, true, context);
        }
    }

    private static void visitSchemaParameter(AnnotationModel schemaAnnotation, org.glassfish.hk2.classmodel.reflect.Parameter parameter, ApiContext context) {
        if (context.getWorkingOperation() == null) {
            return;
        }
        if (ModelUtils.isRequestBody(context, parameter)) {
            if (context.getWorkingOperation().getRequestBody() == null) {
                context.getWorkingOperation().setRequestBody((RequestBody)new RequestBodyImpl());
            }
            MediaType mediaType = context.getWorkingOperation().getRequestBody().getContent().getMediaType("*/*");
            SchemaImpl schema = SchemaImpl.createInstance(schemaAnnotation, context);
            SchemaImpl.merge(schema, mediaType.getSchema(), true, context);
            if (schema.getRef() != null && !schema.getRef().isEmpty()) {
                mediaType.setSchema((org.eclipse.microprofile.openapi.models.media.Schema)new SchemaImpl().ref(schema.getRef()));
            }
        } else if (ModelUtils.getParameterType(context, parameter) != null) {
            for (Parameter param : context.getWorkingOperation().getParameters()) {
                if (!param.getName().equals(ModelUtils.getParameterName(context, parameter))) continue;
                SchemaImpl schema = SchemaImpl.createInstance(schemaAnnotation, context);
                SchemaImpl.merge(schema, param.getSchema(), true, context);
                if (schema.getRef() == null || schema.getRef().isEmpty()) continue;
                param.setSchema((org.eclipse.microprofile.openapi.models.media.Schema)new SchemaImpl().ref(schema.getRef()));
            }
        }
    }

    @Override
    public void visitExtension(AnnotationModel extension, AnnotatedElement element, ApiContext context) {
        String value = (String)extension.getValue("value", String.class);
        String name = (String)extension.getValue("name", String.class);
        Boolean parseValue = (Boolean)extension.getValue("parseValue", Boolean.class);
        if (name != null && !name.isEmpty() && value != null && !value.isEmpty()) {
            Object parsedValue = ExtensibleImpl.convertExtensionValue(value, parseValue);
            if (element instanceof MethodModel) {
                context.getWorkingOperation().addExtension(name, parsedValue);
            } else {
                context.getApi().addExtension(name, parsedValue);
            }
        }
    }

    @Override
    public void visitExtensions(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        List extensions = (List)annotation.getValue("value", List.class);
        if (extensions != null) {
            extensions.forEach(extension -> this.visitExtension((AnnotationModel)extension, element, context));
        }
    }

    @Override
    public void visitOperation(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        OperationImpl.merge(OperationImpl.createInstance(annotation, context), context.getWorkingOperation(), true);
        Boolean hidden = (Boolean)annotation.getValue("hidden", Boolean.class);
        if (hidden != null && hidden.booleanValue()) {
            ModelUtils.removeOperation(context.getApi().getPaths().getPathItem(context.getPath()), context.getWorkingOperation());
        }
    }

    @Override
    public void visitCallback(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        if (element instanceof MethodModel) {
            String name = (String)annotation.getValue("name", String.class);
            Callback callbackModel = context.getWorkingOperation().getCallbacks().getOrDefault(name, new CallbackImpl());
            context.getWorkingOperation().addCallback(name, callbackModel);
            CallbackImpl.merge(CallbackImpl.createInstance(annotation, context), callbackModel, true, context);
        }
    }

    @Override
    public void visitCallbacks(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        List callbacks = (List)annotation.getValue("value", List.class);
        if (callbacks != null) {
            callbacks.forEach(callback -> this.visitCallback((AnnotationModel)callback, element, context));
        }
    }

    @Override
    public void visitRequestBody(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        RequestBody currentRequestBody;
        if ((element instanceof MethodModel || element instanceof org.glassfish.hk2.classmodel.reflect.Parameter) && ((currentRequestBody = context.getWorkingOperation().getRequestBody()) != null || element instanceof org.glassfish.hk2.classmodel.reflect.Parameter)) {
            RequestBodyImpl.merge(RequestBodyImpl.createInstance(annotation, context), currentRequestBody, true, context);
        }
    }

    @Override
    public void visitRequestBodySchema(AnnotationModel requestBodySchema, AnnotatedElement element, ApiContext context) {
        RequestBody currentRequestBody;
        if ((element instanceof MethodModel || element instanceof org.glassfish.hk2.classmodel.reflect.Parameter) && (currentRequestBody = context.getWorkingOperation().getRequestBody()) != null) {
            String implementationClass = (String)requestBodySchema.getValue("value", String.class);
            SchemaImpl schema = SchemaImpl.fromImplementation(implementationClass, context);
            for (MediaType mediaType : currentRequestBody.getContent().getMediaTypes().values()) {
                mediaType.setSchema((org.eclipse.microprofile.openapi.models.media.Schema)schema);
            }
        }
    }

    @Override
    public void visitAPIResponse(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        APIResponseImpl apiResponse = APIResponseImpl.createInstance(annotation, context);
        Operation workingOperation = context.getWorkingOperation();
        if (workingOperation == null) {
            if (element instanceof MethodModel && "toResponse".equals(element.getName())) {
                MethodModel methodModel = (MethodModel)element;
                String exceptionType = methodModel.getParameter(0).getTypeName();
                this.mapException(context, exceptionType, apiResponse);
            } else {
                LOGGER.warning("Unrecognised annotation position at: " + element.shortDesc());
            }
            return;
        }
        APIResponsesImpl.merge(apiResponse, workingOperation.getResponses(), true, context);
        String responseCode = apiResponse.getResponseCode();
        if (responseCode != null && !responseCode.isEmpty() && !responseCode.equals("default")) {
            AnnotationModel apiResponsesParent = element.getAnnotation(APIResponses.class.getName());
            if (apiResponsesParent != null) {
                List apiResponses = (List)apiResponsesParent.getValue("value", List.class);
                if (apiResponses.stream().map(a -> (String)a.getValue("responseCode", String.class)).noneMatch(code -> code == null || code.isEmpty() || code.equals("default"))) {
                    workingOperation.getResponses().removeAPIResponse("default");
                }
            } else {
                workingOperation.getResponses().removeAPIResponse("default");
            }
        }
    }

    @Override
    public void visitAPIResponses(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        List responses = (List)annotation.getValue("value", List.class);
        if (responses != null) {
            responses.forEach(response -> this.visitAPIResponse((AnnotationModel)response, element, context));
        }
    }

    @Override
    public void visitAPIResponseSchema(AnnotationModel apiResponseSchema, AnnotatedElement element, ApiContext context) {
        org.eclipse.microprofile.openapi.models.responses.APIResponses responses;
        APIResponse defaultResponse;
        APIResponseImpl response = APIResponseImpl.createInstance(apiResponseSchema, context);
        OperationImpl operation = (OperationImpl)context.getWorkingOperation();
        if (operation == null) {
            if (element instanceof MethodModel && "toResponse".equals(element.getName())) {
                MethodModel methodModel = (MethodModel)element;
                String exceptionType = methodModel.getParameter(0).getTypeName();
                this.mapException(context, exceptionType, response);
            } else {
                LOGGER.warning("Unrecognised annotation position at: " + element.shortDesc());
            }
            return;
        }
        String responseCode = response.getResponseCode();
        if (responseCode == null || responseCode.isEmpty()) {
            assert (element instanceof MethodModel);
            MethodModel method = (MethodModel)element;
            responseCode = ModelUtils.isVoid(method.getReturnType()) ? ("POST".equals(operation.getMethod()) ? "201" : (Arrays.asList(method.getArgumentTypes()).contains("javax.ws.rs.container.AsyncResponse") ? "200" : "204")) : "200";
        }
        response.setResponseCode(responseCode);
        String responseDescription = response.getDescription();
        if (responseDescription == null || responseDescription.isEmpty()) {
            try {
                int statusInt = Integer.parseInt(responseCode);
                Response.Status status = Response.Status.fromStatusCode((int)statusInt);
                if (status != null) {
                    response.setDescription(status.getReasonPhrase());
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINE, "Unrecognised status code, description will be empty", ex);
            }
        }
        if ((defaultResponse = (responses = operation.getResponses()).getAPIResponse("default")) != null) {
            responses.removeAPIResponse("default");
            responses.addAPIResponse(responseCode, defaultResponse);
        }
        APIResponsesImpl.merge(response, responses, true, context);
    }

    private void mapException(ApiContext context, String exceptionType, APIResponseImpl exceptionResponse) {
        if (exceptionResponse.getDescription() == null || exceptionResponse.getDescription().isEmpty()) {
            exceptionResponse.setDescription(ModelUtils.getSimpleName(exceptionType));
        }
        context.addMappedExceptionResponse(exceptionType, exceptionResponse);
        String exceptionStatus = exceptionResponse.getResponseCode();
        if (exceptionStatus != null) {
            for (PathItem path : context.getApi().getPaths().getPathItems().values()) {
                for (Operation operation : path.getOperations().values()) {
                    if (!((OperationImpl)operation).getExceptionTypes().contains(exceptionType)) continue;
                    operation.getResponses().addAPIResponse(exceptionStatus, (APIResponse)exceptionResponse);
                }
            }
        } else {
            LOGGER.fine("Failed to add mapped response as no response code was provided");
        }
    }

    @Override
    public void visitParameters(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        List parameters = (List)annotation.getValue("value", List.class);
        if (parameters != null) {
            for (AnnotationModel paramAnnotation : parameters) {
                Parameter parameter = ParameterImpl.createInstance(paramAnnotation, context);
                Operation workingOperation = context.getWorkingOperation();
                if (workingOperation == null) continue;
                workingOperation.addParameter(parameter);
            }
        }
    }

    @Override
    public void visitParameter(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        Parameter matchedParam = null;
        Boolean hidden = (Boolean)annotation.getValue("hidden", Boolean.class);
        if (hidden != null && hidden.booleanValue()) {
            return;
        }
        Parameter parameter = ParameterImpl.createInstance(annotation, context);
        if (element instanceof org.glassfish.hk2.classmodel.reflect.Parameter) {
            matchedParam = ApplicationProcessor.findOperationParameterFor((org.glassfish.hk2.classmodel.reflect.Parameter)element, context);
        }
        if (element instanceof MethodModel) {
            matchedParam = ApplicationProcessor.findOperationParameterFor(parameter, (MethodModel)element, context);
        }
        if (matchedParam != null) {
            ParameterImpl.merge(parameter, matchedParam, true, context);
            if (matchedParam.getContent() != null && !matchedParam.getContent().getMediaTypes().isEmpty() && matchedParam.getSchema() != null && matchedParam.getSchema().getType() != null) {
                Schema.SchemaType type = matchedParam.getSchema().getType();
                matchedParam.setSchema(null);
                for (MediaType mediaType : matchedParam.getContent().getMediaTypes().values()) {
                    if (mediaType.getSchema() == null) {
                        mediaType.setSchema((org.eclipse.microprofile.openapi.models.media.Schema)new SchemaImpl());
                    }
                    mediaType.getSchema().setType(ModelUtils.mergeProperty(mediaType.getSchema().getType(), type, false));
                }
            }
        }
    }

    private static Parameter findOperationParameterFor(Parameter parameter, MethodModel annotated, ApiContext context) {
        String name = parameter.getName();
        if (name != null && !name.isEmpty()) {
            List matchingMethodParameters = annotated.getParameters().stream().filter(x -> name.equals(ModelUtils.getParameterName(context, x))).collect(Collectors.toList());
            Parameter.In in = parameter.getIn();
            if (matchingMethodParameters.size() > 1 && in != null) {
                matchingMethodParameters.removeIf(x -> ModelUtils.getParameterType(context, x) != Parameter.In.valueOf((String)in.name()));
            }
            if (matchingMethodParameters.isEmpty()) {
                return null;
            }
            String matchingMethodParamName = ModelUtils.getParameterName(context, (org.glassfish.hk2.classmodel.reflect.Parameter)matchingMethodParameters.get(0));
            for (Parameter operationParam : context.getWorkingOperation().getParameters()) {
                if (!operationParam.getName().equals(matchingMethodParamName)) continue;
                return operationParam;
            }
        }
        return null;
    }

    private static Parameter findOperationParameterFor(org.glassfish.hk2.classmodel.reflect.Parameter annotated, ApiContext context) {
        String actualName = ModelUtils.getParameterName(context, annotated);
        if (actualName == null) {
            return null;
        }
        for (Parameter param : context.getWorkingOperation().getParameters()) {
            if (!actualName.equals(param.getName())) continue;
            return param;
        }
        return null;
    }

    @Override
    public void visitExternalDocumentation(AnnotationModel externalDocs, AnnotatedElement element, ApiContext context) {
        if (element instanceof MethodModel) {
            ExternalDocumentationImpl newExternalDocs = new ExternalDocumentationImpl();
            ExternalDocumentationImpl.merge(ExternalDocumentationImpl.createInstance(externalDocs), newExternalDocs, true);
            if (newExternalDocs.getUrl() != null && !newExternalDocs.getUrl().isEmpty()) {
                context.getWorkingOperation().setExternalDocs((ExternalDocumentation)newExternalDocs);
            }
        }
    }

    @Override
    public void visitServer(AnnotationModel server, AnnotatedElement element, ApiContext context) {
        if (element instanceof MethodModel) {
            ServerImpl newServer = new ServerImpl();
            context.getWorkingOperation().addServer((Server)newServer);
            ServerImpl.merge(ServerImpl.createInstance(server, context), newServer, true);
        }
    }

    @Override
    public void visitServers(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        List servers = (List)annotation.getValue("value", List.class);
        if (servers != null) {
            servers.forEach(server -> this.visitServer((AnnotationModel)server, element, context));
        }
    }

    @Override
    public void visitTag(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        Tag from = TagImpl.createInstance(annotation, context);
        if (element instanceof MethodModel) {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.addAll(context.getApi().getTags());
            TagImpl.merge(from, context.getWorkingOperation(), true, tags);
            context.getApi().setTags(tags);
        } else {
            TagImpl newTag = new TagImpl();
            TagImpl.merge(from, newTag, true);
            if (newTag.getName() != null && !newTag.getName().isEmpty()) {
                context.getApi().addTag((Tag)newTag);
            }
        }
    }

    @Override
    public void visitTags(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        if (element instanceof MethodModel) {
            List refs;
            List tags = (List)annotation.getValue("value", List.class);
            if (tags != null) {
                for (AnnotationModel tag : tags) {
                    this.visitTag(tag, element, context);
                }
            }
            if ((refs = (List)annotation.getValue("refs", List.class)) != null) {
                for (String ref : refs) {
                    if (ref == null || ref.isEmpty()) continue;
                    context.getWorkingOperation().addTag(ref);
                }
            }
        }
    }

    @Override
    public void visitSecurityScheme(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        String securitySchemeName = (String)annotation.getValue("securitySchemeName", String.class);
        SecurityScheme securityScheme = SecuritySchemeImpl.createInstance(annotation, context);
        if (securitySchemeName != null && !securitySchemeName.isEmpty()) {
            SecurityScheme newScheme = context.getApi().getComponents().getSecuritySchemes().getOrDefault(securitySchemeName, new SecuritySchemeImpl());
            context.getApi().getComponents().addSecurityScheme(securitySchemeName, newScheme);
            SecuritySchemeImpl.merge(securityScheme, newScheme, true);
        }
    }

    @Override
    public void visitSecuritySchemes(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        List securitySchemes = (List)annotation.getValue("value", List.class);
        if (securitySchemes != null) {
            securitySchemes.forEach(securityScheme -> this.visitSecurityScheme((AnnotationModel)securityScheme, element, context));
        }
    }

    @Override
    public void visitSecurityRequirement(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        if (element instanceof MethodModel) {
            String securityRequirementName = (String)annotation.getValue("name", String.class);
            SecurityRequirement securityRequirement = SecurityRequirementImpl.createInstance(annotation, context);
            if (securityRequirementName != null && !securityRequirementName.isEmpty()) {
                SecurityRequirementImpl model = new SecurityRequirementImpl();
                SecurityRequirementImpl.merge(securityRequirement, model);
                context.getWorkingOperation().addSecurityRequirement((SecurityRequirement)model);
            }
        }
    }

    @Override
    public void visitSecurityRequirements(AnnotationModel annotation, AnnotatedElement element, ApiContext context) {
        List securityRequirements = (List)annotation.getValue("value", List.class);
        if (securityRequirements != null) {
            securityRequirements.forEach(securityRequirement -> this.visitSecurityRequirement((AnnotationModel)securityRequirement, element, context));
        }
    }

    private RequestBody insertDefaultRequestBody(ApiContext context, Operation operation, MethodModel method) {
        RequestBodyImpl requestBody = new RequestBodyImpl();
        org.glassfish.hk2.classmodel.reflect.Parameter bodyType = null;
        for (org.glassfish.hk2.classmodel.reflect.Parameter methodParam : method.getParameters()) {
            if (!ModelUtils.isRequestBody(context, methodParam)) continue;
            bodyType = methodParam;
            break;
        }
        if (bodyType == null) {
            return null;
        }
        MediaType mediaType = new MediaTypeImpl().schema(this.createSchema(context, (ParameterizedType)bodyType));
        requestBody.getContent().addMediaType("*/*", mediaType);
        operation.setRequestBody((RequestBody)requestBody);
        return requestBody;
    }

    private void insertDefaultResponse(ApiContext context, OperationImpl operation, MethodModel method) {
        APIResponsesImpl responses = new APIResponsesImpl();
        operation.setResponses(responses);
        APIResponseImpl defaultResponse = new APIResponseImpl();
        responses.addAPIResponse("default", defaultResponse);
        defaultResponse.setDescription("Default Response.");
        MediaType mediaType = new MediaTypeImpl().schema(this.createSchema(context, method.getReturnType()));
        defaultResponse.getContent().addMediaType("*/*", mediaType);
        for (String exceptionType : method.getExceptionTypes()) {
            String responseCode;
            APIResponseImpl mappedResponse = (APIResponseImpl)context.getMappedExceptionResponses().get(exceptionType);
            if (mappedResponse != null && (responseCode = mappedResponse.getResponseCode()) != null) {
                responses.addAPIResponse(responseCode, mappedResponse);
            }
            operation.addExceptionType(exceptionType);
        }
    }

    private static String getContentType(String name) {
        String contentType = "*/*";
        try {
            javax.ws.rs.core.MediaType mediaType = javax.ws.rs.core.MediaType.valueOf((String)name);
            if (mediaType != null) {
                contentType = mediaType.toString();
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.FINE, "Unrecognised content type.", ex);
        }
        return contentType;
    }

    private org.eclipse.microprofile.openapi.models.media.Schema createSchema(ApiContext context, ParameterizedType type) {
        return this.createSchema(null, context, type);
    }

    private org.eclipse.microprofile.openapi.models.media.Schema createSchema(org.eclipse.microprofile.openapi.models.media.Schema schema, ApiContext context, ParameterizedType type) {
        AnnotatedElement element;
        AnnotationModel schemaAnnotation;
        String typeName = type.getTypeName();
        List genericTypes = type.getParameterizedTypes();
        Schema.SchemaType schemaType = ModelUtils.getSchemaType(type, context);
        if (schema == null) {
            schema = new SchemaImpl();
            schema.setType(schemaType);
        }
        if (schemaType == Schema.SchemaType.ARRAY) {
            if (type.isArray()) {
                schemaType = ModelUtils.getSchemaType(type.getTypeName(), context);
                schema.setType(schemaType);
            } else if (!genericTypes.isEmpty()) {
                schema.setItems(this.createSchema(context, (ParameterizedType)genericTypes.get(0)));
            }
        }
        if (schemaType == Schema.SchemaType.OBJECT && this.insertObjectReference(context, (Reference<?>)schema, (AnnotatedElement)type.getType(), typeName)) {
            schema.setType(null);
            schema.setItems(null);
        }
        if (type instanceof AnnotatedElement && (schemaAnnotation = (element = (AnnotatedElement)type).getAnnotation(Schema.class.getName())) != null) {
            SchemaImpl.merge(SchemaImpl.createInstance(schemaAnnotation, context), schema, false, context);
        }
        return schema;
    }

    private org.eclipse.microprofile.openapi.models.media.Schema createSchema(org.eclipse.microprofile.openapi.models.media.Schema schema, ApiContext context, ParameterizedType type, ExtensibleType clazz, Collection<ParameterizedInterfaceModel> classParameterizedTypes) {
        Schema.SchemaType schemaType;
        if (schema == null) {
            schema = new SchemaImpl();
        }
        if ((schemaType = ModelUtils.getSchemaType(type, context)) == Schema.SchemaType.OBJECT && type.getType() != null && type.getType().equals(clazz)) {
            schema.setType(null);
            schema.setItems(null);
            return schema;
        }
        if (type.getType() == null) {
            ParameterizedInterfaceModel classParameterizedType = this.findParameterizedModelFromGenerics((ExtensibleType<? extends ExtensibleType>)clazz, classParameterizedTypes, type);
            String typeName = null;
            if (type.getTypeName() != null) {
                typeName = type.getTypeName();
            }
            if ((typeName == null || Object.class.getName().equals(typeName)) && classParameterizedType != null) {
                typeName = classParameterizedType.getRawInterfaceName();
            }
            schemaType = ModelUtils.getSchemaType(typeName, context);
            if (schema.getType() == null) {
                schema.setType(schemaType);
            }
            org.eclipse.microprofile.openapi.models.media.Schema containerSchema = schema;
            if (schemaType == Schema.SchemaType.ARRAY) {
                containerSchema = new SchemaImpl();
                schema.setItems(containerSchema);
            }
            if (classParameterizedType != null) {
                Collection genericTypes = classParameterizedType.getParametizedTypes();
                if (genericTypes.isEmpty()) {
                    if (this.insertObjectReference(context, (Reference<?>)containerSchema, (AnnotatedElement)classParameterizedType.getRawInterface(), classParameterizedType.getRawInterfaceName())) {
                        containerSchema.setType(null);
                        containerSchema.setItems(null);
                    }
                } else if (classParameterizedType.getRawInterface() instanceof ClassModel) {
                    this.visitSchemaClass(containerSchema, null, (ClassModel)classParameterizedType.getRawInterface(), genericTypes, context);
                } else {
                    LOGGER.log(Level.FINE, "Unrecognised schema {0} class found.", new Object[]{classParameterizedType.getRawInterface()});
                }
            } else if (!type.getParameterizedTypes().isEmpty()) {
                List genericTypes = type.getParameterizedTypes();
                if (ModelUtils.isMap(typeName, context) && genericTypes.size() == 2) {
                    this.createSchema(containerSchema, context, (ParameterizedType)genericTypes.get(0), clazz, classParameterizedTypes);
                    containerSchema = new SchemaImpl();
                    schema.setAdditionalPropertiesSchema(containerSchema);
                    this.createSchema(containerSchema, context, (ParameterizedType)genericTypes.get(1), clazz, classParameterizedTypes);
                } else {
                    this.createSchema(containerSchema, context, (ParameterizedType)genericTypes.get(0), clazz, classParameterizedTypes);
                }
            } else {
                return this.createSchema(containerSchema, context, type);
            }
            return schema;
        }
        return this.createSchema(schema, context, type);
    }

    private ParameterizedInterfaceModel findParameterizedModelFromGenerics(ExtensibleType<? extends ExtensibleType> annotatedElement, Collection<ParameterizedInterfaceModel> parameterizedModels, ParameterizedType genericType) {
        if (parameterizedModels == null || parameterizedModels.isEmpty()) {
            return null;
        }
        ArrayList formalParamKeys = new ArrayList(annotatedElement.getFormalTypeParameters().keySet());
        int i = 0;
        for (ParameterizedInterfaceModel parameterizedModel : parameterizedModels) {
            if (((String)formalParamKeys.get(i)).equals(genericType.getFormalType())) {
                return parameterizedModel;
            }
            ++i;
        }
        return null;
    }

    private boolean insertObjectReference(ApiContext context, Reference<?> referee, AnnotatedElement referenceClass, String referenceClassName) {
        for (Map.Entry schemaEntry : context.getApi().getComponents().getSchemas().entrySet()) {
            SchemaImpl entryValueImpl;
            String implementationClass;
            org.eclipse.microprofile.openapi.models.media.Schema entryValue = (org.eclipse.microprofile.openapi.models.media.Schema)schemaEntry.getValue();
            if (!(entryValue instanceof SchemaImpl) || (implementationClass = (entryValueImpl = (SchemaImpl)entryValue).getImplementation()) == null || !implementationClass.equals(referenceClassName)) continue;
            referee.setRef((String)schemaEntry.getKey());
            return true;
        }
        if (referenceClassName == null || referenceClassName.startsWith("java.")) {
            return false;
        }
        if (referenceClassName.startsWith("javax.")) {
            return false;
        }
        if (!context.isApplicationType(referenceClassName)) {
            return false;
        }
        if (referenceClass != null && referenceClass instanceof ExtensibleType) {
            ExtensibleType referenceClassType = (ExtensibleType)referenceClass;
            AnnotationModel schemaAnnotation = context.getAnnotationInfo((ExtensibleType<? extends ExtensibleType>)referenceClassType).getAnnotation(Schema.class);
            String schemaName = ModelUtils.getSchemaName(context, referenceClass);
            referee.setRef(schemaName);
            org.eclipse.microprofile.openapi.models.media.Schema schema = (org.eclipse.microprofile.openapi.models.media.Schema)context.getApi().getComponents().getSchemas().get(schemaName);
            if (schema == null) {
                if (context.isAllowedType((Type)referenceClassType)) {
                    this.visitSchema(schemaAnnotation, (AnnotatedElement)referenceClassType, context);
                } else if (referenceClassType instanceof ClassModel) {
                    this.apiWalker.processAnnotation((ClassModel)referenceClassType, this);
                } else {
                    LOGGER.log(Level.FINE, "Unrecognised schema {0} class found.", new Object[]{referenceClassName});
                }
            }
            return true;
        }
        return false;
    }
}

