/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.admin.rest.resources.AbstractAttributeBagResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.config.support.TranslatedConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;

public class MonitoredMetricAttributeBagResource
extends AbstractAttributeBagResource {
    public static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(MonitoredMetricAttributeBagResource.class);

    @Override
    public String getDescriptionName() {
        return "monitored-metric";
    }

    @Override
    public String getPropertiesName() {
        return "monitoredMetrics";
    }

    @Override
    public String getnodeElementName() {
        return "monitored-metrics";
    }

    @Override
    public List<Map<String, String>> getAllAttributes() {
        ArrayList<Map<String, String>> attributes = new ArrayList<Map<String, String>>();
        for (Dom child : this.entity) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("metricName", child.attribute("metric-name"));
            String description = child.attribute("description");
            if (description != null) {
                entry.put("description", description);
            }
            attributes.add(entry);
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void excuteSetCommand(List<Map<String, String>> attributesToAdd, List<Map<String, String>> attributesToDelete) throws TransactionFailure {
        try {
            RestActionReporter reporter;
            HashMap<String, String> parameters;
            for (Map<String, String> attribute : attributesToAdd) {
                parameters = new HashMap<String, String>();
                parameters.put("add-metric", String.format("metricName=%s description=%s", attribute.get("metricName"), attribute.get("description")));
                parameters.put("service", "mp-metrics");
                reporter = ResourceUtil.runCommand("set-healthcheck-service-configuration", parameters, this.getSubject());
                if (!reporter.isFailure()) continue;
                throw new TransactionFailure(reporter.getMessage());
            }
            for (Map<String, String> attribute : attributesToDelete) {
                parameters = new HashMap();
                parameters.put("delete-metric", String.format("metricName=%s", attribute.get("metricName")));
                parameters.put("service", "mp-metrics");
                reporter = ResourceUtil.runCommand("set-healthcheck-service-configuration", parameters, this.getSubject());
                if (!reporter.isFailure()) continue;
                throw new TransactionFailure(reporter.getMessage());
            }
        }
        finally {
            TranslatedConfigView.doSubstitution.set(true);
        }
    }

    @Override
    public boolean attributesAreEqual(Map<String, String> attribute1, Map<String, String> attribute2) {
        return attribute1.get("metricName").equals(attribute2.get("metricName"));
    }
}

