/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.GetResultList;
import org.jvnet.hk2.config.Dom;

@Provider
@Produces(value={"application/json"})
public class GetResultListJsonProvider
extends BaseProvider<GetResultList> {
    public GetResultListJsonProvider() {
        super(GetResultList.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public String getContent(GetResultList proxy) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        try {
            objectBuilder.add("entity", (JsonValue)JsonValue.EMPTY_JSON_OBJECT);
            objectBuilder.add("methods", (JsonValue)ProviderUtil.getJsonForMethodMetaData(proxy.getMetaData()));
            if (!proxy.getDomList().isEmpty()) {
                objectBuilder.add("childResources", (JsonValue)this.getResourcesLinks(proxy.getDomList()));
            }
            if (proxy.getCommandResourcesPaths().length > 0) {
                objectBuilder.add("commands", (JsonValue)this.getCommandLinks(proxy.getCommandResourcesPaths()));
            }
        }
        catch (JsonException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        return objectBuilder.build().toString();
    }

    private JsonArray getResourcesLinks(List<Dom> proxyList) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (Map.Entry<String, String> link : this.getResourceLinks(proxyList).entrySet()) {
            array.add(link.getValue());
        }
        return array.build();
    }

    private JsonArray getCommandLinks(String[][] commandResourcesPaths) throws JsonException {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (String[] commandResourcePath : commandResourcesPaths) {
            array.add(ProviderUtil.getElementLink((UriInfo)this.uriInfo.get(), commandResourcePath[0]));
        }
        return array.build();
    }
}

