/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import fish.payara.monitoring.collect.MonitoringDataCollection;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.web.admin.LogFacade;
import org.glassfish.web.admin.monitor.HttpServiceStatsProvider;
import org.glassfish.web.admin.monitor.VirtualServerInfoStatsProvider;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigurationException;

@Service(name="http-service")
@Singleton
public class HttpServiceStatsProviderBootstrap
implements PostConstruct,
MonitoringDataSource {
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    private MonitoringService monitoringService;
    private static final Logger logger = LogFacade.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();
    private final Map<String, HttpServiceStatsProvider> httpServiceStatsProviders = new ConcurrentHashMap<String, HttpServiceStatsProvider>();

    public void postConstruct() {
        if (this.config == null) {
            Object[] params = new Object[]{VirtualServerInfoStatsProvider.class.getName(), HttpServiceStatsProvider.class.getName(), "http service", "virtual server"};
            logger.log(Level.SEVERE, "AS-WEB-ADMIN-00001", params);
            throw new ConfigurationException(rb.getString("AS-WEB-ADMIN-00002"));
        }
        HttpService httpService = this.config.getHttpService();
        for (VirtualServer vs : httpService.getVirtualServer()) {
            String id = vs.getId();
            StatsProviderManager.register((String)"http-service", (PluginPoint)PluginPoint.SERVER, (String)("http-service/" + id), (Object)new VirtualServerInfoStatsProvider(vs));
            HttpServiceStatsProvider httpServiceStatsProvider = new HttpServiceStatsProvider(id, vs.getNetworkListeners(), this.config.getNetworkConfig());
            this.httpServiceStatsProviders.put(id, httpServiceStatsProvider);
            StatsProviderManager.register((String)"http-service", (PluginPoint)PluginPoint.SERVER, (String)("http-service/" + id + "/request"), (Object)httpServiceStatsProvider);
        }
    }

    public void collect(MonitoringDataCollector collector) {
        if (!"true".equals(this.monitoringService.getMonitoringEnabled()) || !"HIGH".equals(this.monitoringService.getModuleMonitoringLevels().getHttpService())) {
            return;
        }
        MonitoringDataCollector http = collector.in((CharSequence)"http").prefix((CharSequence)"Server");
        for (HttpServiceStatsProvider provider : this.httpServiceStatsProviders.values()) {
            http.collectObject((Object)provider, MonitoringDataCollection::collectObject);
        }
    }

    static {
        MonitoringDataCollection.register(CountStatistic.class, (collector, count) -> collector.collect((CharSequence)count.getName(), count.getCount()));
    }
}

