/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.monitor.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.ColumnFormatter;
import com.sun.enterprise.util.StringUtils;
import fish.payara.admin.amx.config.AMXConfiguration;
import fish.payara.admin.monitor.cli.SetMonitoringConfiguration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-monitoring-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.monitoring.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get-monitoring-configuration", description="List Payara Monitoring Service Configuration")})
public class GetMonitoringConfiguration
implements AdminCommand {
    private static final Logger logger = Logger.getLogger(SetMonitoringConfiguration.class.getName());
    @Inject
    private Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    private CommandRunner commandRunner;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        ActionReport monitoringServiceReport = actionReport.addSubActionsReport();
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            actionReport.setMessage("No such config named: " + this.target);
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        MonitoringService monitoringService = config.getMonitoringService();
        AMXConfiguration amxConfiguration = (AMXConfiguration)config.getExtensionByType(AMXConfiguration.class);
        CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("get-rest-monitoring-configuration", actionReport, context.getSubject());
        commandInvocation.execute();
        commandInvocation = this.commandRunner.getCommandInvocation("get-jmx-monitoring-configuration", actionReport, context.getSubject());
        commandInvocation.execute();
        String[] headers = new String[]{"Monitoring Enabled", "AMX Enabled", "MBeans Enabled", "DTrace Enabled"};
        ColumnFormatter columnFormatter = new ColumnFormatter(headers);
        columnFormatter.addRow(new Object[]{monitoringService.getMonitoringEnabled(), amxConfiguration.getEnabled(), monitoringService.getMbeanEnabled(), monitoringService.getDtraceEnabled()});
        HashMap<String, String> extraPropertiesMap = new HashMap<String, String>();
        extraPropertiesMap.put("monitoringEnabled", monitoringService.getMonitoringEnabled());
        extraPropertiesMap.put("mbeanEnabled", monitoringService.getMbeanEnabled());
        extraPropertiesMap.put("dtraceEnabled", monitoringService.getDtraceEnabled());
        extraPropertiesMap.put("amxEnabled", amxConfiguration.getEnabled());
        Properties extraProperties = new Properties();
        extraProperties.put("getMonitoringConfiguration", extraPropertiesMap);
        actionReport.setExtraProperties(extraProperties);
        monitoringServiceReport.setMessage(columnFormatter.toString());
        monitoringServiceReport.appendMessage(StringUtils.EOL);
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

