/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParameterizedType;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.impl.AnnotationModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.AnnotationTypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.EnumModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ExtensibleTypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.FieldModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.FieldSignatureVisitorImpl;
import org.glassfish.hk2.classmodel.reflect.impl.MethodModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.MethodSignatureVisitorImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ParameterImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ParameterizedInterfaceModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ParameterizedTypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.SignatureVisitorImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeBuilder;
import org.glassfish.hk2.classmodel.reflect.impl.TypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ModelClassVisitor
extends ClassVisitor {
    private static Logger logger = Logger.getLogger(ModelClassVisitor.class.getName());
    private final ParsingContext ctx;
    private final TypeBuilder typeBuilder;
    private final URI definingURI;
    private final String entryName;
    TypeImpl type;
    boolean deepVisit = false;
    private final ClassVisitingContext classContext;
    private final MemberVisitingContext visitingContext;
    private final ModelFieldVisitor fieldVisitor;
    private final ModelMethodVisitor methodVisitor;
    private final ModelAnnotationVisitor annotationVisitor;
    private final ModelDefaultAnnotationVisitor defaultAnnotationVisitor;
    private static final int discarded = 0;
    private final boolean isApplicationClass;

    public ModelClassVisitor(ParsingContext ctx, URI definingURI, String entryName, boolean isApplicationClass) {
        super(589824);
        this.ctx = ctx;
        this.definingURI = definingURI;
        this.entryName = entryName;
        this.typeBuilder = ctx.getTypeBuilder(definingURI);
        this.classContext = new ClassVisitingContext();
        this.visitingContext = new MemberVisitingContext(ctx.getConfig().modelUnAnnotatedMembers());
        this.fieldVisitor = new ModelFieldVisitor(this.visitingContext);
        this.methodVisitor = new ModelMethodVisitor(this.visitingContext);
        this.annotationVisitor = new ModelAnnotationVisitor();
        this.defaultAnnotationVisitor = new ModelDefaultAnnotationVisitor(this.methodVisitor.getContext());
        this.isApplicationClass = isApplicationClass;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String parentName = superName != null ? org.objectweb.asm.Type.getObjectType((String)superName).getClassName() : null;
        TypeProxy<? extends Type> parent = null;
        Class<? extends Type> typeType = this.typeBuilder.getType(access);
        if (!typeType.equals(AnnotationType.class)) {
            TypeProxy<? extends Type> typeProxy = parent = parentName != null ? this.typeBuilder.getHolder(parentName, typeType) : null;
        }
        if (parent != null && !parentName.equals(Object.class.getName())) {
            TypeImpl parentType = this.typeBuilder.getType(access, parentName, null);
            parent.set(parentType);
        }
        String className = org.objectweb.asm.Type.getObjectType((String)name).getClassName();
        URI classDefURI = null;
        try {
            int index = this.entryName.length() - name.length() - 6;
            if (null == this.definingURI || index == 0) {
                classDefURI = this.definingURI;
            } else {
                String newPath = index > 0 ? this.definingURI.getPath() + this.entryName.substring(0, index) : this.definingURI.getPath();
                classDefURI = new URI(this.definingURI.getScheme(), newPath, this.definingURI.getFragment());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "visiting {0} with classDefURI={1}", new Object[]{this.entryName, classDefURI});
        }
        this.type = this.ctx.getTypeBuilder(classDefURI).getType(access, className, parent);
        this.type.setApplicationClass(this.isApplicationClass);
        this.type.getProxy().visited();
        this.type.addDefiningURI(classDefURI);
        this.deepVisit = this.ctx.getConfig().getAnnotationsOfInterest().isEmpty();
        this.classContext.type = this.type;
        this.classContext.interfaces = interfaces;
        this.classContext.parent = parent;
        if (parent != null) {
            parent.addSubTypeRef(this.type);
        }
        try {
            ExtensibleTypeImpl classModel = (ExtensibleTypeImpl)this.type;
            if (signature != null) {
                SignatureReader reader = new SignatureReader(signature);
                SignatureVisitorImpl signatureVisitor = new SignatureVisitorImpl(this.typeBuilder);
                reader.accept((SignatureVisitor)signatureVisitor);
                if (!signatureVisitor.getImplementedInterfaces().isEmpty()) {
                    for (ParameterizedInterfaceModelImpl pim : signatureVisitor.getImplementedInterfaces()) {
                        if (pim.getRawInterfaceProxy() == null) continue;
                        classModel.isImplementing(pim);
                        if (!(classModel instanceof ClassModel)) continue;
                        pim.getRawInterfaceProxy().addImplementation((ClassModel)((Object)classModel));
                    }
                }
                classModel.setFormalTypeParameters(signatureVisitor.getFormalTypeParameters());
            } else if (!typeType.equals(AnnotationType.class)) {
                for (String intf : interfaces) {
                    String interfaceName = org.objectweb.asm.Type.getObjectType((String)intf).getClassName();
                    TypeImpl interfaceModel = this.typeBuilder.getType(512, interfaceName, null);
                    TypeProxy<InterfaceModel> typeProxy = this.typeBuilder.getHolder(interfaceName, InterfaceModel.class);
                    if (typeProxy.get() == null) {
                        typeProxy.set((InterfaceModel)((Object)interfaceModel));
                    }
                    classModel.isImplementing(typeProxy);
                    if (!(classModel instanceof ClassModel)) continue;
                    typeProxy.addImplementation((ClassModel)((Object)classModel));
                }
            }
        }
        catch (ClassCastException classModel) {
        }
        catch (Exception ne) {
            ne.printStackTrace();
        }
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        desc = this.unwrap(desc);
        AnnotationTypeImpl at = (AnnotationTypeImpl)this.typeBuilder.getType(8192, desc, null);
        AnnotationModelImpl am = new AnnotationModelImpl(this.type, at);
        at.getAnnotatedElements().add(this.type);
        this.type.addAnnotation(am);
        if (this.ctx.getConfig().getAnnotationsOfInterest().contains(desc)) {
            logger.log(Level.FINER, "Inspecting fields of {0}", this.type.getName());
            this.deepVisit = true;
        }
        this.annotationVisitor.setAnnotation(am);
        return this.annotationVisitor;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (!this.deepVisit) {
            return null;
        }
        if (!(this.type instanceof ExtensibleTypeImpl)) {
            logger.log(Level.SEVERE, "Field visitor invoked for field {0}in type {1} which is not a ClassModel type instance but a {2}", new Object[]{name, this.type.getName(), this.type.getClass().getName()});
            return null;
        }
        ExtensibleTypeImpl cm = (ExtensibleTypeImpl)this.type;
        FieldModelImpl field = this.typeBuilder.getFieldModel(name, null, cm);
        SignatureReader reader = new SignatureReader(signature == null ? desc : signature);
        FieldSignatureVisitorImpl visitor = new FieldSignatureVisitorImpl(this.typeBuilder, field);
        reader.accept((SignatureVisitor)visitor);
        org.objectweb.asm.Type asmType = org.objectweb.asm.Type.getType((String)desc);
        field.setType(asmType);
        if (field.getTypeProxy() == null) {
            field.setTypeProxy(this.typeBuilder.getHolder(asmType.getClassName()));
        }
        field.setAccess(access);
        this.fieldVisitor.getContext().field = field;
        this.fieldVisitor.getContext().typeDesc = desc;
        this.fieldVisitor.getContext().access = access;
        this.fieldVisitor.getContext().classModel = cm;
        return this.fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.deepVisit) {
            return null;
        }
        if (!(this.type instanceof ExtensibleType)) {
            logger.log(Level.SEVERE, "Method visitor invoked for method {0} in type {1} which is not an ExtensibleType type instance but a {2}", new Object[]{name, this.type.getName(), this.type.getClass().getName()});
            return null;
        }
        ExtensibleType cm = (ExtensibleType)((Object)this.type);
        MethodModelImpl methodModel = new MethodModelImpl(name, cm, signature == null ? desc : signature);
        SignatureReader reader = new SignatureReader(signature == null ? desc : signature);
        MethodSignatureVisitorImpl visitor = new MethodSignatureVisitorImpl(this.typeBuilder, methodModel);
        reader.accept((SignatureVisitor)visitor);
        methodModel.setParameters(visitor.getParameters());
        methodModel.setReturnType(visitor.getReturnType());
        ParameterizedTypeImpl returnType = (ParameterizedTypeImpl)methodModel.getReturnType();
        org.objectweb.asm.Type type = org.objectweb.asm.Type.getReturnType((String)desc);
        returnType.setType(type);
        ArrayList<ParameterizedType> exceptionTypes = new ArrayList<ParameterizedType>();
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                String exception = exceptions[i];
                ParameterizedTypeImpl exceptionType = new ParameterizedTypeImpl(exception);
                exceptionType.setType(org.objectweb.asm.Type.getObjectType((String)exception));
                exceptionTypes.add(exceptionType);
            }
        }
        methodModel.setExceptionTypes(exceptionTypes);
        org.objectweb.asm.Type[] types = org.objectweb.asm.Type.getArgumentTypes((String)desc);
        for (int i = 0; i < methodModel.getParameters().size(); ++i) {
            ParameterImpl parameter = (ParameterImpl)methodModel.getParameter(i);
            parameter.setType(types[i]);
        }
        this.methodVisitor.getContext().method = methodModel;
        return this.methodVisitor;
    }

    public void visitEnd() {
        this.type = null;
    }

    private String unwrap(String desc) {
        return org.objectweb.asm.Type.getType((String)desc).getClassName();
    }

    private class ArrayVisitor
    extends AnnotationVisitor {
        protected List values;

        public ArrayVisitor(AnnotationVisitor av) {
            super(589824, av);
            this.values = new ArrayList();
        }

        public void visit(String name, Object value) {
            this.values.add(this.unwrap(value));
        }

        private Object unwrap(Object value) {
            if (org.objectweb.asm.Type.class.isInstance(value)) {
                return ((org.objectweb.asm.Type)org.objectweb.asm.Type.class.cast(value)).getClassName();
            }
            return value;
        }

        public List getValues() {
            return this.values;
        }
    }

    private class ModelAnnotationVisitor
    extends AnnotationVisitor {
        private final AnnotationVisitingContext context;

        private ModelAnnotationVisitor() {
            super(589824);
            this.context = new AnnotationVisitingContext();
        }

        AnnotationVisitingContext getContext() {
            return this.context;
        }

        void setAnnotation(AnnotationModelImpl annotation) {
            this.context.annotation = annotation;
            this.context.parent.add(annotation);
        }

        public void visit(String name, Object value) {
            this.addValue(name, value);
        }

        public AnnotationVisitor visitArray(String name) {
            ArrayVisitor arrayVisitor = new ArrayVisitor(ModelClassVisitor.this.annotationVisitor);
            this.addValue(name, arrayVisitor.getValues());
            this.context.parent.add(arrayVisitor.getValues());
            return arrayVisitor;
        }

        private void addValue(String name, Object value) {
            if (!this.context.parent.isEmpty()) {
                Object parent = this.context.parent.peekLast();
                if (parent instanceof AnnotationModelImpl) {
                    ((AnnotationModelImpl)parent).addValue(name, value);
                } else if (parent instanceof List) {
                    ((List)parent).add(value);
                } else if (parent instanceof Map) {
                    ((Map)parent).put(name, value);
                } else {
                    throw new IllegalStateException();
                }
            }
        }

        public void visitEnum(String name, String desc, String value) {
            TypeImpl type = ModelClassVisitor.this.typeBuilder.getType(16384, ModelClassVisitor.this.unwrap(desc), null);
            EnumModelImpl enumModel = new EnumModelImpl(type, value);
            this.addValue(name, enumModel);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            desc = ModelClassVisitor.this.unwrap(desc);
            AnnotationTypeImpl at = (AnnotationTypeImpl)ModelClassVisitor.this.typeBuilder.getType(8192, desc, null);
            AnnotationModelImpl am = new AnnotationModelImpl(null, at);
            this.addValue(name, am);
            this.context.parent.add(am);
            return ModelClassVisitor.this.annotationVisitor;
        }

        public void visitEnd() {
            if (!this.context.parent.isEmpty()) {
                this.context.parent.pollLast();
            }
        }
    }

    private class ModelFieldVisitor
    extends FieldVisitor {
        private final FieldVisitingContext context;

        private ModelFieldVisitor(MemberVisitingContext context) {
            super(589824);
            this.context = new FieldVisitingContext(context.modelUnAnnotatedMembers);
        }

        FieldVisitingContext getContext() {
            return this.context;
        }

        public AnnotationVisitor visitAnnotation(String s, boolean b) {
            FieldModelImpl field = this.context.field;
            AnnotationTypeImpl annotationType = (AnnotationTypeImpl)ModelClassVisitor.this.typeBuilder.getType(8192, ModelClassVisitor.this.unwrap(s), null);
            AnnotationModelImpl annotationModel = new AnnotationModelImpl(field, annotationType);
            annotationType.getAnnotatedElements().add(field);
            field.addAnnotation(annotationModel);
            ModelClassVisitor.this.annotationVisitor.setAnnotation(annotationModel);
            return ModelClassVisitor.this.annotationVisitor;
        }

        public void visitEnd() {
            if (this.context.modelUnAnnotatedMembers || !this.context.field.getAnnotations().isEmpty()) {
                if (this.context.field.getTypeProxy() != null) {
                    this.context.field.getTypeProxy().addFieldRef(this.context.field);
                }
                if ((8 & this.context.access) == 8) {
                    this.context.classModel.addStaticField(this.context.field);
                } else {
                    this.context.classModel.addField(this.context.field);
                }
            }
            this.context.field = null;
        }
    }

    private class ModelDefaultAnnotationVisitor
    extends AnnotationVisitor {
        private final MethodVisitingContext context;

        public ModelDefaultAnnotationVisitor(MethodVisitingContext visitingContext) {
            super(589824);
            this.context = visitingContext;
        }

        public void visit(String desc, Object value) {
            AnnotationTypeImpl am = (AnnotationTypeImpl)this.context.method.owner;
            am.addDefaultValue(this.context.method.getName(), value);
        }
    }

    private class ModelMethodVisitor
    extends MethodVisitor {
        private final MethodVisitingContext context;

        private ModelMethodVisitor(MemberVisitingContext context) {
            super(589824);
            this.context = new MethodVisitingContext(context.modelUnAnnotatedMembers);
        }

        MethodVisitingContext getContext() {
            return this.context;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (this.context.method == null) {
                return null;
            }
            AnnotationTypeImpl annotationType = (AnnotationTypeImpl)ModelClassVisitor.this.typeBuilder.getType(8192, ModelClassVisitor.this.unwrap(desc), null);
            AnnotationModelImpl annotationModel = new AnnotationModelImpl(this.context.method, annotationType);
            annotationType.getAnnotatedElements().add(this.context.method);
            this.context.method.addAnnotation(annotationModel);
            ModelClassVisitor.this.annotationVisitor.setAnnotation(annotationModel);
            return ModelClassVisitor.this.annotationVisitor;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameterIndex, String desc, boolean visible) {
            AnnotationTypeImpl annotationType = (AnnotationTypeImpl)ModelClassVisitor.this.typeBuilder.getType(8192, ModelClassVisitor.this.unwrap(desc), null);
            ParameterImpl parameter = (ParameterImpl)this.context.method.getParameter(parameterIndex);
            AnnotationModelImpl annotationModel = new AnnotationModelImpl(parameter, annotationType);
            annotationType.getAnnotatedElements().add(parameter);
            parameter.addAnnotation(annotationModel);
            ModelClassVisitor.this.annotationVisitor.setAnnotation(annotationModel);
            return ModelClassVisitor.this.annotationVisitor;
        }

        public void visitEnd() {
            if (this.context.modelUnAnnotatedMembers || !this.context.method.getAnnotations().isEmpty()) {
                ModelClassVisitor.this.type.addMethod(this.context.method);
            }
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return ModelClassVisitor.this.defaultAnnotationVisitor;
        }
    }

    private static class AnnotationVisitingContext {
        AnnotationModelImpl annotation;
        ArrayDeque parent = new ArrayDeque();

        private AnnotationVisitingContext() {
        }
    }

    private static class MethodVisitingContext
    extends MemberVisitingContext {
        MethodModelImpl method;

        private MethodVisitingContext(boolean modelUnAnnotatedMembers) {
            super(modelUnAnnotatedMembers);
        }
    }

    private static class FieldVisitingContext
    extends MemberVisitingContext {
        FieldModelImpl field;
        String typeDesc;
        ExtensibleTypeImpl classModel;
        int access;

        private FieldVisitingContext(boolean modelUnAnnotatedMembers) {
            super(modelUnAnnotatedMembers);
        }
    }

    private static class MemberVisitingContext {
        final boolean modelUnAnnotatedMembers;

        private MemberVisitingContext(boolean modelUnAnnotatedMembers) {
            this.modelUnAnnotatedMembers = modelUnAnnotatedMembers;
        }
    }

    private static class ClassVisitingContext {
        TypeImpl type;
        TypeProxy parent;
        String[] interfaces;

        private ClassVisitingContext() {
        }
    }
}

