/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.connector;

import com.sun.enterprise.module.HK2Module;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Contract;

@Contract
public abstract class MicroProfileSniffer
implements Sniffer {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileSniffer.class.getName());

    public boolean handles(DeploymentContext context) {
        ReadableArchive archive = context.getSource();
        String archivePath = archive.getURI().getPath();
        if (archivePath.contains("glassfish/lib/install")) {
            return false;
        }
        if (archivePath.contains("h2db/bin")) {
            return false;
        }
        if (archivePath.contains("mq/lib")) {
            return false;
        }
        return this.handles(archive);
    }

    protected abstract Class<?> getContainersClass();

    public final String[] getContainersNames() {
        String[] result = new String[]{this.getContainersClass().getName()};
        return result;
    }

    public boolean handles(ReadableArchive archive) {
        return false;
    }

    public final String[] getURLPatterns() {
        return new String[0];
    }

    public final String[] getAnnotationNames(DeploymentContext ctx) {
        Class[] types = this.getAnnotationTypes();
        if (types == null) {
            return null;
        }
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = types[i].getName();
        }
        return names;
    }

    public final HK2Module[] setup(String containerHome, Logger logger) throws IOException {
        return new HK2Module[0];
    }

    public final void tearDown() {
    }

    public final boolean supportsArchiveType(ArchiveType type) {
        String extension;
        switch (extension = type == null ? null : type.getExtension()) {
            case ".war": {
                return true;
            }
        }
        LOGGER.fine("Unsupported ArchiveType: " + extension);
        return false;
    }

    public String[] getIncompatibleSnifferTypes() {
        String[] types = new String[]{"connector"};
        return types;
    }

    public final boolean isJavaEE() {
        return false;
    }

    public boolean isUserVisible() {
        return true;
    }

    public Map<String, String> getDeploymentConfigurations(ReadableArchive archive) throws IOException {
        return new HashMap<String, String>();
    }
}

