/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModuleChangeListener;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.server.logging.LoggerInfoData;
import com.sun.enterprise.server.logging.LoggerInfoMetadata;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class LoggerInfoMetadataService
implements LoggerInfoMetadata,
ModuleChangeListener {
    private static final String RBNAME = "META-INF/loggerinfo/LoggerInfoMetadata";
    private static final Locale BASE_LOCALE = Locale.ROOT;
    @Inject
    ModulesRegistry modulesRegistry;
    private Map<Locale, LoggersInfoMap> metadataMaps;
    private Set<String> moduleNames;
    private boolean valid;

    private Set<String> currentModuleNames() {
        HashSet<String> currentNames = new HashSet<String>();
        for (HK2Module module : this.modulesRegistry.getModules()) {
            currentNames.add(module.getName());
        }
        if (this.moduleNames != null) {
            for (String name : this.moduleNames) {
                if (currentNames.contains(name)) continue;
                this.valid = false;
            }
            for (String name : currentNames) {
                if (this.moduleNames.contains(name)) continue;
                this.valid = false;
            }
        } else {
            this.valid = false;
        }
        return currentNames;
    }

    private boolean isValid() {
        return this.valid && this.metadataMaps != null;
    }

    private synchronized LoggersInfoMap getLoggersInfoMap(Locale locale) {
        LoggersInfoMap infos;
        this.moduleNames = this.currentModuleNames();
        if (!this.isValid()) {
            this.metadataMaps = new HashMap<Locale, LoggersInfoMap>();
        }
        if ((infos = this.metadataMaps.get(locale)) == null) {
            infos = new LoggersInfoMap(locale);
            this.metadataMaps.put(locale, infos);
        }
        this.valid = true;
        return infos;
    }

    @Override
    public String getDescription(String logger) {
        LoggersInfoMap infos = this.getLoggersInfoMap(BASE_LOCALE);
        return infos.getDescription(logger);
    }

    @Override
    public String getDescription(String logger, Locale locale) {
        LoggersInfoMap infos = this.getLoggersInfoMap(locale);
        return infos.getDescription(logger);
    }

    @Override
    public Set<String> getLoggerNames() {
        LoggersInfoMap infos = this.getLoggersInfoMap(BASE_LOCALE);
        return infos.getLoggerNames();
    }

    @Override
    public String getSubsystem(String logger) {
        LoggersInfoMap infos = this.getLoggersInfoMap(BASE_LOCALE);
        return infos.getSubsystem(logger);
    }

    @Override
    public boolean isPublished(String logger) {
        LoggersInfoMap infos = this.getLoggersInfoMap(BASE_LOCALE);
        return infos.isPublished(logger);
    }

    public synchronized void changed(HK2Module sender) {
        this.valid = false;
    }

    private static class NullClassLoader
    extends ClassLoader {
        private NullClassLoader() {
        }

        @Override
        protected URL findResource(String name) {
            return null;
        }

        protected Enumeration findResources(String name) throws IOException {
            return null;
        }

        @Override
        public URL getResource(String name) {
            return null;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException("Class not found: " + name);
        }

        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            throw new ClassNotFoundException("Class not found: " + name);
        }
    }

    private class LoggersInfoMap {
        private Locale locale;
        private Map<String, LoggerInfoData> map;

        LoggersInfoMap(Locale locale) {
            this.locale = locale;
            this.map = new HashMap<String, LoggerInfoData>();
            this.initialize();
        }

        public Set<String> getLoggerNames() {
            return this.map.keySet();
        }

        public String getDescription(String logger) {
            LoggerInfoData info = this.map.get(logger);
            return info != null ? info.getDescription() : null;
        }

        public String getSubsystem(String logger) {
            LoggerInfoData info = this.map.get(logger);
            return info != null ? info.getSubsystem() : null;
        }

        public boolean isPublished(String logger) {
            LoggerInfoData info = this.map.get(logger);
            return info != null ? info.isPublished() : false;
        }

        private void initialize() {
            NullClassLoader nullClassLoader = new NullClassLoader();
            for (HK2Module module : LoggerInfoMetadataService.this.modulesRegistry.getModules()) {
                int size;
                ModuleDefinition moduleDef = module.getModuleDefinition();
                URI[] uris = moduleDef.getLocations();
                int n = size = uris != null ? uris.length : 0;
                if (size == 0) continue;
                URL[] urls = new URL[size];
                try {
                    for (int i = 0; i < size; ++i) {
                        urls[i] = uris[i].toURL();
                    }
                    URLClassLoader loader = new URLClassLoader(urls, (ClassLoader)nullClassLoader);
                    ResourceBundle rb = ResourceBundle.getBundle(LoggerInfoMetadataService.RBNAME, this.locale, loader);
                    for (String key : rb.keySet()) {
                        int index = key.lastIndexOf(46);
                        String loggerName = key.substring(0, index);
                        String attribute = key.substring(index + 1);
                        String value = rb.getString(key);
                        LoggerInfoData li = this.findOrCreateLoggerInfoMetadata(loggerName);
                        if (attribute.equals("description")) {
                            li.setDescription(value);
                            continue;
                        }
                        if (attribute.equals("publish")) {
                            li.setPublished(Boolean.parseBoolean(value));
                            continue;
                        }
                        if (!attribute.equals("subsystem")) continue;
                        li.setSubsystem(value);
                    }
                }
                catch (MalformedURLException mfe) {
                    mfe.printStackTrace();
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
        }

        private LoggerInfoData findOrCreateLoggerInfoMetadata(String loggerName) {
            LoggerInfoData loggerInfoData = null;
            if (this.map.containsKey(loggerName)) {
                loggerInfoData = this.map.get(loggerName);
            } else {
                loggerInfoData = new LoggerInfoData();
                this.map.put(loggerName, loggerInfoData);
            }
            return loggerInfoData;
        }
    }
}

