/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.common.util.logging.GFLogRecord;
import com.sun.enterprise.server.logging.AnsiColorFormatter;
import com.sun.enterprise.server.logging.ExcludeFieldsSupport;
import com.sun.enterprise.server.logging.FormatterDelegate;
import com.sun.enterprise.server.logging.LogEvent;
import com.sun.enterprise.server.logging.LogEventBroadcaster;
import com.sun.enterprise.server.logging.LogEventImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class UniformLogFormatter
extends AnsiColorFormatter
implements LogEventBroadcaster {
    private static final String RECORD_NUMBER = "RecordNumber";
    private static final String METHOD_NAME = "MethodName";
    private static final String CLASS_NAME = "ClassName";
    private HashMap loggerResourceBundleTable;
    private LogManager logManager;
    private Date date = new Date();
    private static boolean LOG_SOURCE_IN_KEY_VALUE;
    private static boolean RECORD_NUMBER_IN_KEY_VALUE;
    private FormatterDelegate _delegate = null;
    private long recordNumber = 0L;
    private static final String LINE_SEPARATOR;
    private String recordBeginMarker;
    private String recordEndMarker;
    private String recordFieldSeparator;
    private String recordDateFormat;
    private static final String RECORD_BEGIN_MARKER = "[#|";
    private static final String RECORD_END_MARKER;
    private static final char FIELD_SEPARATOR = '|';
    public static final char NVPAIR_SEPARATOR = ';';
    public static final char NV_SEPARATOR = '=';
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private LogEventBroadcaster logEventBroadcasterDelegate;
    private boolean multiLineMode;
    private static final String INDENT = "  ";

    public UniformLogFormatter() {
        this(null);
    }

    public UniformLogFormatter(String excludeFields) {
        super(excludeFields);
        this.loggerResourceBundleTable = new HashMap();
        this.logManager = LogManager.getLogManager();
    }

    public UniformLogFormatter(FormatterDelegate delegate, String excludeFields) {
        this(excludeFields);
        this._delegate = delegate;
    }

    public void setDelegate(FormatterDelegate delegate) {
        this._delegate = delegate;
    }

    @Override
    public String format(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    @Override
    public String formatMessage(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    protected void getNameValuePairs(StringBuilder buf, LogRecord record) {
        Object[] parameters = record.getParameters();
        if (parameters == null || parameters.length == 0) {
            return;
        }
        try {
            for (Object obj : parameters) {
                if (obj == null) continue;
                if (obj instanceof Map) {
                    for (Map.Entry entry : ((Map)obj).entrySet()) {
                        if (entry.getKey() != null) {
                            buf.append(entry.getKey().toString());
                        } else {
                            buf.append("null");
                        }
                        buf.append('=');
                        if (entry.getValue() != null) {
                            buf.append(entry.getValue().toString());
                        } else {
                            buf.append("null");
                        }
                        buf.append(';');
                    }
                    continue;
                }
                if (!(obj instanceof Collection)) continue;
                for (Map.Entry entry : (Collection)obj) {
                    if (entry != null) {
                        buf.append(entry.toString());
                    } else {
                        buf.append("null");
                    }
                    buf.append(';');
                }
            }
        }
        catch (Exception e) {
            new ErrorManager().error("Error in extracting Name Value Pairs", e, 5);
        }
    }

    private String uniformLogFormat(LogRecord record) {
        try {
            String logMessage;
            String msgId;
            String loggerName;
            LogEventImpl logEvent = new LogEventImpl();
            SimpleDateFormat dateFormatter = new SimpleDateFormat(this.getRecordDateFormat() != null ? this.getRecordDateFormat() : RFC_3339_DATE_FORMAT);
            StringBuilder recordBuffer = new StringBuilder(this.getRecordBeginMarker() != null ? this.getRecordBeginMarker() : RECORD_BEGIN_MARKER);
            this.date.setTime(record.getMillis());
            String timestamp = dateFormatter.format(this.date);
            logEvent.setTimestamp(timestamp);
            recordBuffer.append(timestamp);
            if (this.color()) {
                recordBuffer.append((Object)this.getColor(record.getLevel()));
            }
            recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf('|'));
            logEvent.setLevel(record.getLevel().getName());
            recordBuffer.append(record.getLevel().getLocalizedName()).append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf('|'));
            if (this.color()) {
                recordBuffer.append((Object)this.getReset());
            }
            if (!this.isFieldExcluded(ExcludeFieldsSupport.SupplementalAttribute.VERSION)) {
                String compId = this.getProductId();
                logEvent.setComponentId(compId);
                recordBuffer.append(compId).append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf('|'));
            }
            loggerName = (loggerName = record.getLoggerName()) == null ? "" : loggerName;
            logEvent.setLogger(loggerName);
            if (this.color()) {
                recordBuffer.append((Object)this.getLoggerColor());
            }
            recordBuffer.append(loggerName).append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf('|'));
            if (this.color()) {
                recordBuffer.append((Object)this.getReset());
            }
            if (!this.isFieldExcluded(ExcludeFieldsSupport.SupplementalAttribute.TID)) {
                recordBuffer.append("_ThreadID").append('=');
                logEvent.setThreadId(record.getThreadID());
                recordBuffer.append(record.getThreadID()).append(';');
                recordBuffer.append("_ThreadName").append('=');
                String threadName = record instanceof GFLogRecord ? ((GFLogRecord)record).getThreadName() : Thread.currentThread().getName();
                logEvent.setThreadName(threadName);
                recordBuffer.append(threadName);
                recordBuffer.append(';');
            }
            if (!this.isFieldExcluded(ExcludeFieldsSupport.SupplementalAttribute.TIME_MILLIS)) {
                recordBuffer.append("_TimeMillis").append('=');
                logEvent.setTimeMillis(record.getMillis());
                recordBuffer.append(record.getMillis()).append(';');
            }
            Level level = record.getLevel();
            if (!this.isFieldExcluded(ExcludeFieldsSupport.SupplementalAttribute.LEVEL_VALUE)) {
                recordBuffer.append("_LevelValue").append('=');
                int levelValue = level.intValue();
                logEvent.setLevelValue(levelValue);
                recordBuffer.append(levelValue).append(';');
            }
            if ((msgId = UniformLogFormatter.getMessageId(record)) != null && !msgId.isEmpty()) {
                logEvent.setMessageId(msgId);
                recordBuffer.append("_MessageID").append('=');
                recordBuffer.append(msgId).append(';');
            }
            if (LOG_SOURCE_IN_KEY_VALUE || level.intValue() <= Level.FINE.intValue()) {
                String sourceMethodName;
                String sourceClassName = record.getSourceClassName();
                if (sourceClassName != null && !sourceClassName.isEmpty()) {
                    recordBuffer.append(CLASS_NAME).append('=');
                    logEvent.getSupplementalAttributes().put(CLASS_NAME, sourceClassName);
                    recordBuffer.append(sourceClassName);
                    recordBuffer.append(';');
                }
                if ((sourceMethodName = record.getSourceMethodName()) != null && !sourceMethodName.isEmpty()) {
                    recordBuffer.append(METHOD_NAME).append('=');
                    logEvent.getSupplementalAttributes().put(METHOD_NAME, sourceMethodName);
                    recordBuffer.append(sourceMethodName);
                    recordBuffer.append(';');
                }
            }
            if (RECORD_NUMBER_IN_KEY_VALUE) {
                ++this.recordNumber;
                recordBuffer.append(RECORD_NUMBER).append('=');
                logEvent.getSupplementalAttributes().put(RECORD_NUMBER, this.recordNumber);
                recordBuffer.append(this.recordNumber).append(';');
            }
            if (this._delegate != null) {
                this._delegate.format(recordBuffer, level);
            }
            recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf('|'));
            if (this.multiLineMode) {
                recordBuffer.append(LINE_SEPARATOR);
                recordBuffer.append(INDENT);
            }
            if ((logMessage = record.getMessage()) == null || logMessage.trim().equals("")) {
                if (record.getThrown() != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    logMessage = sw.toString();
                    sw.close();
                } else {
                    logMessage = "";
                }
                logEvent.setMessage(logMessage);
                recordBuffer.append(logMessage);
            } else {
                logMessage = UniformLogFormatter.formatLogMessage(logMessage, record, this::getResourceBundle);
                StringBuilder logMessageBuffer = new StringBuilder();
                logMessageBuffer.append(logMessage);
                Throwable throwable = UniformLogFormatter.getThrowable(record);
                if (throwable != null) {
                    logMessageBuffer.append(LINE_SEPARATOR);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    pw.close();
                    logMessageBuffer.append(sw.toString());
                    sw.close();
                }
                logMessage = logMessageBuffer.toString();
                logEvent.setMessage(logMessage);
                recordBuffer.append(logMessage);
            }
            recordBuffer.append(this.getRecordEndMarker() != null ? this.getRecordEndMarker() : RECORD_END_MARKER).append(LINE_SEPARATOR).append(LINE_SEPARATOR);
            this.informLogEventListeners(logEvent);
            return recordBuffer.toString();
        }
        catch (Exception ex) {
            new ErrorManager().error("Error in formatting Logrecord", ex, 5);
            return "";
        }
    }

    public static String formatLogMessage(String logMessage, LogRecord record, Function<String, ResourceBundle> rbGetter) {
        try {
            return UniformLogFormatter.formatLogMessage0(logMessage, record.getLoggerName(), record.getParameters(), rbGetter);
        }
        catch (IllegalArgumentException e) {
            if (record.getParameters() == null || record.getParameters().length < 2 || record.getParameters().length % 2 != 0) {
                throw e;
            }
            Object[] parameters = new Object[record.getParameters().length / 2];
            System.arraycopy(record.getParameters(), parameters.length, parameters, 0, parameters.length);
            return UniformLogFormatter.formatLogMessage0(logMessage, record.getLoggerName(), parameters, rbGetter);
        }
    }

    private static String formatLogMessage0(String logMessage, String loggerName, Object[] parameters, Function<String, ResourceBundle> rbGetter) {
        if (logMessage.contains("{0") && logMessage.contains("}") && parameters != null) {
            logMessage = MessageFormat.format(logMessage, parameters);
        } else {
            ResourceBundle rb = rbGetter.apply(loggerName);
            if (rb != null && rb.containsKey(logMessage)) {
                try {
                    logMessage = MessageFormat.format(rb.getString(logMessage), parameters);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        return logMessage;
    }

    static String getMessageId(LogRecord lr) {
        String msgBody;
        ResourceBundle rb;
        String msg = lr.getMessage();
        if (msg != null && !msg.isEmpty() && (rb = lr.getResourceBundle()) != null && rb.containsKey(msg) && !(msgBody = lr.getResourceBundle().getString(msg)).isEmpty()) {
            return msg;
        }
        return null;
    }

    static Throwable getThrowable(LogRecord record) {
        return record.getThrown();
    }

    private synchronized ResourceBundle getResourceBundle(String loggerName) {
        if (loggerName == null) {
            return null;
        }
        ResourceBundle rb = (ResourceBundle)this.loggerResourceBundleTable.get(loggerName);
        if (rb == null && this.logManager.getLogger(loggerName) != null) {
            rb = this.logManager.getLogger(loggerName).getResourceBundle();
            this.loggerResourceBundleTable.put(loggerName, rb);
        }
        return rb;
    }

    public String getRecordBeginMarker() {
        return this.recordBeginMarker;
    }

    public void setRecordBeginMarker(String recordBeginMarker) {
        this.recordBeginMarker = recordBeginMarker;
    }

    public String getRecordEndMarker() {
        return this.recordEndMarker;
    }

    public void setRecordEndMarker(String recordEndMarker) {
        this.recordEndMarker = recordEndMarker;
    }

    public String getRecordFieldSeparator() {
        return this.recordFieldSeparator;
    }

    public void setRecordFieldSeparator(String recordFieldSeparator) {
        this.recordFieldSeparator = recordFieldSeparator;
    }

    public String getRecordDateFormat() {
        return this.recordDateFormat;
    }

    public void setRecordDateFormat(String recordDateFormat) {
        this.recordDateFormat = recordDateFormat;
    }

    LogEventBroadcaster getLogEventBroadcaster() {
        return this.logEventBroadcasterDelegate;
    }

    void setLogEventBroadcaster(LogEventBroadcaster logEventBroadcaster) {
        this.logEventBroadcasterDelegate = logEventBroadcaster;
    }

    @Override
    public void informLogEventListeners(LogEvent logEvent) {
        if (this.logEventBroadcasterDelegate != null) {
            this.logEventBroadcasterDelegate.informLogEventListeners(logEvent);
        }
    }

    void setMultiLineMode(boolean value) {
        this.multiLineMode = value;
    }

    static {
        String recordCount;
        LOG_SOURCE_IN_KEY_VALUE = false;
        RECORD_NUMBER_IN_KEY_VALUE = false;
        String logSource = System.getProperty("com.sun.aas.logging.keyvalue.logsource");
        if (logSource != null && logSource.equals("true")) {
            LOG_SOURCE_IN_KEY_VALUE = true;
        }
        if ((recordCount = System.getProperty("com.sun.aas.logging.keyvalue.recordnumber")) != null && recordCount.equals("true")) {
            RECORD_NUMBER_IN_KEY_VALUE = true;
        }
        LINE_SEPARATOR = System.getProperty("line.separator");
        RECORD_END_MARKER = "|#]" + LINE_SEPARATOR;
    }
}

