/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.monitoring;

import com.sun.gjc.util.SQLTrace;
import fish.payara.jdbc.stats.FrequentSQLTraceCache;
import fish.payara.jdbc.stats.SlowSqlTrace;
import fish.payara.jdbc.stats.SlowSqlTraceCache;
import java.util.List;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.ListStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.ListStatisticImpl;
import org.glassfish.external.statistics.impl.StatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.resourcebase.resources.api.PoolInfo;

@AMXMetadata(type="jdbcra-mon", group="monitoring")
@ManagedObject
@Description(value="JDBC RA Statistics")
public class JdbcStatsProvider {
    private ListStatisticImpl freqUsedSqlQueries = new ListStatisticImpl("FreqUsedSqlQueries", "List", "Most frequently used sql queries");
    private ListStatisticImpl slowSqlQueries = new ListStatisticImpl("SlowSqlQueries", "List", "Slowest SQL Queries");
    private CountStatisticImpl numStatementCacheHit = new CountStatisticImpl("NumStatementCacheHit", "count", "The total number of Statement Cache hits.");
    private CountStatisticImpl numStatementCacheMiss = new CountStatisticImpl("NumStatementCacheMiss", "count", "The total number of Statement Cache misses.");
    private CountStatisticImpl numPotentialStatementLeak = new CountStatisticImpl("NumPotentialStatementLeak", "count", "The total number of potential Statement leaks");
    private PoolInfo poolInfo;
    private FrequentSQLTraceCache freqSqlTraceCache;
    private SlowSqlTraceCache slowSqlTraceCache;

    public JdbcStatsProvider(String poolName, String appName, String moduleName, int sqlTraceCacheSize, long timeToKeepQueries) {
        this.poolInfo = new PoolInfo(poolName, appName, moduleName);
        if (sqlTraceCacheSize > 0) {
            this.freqSqlTraceCache = new FrequentSQLTraceCache(poolName, sqlTraceCacheSize, timeToKeepQueries);
            this.slowSqlTraceCache = new SlowSqlTraceCache(poolName, sqlTraceCacheSize, timeToKeepQueries);
        }
    }

    public JdbcStatsProvider(String poolName, String appName, String moduleName, int sqlTraceCacheSize, long timeToKeepQueries, int maxStoredEntries) {
        this.poolInfo = new PoolInfo(poolName, appName, moduleName);
        if (sqlTraceCacheSize > 0) {
            this.freqSqlTraceCache = new FrequentSQLTraceCache(poolName, sqlTraceCacheSize, timeToKeepQueries, maxStoredEntries);
            this.slowSqlTraceCache = new SlowSqlTraceCache(poolName, sqlTraceCacheSize, timeToKeepQueries);
        }
    }

    @ProbeListener(value="glassfish:jdbcra:statementcache:statementCacheHitEvent")
    public void statementCacheHitEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        PoolInfo poolInfo = new PoolInfo(poolName, appName, moduleName);
        if (this.poolInfo.equals((Object)poolInfo)) {
            this.numStatementCacheHit.increment();
        }
    }

    @ProbeListener(value="glassfish:jdbcra:statementcache:statementCacheMissEvent")
    public void statementCacheMissEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        PoolInfo poolInfo = new PoolInfo(poolName, appName, moduleName);
        if (this.poolInfo.equals((Object)poolInfo)) {
            this.numStatementCacheMiss.increment();
        }
    }

    @ProbeListener(value="glassfish:jdbcra:sqltracing:traceSQLEvent")
    public void traceSQLEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName, @ProbeParam(value="sql") String sql, @ProbeParam(value="executionTime") long executionTime) {
        PoolInfo poolInfo = new PoolInfo(poolName, appName, moduleName);
        if (this.poolInfo.equals((Object)poolInfo)) {
            SQLTrace cacheObj;
            if (this.freqSqlTraceCache != null && sql != null) {
                cacheObj = new SQLTrace(sql, 1, System.currentTimeMillis());
                this.freqSqlTraceCache.checkAndUpdateCache(cacheObj);
            }
            if (this.slowSqlTraceCache != null && sql != null) {
                cacheObj = new SlowSqlTrace(sql, 1, System.currentTimeMillis(), executionTime);
                this.slowSqlTraceCache.checkAndUpdateCache(cacheObj);
            }
        }
    }

    @ProbeListener(value="glassfish:jdbcra:statementleak:potentialStatementLeakEvent")
    public void potentialStatementLeakEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        PoolInfo poolInfo = new PoolInfo(poolName, appName, moduleName);
        if (this.poolInfo.equals((Object)poolInfo)) {
            this.numPotentialStatementLeak.increment();
        }
    }

    @ManagedAttribute(id="numstatementcachehit")
    public CountStatistic getNumStatementCacheHit() {
        return this.numStatementCacheHit;
    }

    @ManagedAttribute(id="numstatementcachemiss")
    public CountStatistic getNumStatementCacheMiss() {
        return this.numStatementCacheMiss;
    }

    @ManagedAttribute(id="frequsedsqlqueries")
    public ListStatistic getfreqUsedSqlQueries() {
        if (this.freqSqlTraceCache != null) {
            List<SQLTrace> sqlTraces = this.freqSqlTraceCache.getTopQueries();
            this.freqUsedSqlQueries = new ListStatisticImpl("frequsedsqlqueries", "List", "Most frequently used sql queries");
            for (SQLTrace trace : sqlTraces) {
                CountStatisticImpl stat = new CountStatisticImpl(trace.getQueryName(), "Count", "");
                stat.setCount((long)trace.getNumExecutions());
                this.freqUsedSqlQueries.add((StatisticImpl)stat);
            }
        }
        return this.freqUsedSqlQueries;
    }

    @ManagedAttribute(id="slowSqlQueries")
    public ListStatistic getSlowSqlQueries() {
        this.slowSqlQueries.reset();
        this.slowSqlQueries.clear();
        if (this.slowSqlTraceCache != null) {
            List<SlowSqlTrace> slowTraces = this.slowSqlTraceCache.getSlowestSqlQueries();
            for (SlowSqlTrace trace : slowTraces) {
                CountStatisticImpl stat = new CountStatisticImpl(trace.getQueryName(), "millisecond", "Longest execution time");
                stat.setCount(trace.getSlowestExecutionTime());
                this.slowSqlQueries.add((StatisticImpl)stat);
            }
        }
        return this.slowSqlQueries;
    }

    @ManagedAttribute(id="numpotentialstatementleak")
    public CountStatistic getNumPotentialStatementLeak() {
        return this.numPotentialStatementLeak;
    }

    public FrequentSQLTraceCache getFreqSqlTraceCache() {
        return this.freqSqlTraceCache;
    }

    public SlowSqlTraceCache getSlowSqlTraceCache() {
        return this.slowSqlTraceCache;
    }
}

