/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.enterprise.concurrent.Trigger;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceAdapter;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.glassfish.enterprise.concurrent.internal.ManagedFutureTask;
import org.glassfish.enterprise.concurrent.internal.ManagedScheduledThreadPoolExecutor;

public class ManagedScheduledExecutorServiceImpl
extends AbstractManagedExecutorService
implements ManagedScheduledExecutorService {
    protected ManagedScheduledThreadPoolExecutor executor;
    protected final ManagedScheduledExecutorServiceAdapter adapter;

    public ManagedScheduledExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, contextService, contextService != null ? contextService.getContextSetupProvider() : null, rejectPolicy);
        this.executor = new ManagedScheduledThreadPoolExecutor(corePoolSize, (ThreadFactory)((Object)this.managedThreadFactory));
        this.executor.setKeepAliveTime(keepAliveTime, keepAliveTimeUnit);
        this.executor.setThreadLifeTime(threadLifeTime);
        this.adapter = new ManagedScheduledExecutorServiceAdapter(this);
    }

    public ScheduledFuture<?> schedule(Runnable command, Trigger trigger) {
        return this.executor.schedule((AbstractManagedExecutorService)this, command, trigger);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, Trigger trigger) {
        return this.executor.schedule((AbstractManagedExecutorService)this, callable, trigger);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executor.schedule(this, command, null, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executor.schedule(this, callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(this, command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(this, command, initialDelay, delay, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executor.schedule(this, command, null, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.schedule(this, task, null, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.schedule(this, task, result, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.schedule(this, task, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    protected ExecutorService getExecutor() {
        return this.executor;
    }

    public ManagedScheduledExecutorServiceAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public ManagedExecutorService getExecutorForTaskListener() {
        return this.adapter;
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Runnable r, V result) {
        return this.executor.newTaskFor(this, r, result);
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Callable<V> callable) {
        return this.executor.newTaskFor(this, callable);
    }

    protected void executeManagedFutureTask(ManagedFutureTask task) {
        this.executor.executeManagedTask(task);
    }

    @Override
    public long getTaskCount() {
        return this.executor.getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.executor.getCompletedTaskCount();
    }

    @Override
    public int getCorePoolSize() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public long getKeepAliveTime() {
        return this.executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public int getLargestPoolSize() {
        return this.executor.getLargestPoolSize();
    }

    @Override
    public int getMaximumPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    @Override
    public BlockingQueue getBlockingQueue() {
        return this.executor.getQueue();
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.executor.getRejectedExecutionHandler();
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.executor.getThreadFactory();
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.executor.getContinueExistingPeriodicTasksAfterShutdownPolicy();
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executor.getExecuteExistingDelayedTasksAfterShutdownPolicy();
    }

    public boolean getRemoveOnCancelPolicy() {
        return this.executor.getRemoveOnCancelPolicy();
    }
}

