/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Version {
    private static final String INSTALL_ROOT_PROP_NAME = "com.sun.aas.installRoot";
    private static final String PRODUCT_NAME_KEY = "product_name";
    private static final String BRIEF_PRODUCT_NAME_KEY = "brief_product_name";
    private static final String ABBREV_PRODUCT_NAME_KEY = "abbrev_product_name";
    private static final String MAJOR_VERSION_KEY = "major_version";
    private static final String MINOR_VERSION_KEY = "minor_version";
    private static final String UPDATE_VERSION_KEY = "update_version";
    private static final String BUILD_ID_KEY = "build_id";
    private static final String VERSION_PREFIX_KEY = "version_prefix";
    private static final String VERSION_SUFFIX_KEY = "version_suffix";
    private static final String BASED_ON_KEY = "based_on";
    private static final String DEFAULT_DOMAIN_TEMPLATE_NAME = "default_domain_template";
    private static final String DEFAULT_DOMAIN_TEMPLATE_JAR = "nucleus-domain.jar";
    private static final String ADMIN_CLIENT_COMMAND_NAME_KEY = "admin_client_command_name";
    private static final String INITIAL_ADMIN_GROUPS_KEY = "initial_admin_user_groups";
    private static final String DISTRIBUTION_KEY = "distribution";
    private static final List<Properties> VERSION_PROPS = new ArrayList<Properties>();
    private static final Map<String, Properties> VERSION_PROPS_MAP = new HashMap<String, Properties>();
    private static final Properties versionProp = Version.getVersionProp();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getVersionProp() {
        String installRoot = System.getProperty(INSTALL_ROOT_PROP_NAME);
        if (installRoot != null) {
            File ir = new File(installRoot);
            File bd = new File(new File(ir, "config"), "branding");
            if (bd.isDirectory()) {
                for (File f : bd.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().endsWith(".properties") && f.canRead();
                    }
                })) {
                    FileReader fr = null;
                    try {
                        fr = new FileReader(f);
                        Properties p = new Properties();
                        p.load(fr);
                        VERSION_PROPS.add(p);
                        String apn = p.getProperty(ABBREV_PRODUCT_NAME_KEY);
                        if (apn != null) {
                            VERSION_PROPS_MAP.put(apn, p);
                        }
                        fr.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        if (fr != null) {
                            try {
                                fr.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
            Collections.sort(VERSION_PROPS, new Comparator<Properties>(){

                @Override
                public int compare(Properties p1, Properties p2) {
                    String abp1 = p1.getProperty(Version.ABBREV_PRODUCT_NAME_KEY);
                    String bo1 = p1.getProperty(Version.BASED_ON_KEY);
                    String abp2 = p2.getProperty(Version.ABBREV_PRODUCT_NAME_KEY);
                    String bo2 = p2.getProperty(Version.BASED_ON_KEY);
                    if (bo1 != null && abp2 != null && bo1.contains(abp2)) {
                        return -1;
                    }
                    if (bo2 != null && abp1 != null && bo2.contains(abp1)) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (!VERSION_PROPS.isEmpty()) {
                return VERSION_PROPS.get(0);
            }
        } else {
            System.out.println("installRoot is null");
        }
        return null;
    }

    public static String getVersion() {
        StringBuilder sb = new StringBuilder(Version.getProductName());
        sb.append(" ").append(Version.getVersionPrefix());
        sb.append(" ").append(Version.getVersionNumber());
        sb.append(" ").append(Version.getVersionSuffix());
        return sb.toString();
    }

    public static String getVersionNumber() {
        String v;
        String maj = Version.getMajorVersion();
        String min = Version.getMinorVersion();
        String upd = Version.getUpdateVersion();
        try {
            v = min != null && min.length() > 0 && Integer.parseInt(min) >= 0 ? (upd != null && upd.length() > 0 && Integer.parseInt(upd) >= 0 ? maj + "." + min + "." + upd : maj + "." + min) : (upd != null && upd.length() > 0 && Integer.parseInt(upd) >= 0 ? maj + ".0." + upd : maj);
        }
        catch (NumberFormatException nfe) {
            v = maj;
        }
        return v;
    }

    public static String getFullVersion() {
        return Version.getVersion() + " (build " + Version.getBuildVersion() + ")";
    }

    public static String getAbbreviatedVersion() {
        return Version.getMajorVersion();
    }

    public static String getMajorVersion() {
        return Version.getProperty(MAJOR_VERSION_KEY, "0");
    }

    public static String getMinorVersion() {
        return Version.getProperty(MINOR_VERSION_KEY, "0").replace("-SNAPSHOT", "");
    }

    public static String getUpdateVersion() {
        return Version.getProperty(UPDATE_VERSION_KEY, "0");
    }

    public static String getBuildVersion() {
        return Version.getProperty(BUILD_ID_KEY, "0");
    }

    public static String getVersionPrefix() {
        return Version.getProperty(VERSION_PREFIX_KEY, "");
    }

    public static String getVersionSuffix() {
        return Version.getProperty(VERSION_SUFFIX_KEY, "");
    }

    public static String getProductName() {
        return Version.getProperty(PRODUCT_NAME_KEY, "Undefined Product Name - define product and version info in config/branding");
    }

    public static String getBriefProductName() {
        return Version.getProperty(BRIEF_PRODUCT_NAME_KEY, "Undefined Product Name");
    }

    public static String getAbbrevProductName() {
        return Version.getProperty(ABBREV_PRODUCT_NAME_KEY, "undefined");
    }

    public static String getDefaultDomainTemplate() {
        return Version.getProperty(DEFAULT_DOMAIN_TEMPLATE_NAME, DEFAULT_DOMAIN_TEMPLATE_JAR);
    }

    public static String getAdminClientCommandName() {
        return Version.getProperty(ADMIN_CLIENT_COMMAND_NAME_KEY, "nadmin");
    }

    public static String getInitialAdminGroups() {
        return Version.getProperty(INITIAL_ADMIN_GROUPS_KEY, "asadmin");
    }

    public static String getDistributionKey() {
        return Version.getProperty(DISTRIBUTION_KEY, "");
    }

    private static String getProperty(String key, String def) {
        return Version.getProperty(versionProp, key, def);
    }

    private static String getProperty(Properties p, String key, String def) {
        Properties bp;
        if (p == null) {
            return def;
        }
        String v = p.getProperty(key);
        if (v != null) {
            return v;
        }
        String basedon = p.getProperty(BASED_ON_KEY);
        if (basedon != null && (bp = VERSION_PROPS_MAP.get(basedon)) != null) {
            return Version.getProperty(bp, key, def);
        }
        return def;
    }
}

