/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.string;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.BiExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.string.StringFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;

public class TrimFunction
extends BiExpression<String>
implements IdentifiedDataSerializable {
    private static final String SPACE_ONLY = " ";
    private static final CharacterTester SPACE_ONLY_TESTER = new SingleCharacterTester(' ');
    private boolean leading;
    private boolean trailing;

    public TrimFunction() {
    }

    private TrimFunction(Expression<?> input, Expression<?> characters, boolean leading, boolean trailing) {
        super(input, characters);
        this.leading = leading;
        this.trailing = trailing;
    }

    public static TrimFunction create(Expression<?> input, Expression<?> characters, boolean leading, boolean trailing) {
        ConstantExpression characters0;
        if (characters instanceof ConstantExpression && SPACE_ONLY.equals((characters0 = (ConstantExpression)characters).getValue())) {
            characters = null;
        }
        return new TrimFunction(input, characters, leading, trailing);
    }

    @Override
    public String eval(Row row, ExpressionEvalContext context) {
        String characters;
        String input = StringFunctionUtils.asVarchar(this.operand1, row, context);
        if (input == null) {
            return null;
        }
        if (this.operand2 != null) {
            characters = StringFunctionUtils.asVarchar(this.operand2, row, context);
            if (characters == null) {
                return null;
            }
        } else {
            characters = SPACE_ONLY;
        }
        return this.trim(input, characters);
    }

    private String trim(String input, String characters) {
        int from;
        if (input.isEmpty()) {
            return "";
        }
        assert (characters != null);
        if (characters.isEmpty()) {
            return input;
        }
        CharacterTester tester = SPACE_ONLY.equals(characters) ? SPACE_ONLY_TESTER : (characters.length() == 1 ? new SingleCharacterTester(characters.charAt(0)) : new MultipleCharacterTester(characters.toCharArray()));
        int to = input.length();
        if (this.leading) {
            for (from = 0; from < input.length() && tester.test(input.charAt(from)); ++from) {
            }
        }
        if (this.trailing) {
            while (to > from && tester.test(input.charAt(to - 1))) {
                --to;
            }
        }
        if (from == 0 && to == input.length()) {
            return input;
        }
        return input.substring(from, to);
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.VARCHAR;
    }

    public Expression<?> getCharacters() {
        return this.operand2;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 61;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeBoolean(this.leading);
        out.writeBoolean(this.trailing);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.leading = in.readBoolean();
        this.trailing = in.readBoolean();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TrimFunction that = (TrimFunction)o;
        return this.leading == that.leading && this.trailing == that.trailing;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.leading ? 1 : 0);
        result = 31 * result + (this.trailing ? 1 : 0);
        return result;
    }

    private static final class MultipleCharacterTester
    implements CharacterTester {
        private final char[] expected;

        private MultipleCharacterTester(char[] expected) {
            this.expected = expected;
        }

        @Override
        public boolean test(char c) {
            for (char value : this.expected) {
                if (c != value) continue;
                return true;
            }
            return false;
        }
    }

    private static final class SingleCharacterTester
    implements CharacterTester {
        private final char expected;

        private SingleCharacterTester(char expected) {
            this.expected = expected;
        }

        @Override
        public boolean test(char c) {
            return c == this.expected;
        }
    }

    private static interface CharacterTester {
        public boolean test(char var1);
    }
}

